/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.utils;

import com.tydic.ssc.base.bo.BusinessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExcelUtils.class);

    public static List<XSSFRow> readXlsx(InputStream inputStream, int startSheet, int startRow) {
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            xssfWorkbook = new XSSFWorkbook(inputStream);
            for (int numSheet = startSheet; numSheet < xssfWorkbook.getNumberOfSheets(); ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new BusinessException("8888", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("8888", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<XSSFRow> readXlsx(InputStream inputStream, int startSheet, int sheetSize, int startRow) {
        XSSFWorkbook xssfWorkbook = null;
        ArrayList<XSSFRow> xssfRows = new ArrayList<XSSFRow>();
        try {
            xssfWorkbook = new XSSFWorkbook(inputStream);
            if (sheetSize == 0) {
                sheetSize = xssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < sheetSize; ++numSheet) {
                XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(numSheet);
                if (xssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                    XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                    if (xssfRow == null) continue;
                    xssfRows.add(xssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new BusinessException("8888", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("8888", e.getMessage());
        }
        finally {
            try {
                if (null != xssfWorkbook) {
                    xssfWorkbook.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException var18) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + var18.getMessage());
            }
        }
        return xssfRows;
    }

    public static List<HSSFRow> readXls(InputStream inputStream, int startSheet, int startRow) {
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            hssfWorkbook = new HSSFWorkbook(inputStream);
            for (int numSheet = startSheet; numSheet < hssfWorkbook.getNumberOfSheets(); ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new BusinessException("8888", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException var19) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + var19.getMessage());
            throw new BusinessException("8888", var19.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static List<HSSFRow> readXls(InputStream inputStream, int startSheet, int sheetSize, int startRow) {
        HSSFWorkbook hssfWorkbook = null;
        ArrayList<HSSFRow> hssfRows = new ArrayList<HSSFRow>();
        try {
            hssfWorkbook = new HSSFWorkbook(inputStream);
            if (sheetSize == 0) {
                sheetSize = hssfWorkbook.getNumberOfSheets();
            }
            for (int numSheet = startSheet; numSheet < sheetSize; ++numSheet) {
                HSSFSheet hssfSheet = hssfWorkbook.getSheetAt(numSheet);
                if (hssfSheet == null) continue;
                for (int rowNum = startRow; rowNum <= hssfSheet.getLastRowNum(); ++rowNum) {
                    HSSFRow hssfRow = hssfSheet.getRow(rowNum);
                    if (hssfRow == null) continue;
                    hssfRows.add(hssfRow);
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e.getLocalizedMessage());
            throw new BusinessException("8888", "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("8888", e.getMessage());
        }
        finally {
            try {
                if (null != hssfWorkbook) {
                    hssfWorkbook.close();
                }
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return hssfRows;
    }

    public static String cellToString(Cell cell, Boolean isDecimal) {
        String returnValue = "";
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                if (isDecimal.booleanValue()) {
                    returnValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date date = cell.getDateCellValue();
                    SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    returnValue = formater.format(date);
                    break;
                }
                DecimalFormat df = new DecimalFormat("0");
                returnValue = df.format(cell.getNumericCellValue());
                break;
            }
            case STRING: {
                returnValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                boolean booleanValue = cell.getBooleanCellValue();
                returnValue = Boolean.toString(booleanValue);
                break;
            }
            case BLANK: {
                break;
            }
            case FORMULA: {
                returnValue = cell.getCellFormula();
                break;
            }
            case ERROR: {
                break;
            }
        }
        return returnValue;
    }

    public static String getSuffix(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : null;
    }
}

