/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.service.busi.SscAddProjectDetailBusiService;
import com.tydic.sscext.busi.bidding.SscProBatchImportProjectDetailBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProBatchImportProjectDetailBusiReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProBatchImportProjectDetailBusiRspBO;
import com.tydic.sscext.dao.SscProjectDetailProMapper;
import com.tydic.sscext.dao.po.SscProjectDetailProPO;
import com.tydic.sscext.serivce.bidding.bo.SscProjectDetailProBO;
import com.tydic.sscext.utils.ExcelUtils;
import com.tydic.uccext.bo.UccExtQryMaterialDetailAbilityReqBO;
import com.tydic.uccext.bo.UccExtQryMaterialDetailAbilityRspBO;
import com.tydic.uccext.service.UccExtQryMaterialDetailAbilityService;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.ability.user.UmcQryMemByManagementAbilityService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="sscProBatchImportProjectDetailBusiService")
public class SscProBatchImportProjectDetailBusiServiceImpl
implements SscProBatchImportProjectDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProBatchImportProjectDetailBusiServiceImpl.class);
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private SscProjectDetailProMapper sscProjectDetailProMapper;
    @Autowired
    private SscAddProjectDetailBusiService sscAddProjectDetailBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_GROUP_DEV")
    private UccExtQryMaterialDetailAbilityService uccExtQryMaterialDetailAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQryMemByManagementAbilityService umcQryMemByManagementAbilityService;

    @Override
    public SscProBatchImportProjectDetailBusiRspBO batchImportProjectDetail(SscProBatchImportProjectDetailBusiReqBO reqBO) {
        SscProBatchImportProjectDetailBusiRspBO rspBO = new SscProBatchImportProjectDetailBusiRspBO();
        ArrayList<String> materialCodeList = new ArrayList<String>();
        ArrayList<SscProjectDetailProBO> sscProjectDetailBOs = new ArrayList<SscProjectDetailProBO>();
        ArrayList<SscProjectDetailProBO> sscProjectDetailBOs2 = new ArrayList<SscProjectDetailProBO>();
        List<Object> rows = new ArrayList();
        int maxSize = 500;
        InputStream inputStream = this.downloadFile(reqBO.getExcelFileUrl());
        rows = this.getRowsFromFile(inputStream, reqBO.getExcelFileUrl());
        log.error("\u96c6\u5408\u957f\u5ea6==" + rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u518d\u5bfc\u5165");
        }
        for (int i = 0; i < rows.size(); ++i) {
            int colNum = 0;
            Row row = (Row)rows.get(i);
            if (i == 0) {
                String biaoti;
                if ("*\u7269\u6599\u7f16\u7801".equals(biaoti = ExcelUtils.cellToString(row.getCell(colNum++), false))) continue;
                throw new BusinessException("8888", "\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u518d\u5bfc\u5165");
            }
            if (CollectionUtils.isEmpty(rows)) continue;
            SscProjectDetailProBO sscProjectDetailProBO = new SscProjectDetailProBO();
            String materialCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String materialCodeNew = materialCode.replaceAll("\\s*", "");
            log.error("===" + materialCodeNew + "++++");
            if ("".equals(materialCode)) {
                throw new BusinessException("8888", "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!materialCodeList.contains(materialCodeNew)) {
                materialCodeList.add(materialCodeNew);
            }
            sscProjectDetailProBO.setMaterailCode(materialCodeNew);
            String materialName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (materialName == null || "".equals(materialName)) {
                throw new BusinessException("8888", "\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setMaterailName(materialName);
            String measureName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (measureName == null || "".equals(measureName)) {
                throw new BusinessException("8888", "\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setMeasureName(measureName);
            String useDepartmentId = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (useDepartmentId == null || "".equals(useDepartmentId)) {
                throw new BusinessException("8888", "\u8ba1\u5212\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setUseDepartmentId(useDepartmentId);
            String useDepartmentName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (useDepartmentName == null || "".equals(useDepartmentName)) {
                throw new BusinessException("8888", "\u8ba1\u5212\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setUseDepartmentName(useDepartmentName);
            String inspectorId = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (inspectorId == null || "".equals(inspectorId)) {
                throw new BusinessException("8888", "\u9a8c\u8d27\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setInspectorId(inspectorId);
            String inspectorName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            log.debug("\u9a8c\u8d27\u4eba\u540d\u79f0\uff1a" + inspectorName);
            if (inspectorName == null || "".equals(inspectorName)) {
                throw new BusinessException("8888", "\u9a8c\u8d27\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setInspectorName(inspectorName);
            String inspectorTel = ExcelUtils.cellToString(row.getCell(colNum++), false);
            log.debug("\u9a8c\u8d27\u4eba\u7535\u8bdd\uff1a" + inspectorTel);
            if (inspectorTel == null || "".equals(inspectorTel)) {
                throw new BusinessException("8888", "\u9a8c\u8d27\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setInspectorTel(inspectorTel);
            String purchaseNumber = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (purchaseNumber == null || "".equals(purchaseNumber)) {
                throw new BusinessException("8888", "\u91c7\u8d2d\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            sscProjectDetailProBO.setPurchaseNumber(StringUtils.hasText((String)purchaseNumber) ? new BigDecimal(purchaseNumber).setScale(6, 4) : null);
            sscProjectDetailBOs.add(sscProjectDetailProBO);
            if (sscProjectDetailBOs.size() >= 500) break;
        }
        reqBO.setSscProjectDetailBOs(sscProjectDetailBOs);
        rspBO.setSscProjectDetailBOs(sscProjectDetailBOs);
        UccExtQryMaterialDetailAbilityReqBO uReqBo = new UccExtQryMaterialDetailAbilityReqBO();
        uReqBo.setMaterialCodeList(materialCodeList);
        String s = JSONObject.toJSONString((Object)uReqBo);
        log.error("\u8c03\u7528\u5546\u54c1\u5165\u53c2=" + s);
        UccExtQryMaterialDetailAbilityRspBO uRspBo = this.uccExtQryMaterialDetailAbilityService.qryMaterialDetail(uReqBo);
        String rsp = JSONObject.toJSONString((Object)uRspBo);
        log.error("\u8c03\u7528\u5546\u54c1\u51fa\u53c2=" + rsp);
        if (uRspBo != null) {
            List mList = uRspBo.getMaterialDetailInfo();
            ArrayList<String> materialCodeRspList = new ArrayList<String>();
            for (Object ucc : mList) {
                String materialCode = ucc.getMaterialCode();
                if (!materialCodeRspList.contains(materialCode)) {
                    materialCodeRspList.add(materialCode);
                }
                for (SscProjectDetailProBO sbo : sscProjectDetailBOs) {
                    if (!ucc.getMaterialCode().equals(sbo.getMaterailCode())) continue;
                    SscProjectDetailProBO sscProjectDetailBO = new SscProjectDetailProBO();
                    BeanUtils.copyProperties((Object)sbo, (Object)sscProjectDetailBO);
                    sscProjectDetailBO.setMaterailName(ucc.getMaterialName());
                    sscProjectDetailBOs2.add(sscProjectDetailBO);
                }
            }
            StringBuffer sb = new StringBuffer();
            materialCodeList.removeAll(materialCodeRspList);
            if (materialCodeList.size() > 0) {
                for (String materialCodeNew : materialCodeList) {
                    sb.append(materialCodeNew);
                    sb.append(";");
                }
                throw new BusinessException("8888", "\u7269\u6599\u7f16\u7801" + sb.toString() + "\u4e0d\u5b58\u5728");
            }
        }
        for (SscProjectDetailProBO sscProjectDetailProBO : sscProjectDetailBOs2) {
            SscProjectDetailProPO sscProjectDetailProPO = new SscProjectDetailProPO();
            BeanUtils.copyProperties((Object)sscProjectDetailProBO, (Object)sscProjectDetailProPO);
            sscProjectDetailProPO.setProjectId(reqBO.getProjectId());
            sscProjectDetailProPO.setStageId(reqBO.getStageId());
            sscProjectDetailProPO.setProjectDetailId(Sequence.getInstance().nextId());
            int insertFlag = this.sscProjectDetailProMapper.insert(sscProjectDetailProPO);
            if (insertFlag >= 1) continue;
            throw new BusinessException("8888", "\u6279\u91cf\u5bfc\u5165\u660e\u7ec6\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private InputStream downloadFile(String filePath) {
        InputStream inputStream;
        filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
        try {
            inputStream = this.fileClient.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        if (inputStream == null) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        return inputStream;
    }

    private List<Row> getRowsFromFile(InputStream inputStream, String fileUrl) {
        ArrayList<HSSFRow> rows;
        String suffix = ExcelUtils.getSuffix(fileUrl);
        if (!StringUtils.isEmpty((Object)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelUtils.readXls(inputStream, 0, 1, 6);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelUtils.readXlsx(inputStream, 0, 1, 6);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        return rows;
    }

    private static ByteArrayOutputStream cloneInputStream(InputStream input) {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

