/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.fastjson.JSON;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscExternalOutBaseRspBO;
import com.tydic.ssc.service.utils.HttpUtil;
import com.tydic.sscext.busi.bidding.SscProSubmitApprovalBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitApprovalBusiReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitApprovalBusiRspBO;
import com.tydic.sscext.dao.SscProjectProMapper;
import com.tydic.sscext.dao.SscProjectSupplierProMapper;
import com.tydic.sscext.dao.po.SscProjectProPO;
import com.tydic.sscext.serivce.bidding.SscProQryWinBiddingSupplierBaseStageListAbilityService;
import com.tydic.sscext.serivce.bidding.bo.SscErpSubmitApprovalReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQryWinBiddingSupplierBaseStageListAbilityServiceRspBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationStageBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationSupplierBaseStageBO;
import com.tydic.sscext.serivce.bidding.bo.WinBidResultDetailErpReqBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="sscProSubmitApprovalBusiService")
public class SscProSubmitApprovalBusiServiceImpl
implements SscProSubmitApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProSubmitApprovalBusiServiceImpl.class);
    @Autowired
    private SscProjectProMapper sscProjectProMapper;
    @Autowired
    private SscProQryWinBiddingSupplierBaseStageListAbilityService sscProQryWinBiddingSupplierBaseStageListAbilityService;
    @Autowired
    private SscProjectSupplierProMapper sscProjectSupplierProMapper;
    @Value(value="${ERP_PROJECT_CREATE_TENDER_RESULT_URL}")
    private String abilityUri;

    @Override
    public SscProSubmitApprovalBusiRspBO submitApproval(SscProSubmitApprovalBusiReqBO reqBO) {
        SscProSubmitApprovalBusiRspBO rspBO = new SscProSubmitApprovalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SscProjectProPO sscProjectProPO = new SscProjectProPO();
        sscProjectProPO.setProjectId(reqBO.getProjectId());
        sscProjectProPO.setDelStatus("0");
        SscProjectProPO projectDetail = this.sscProjectProMapper.getModelBy(sscProjectProPO);
        SscErpSubmitApprovalReqBO approvalReqBO = new SscErpSubmitApprovalReqBO();
        approvalReqBO.setTendercode(String.valueOf(reqBO.getProjectId()));
        approvalReqBO.setTendername(projectDetail.getProjectName());
        approvalReqBO.setCgdw(projectDetail.getPurchaseUnitName());
        approvalReqBO.setBillmaker(projectDetail.getProjectProducerName());
        approvalReqBO.setZbpl(projectDetail.getProjectCategory());
        approvalReqBO.setPbzl(projectDetail.getBidReviewFile());
        approvalReqBO.setSpk(projectDetail.getBidReviewFile());
        approvalReqBO.setPbdd(projectDetail.getBidReviewAddr());
        approvalReqBO.setZbdw(projectDetail.getPurchaseUnitName());
        approvalReqBO.setGsje(projectDetail.getBudgetAmount().toEngineeringString());
        approvalReqBO.setFkfs("");
        approvalReqBO.setZjly(projectDetail.getExtField6());
        approvalReqBO.setJhq(this.dateTimeForMatToString(projectDetail.getArrivalTime()));
        approvalReqBO.setDhrq(this.dateTimeForMatToString(projectDetail.getArrivalTime()));
        SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO qryBidResReqBO = new SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO();
        qryBidResReqBO.setProjectId(reqBO.getProjectId());
        SscProQryWinBiddingSupplierBaseStageListAbilityServiceRspBO qryBidResRspBO = this.sscProQryWinBiddingSupplierBaseStageListAbilityService.qryWinBiddingSupplierBaseStageList(qryBidResReqBO);
        if ("0000".equals(qryBidResRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528erp\u63d0\u4ea4\u5ba1\u6279:\u4e2d\u6807\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        List winBidResBOS = qryBidResRspBO.getSscProQuotationStageBOList();
        ArrayList<WinBidResultDetailErpReqBO> winBidResDetails = new ArrayList<WinBidResultDetailErpReqBO>();
        for (SscProQuotationStageBO winBidResBO : winBidResBOS) {
            List baseStageBOList = winBidResBO.getSscProQuotationSupplierBaseStageBOList();
            for (SscProQuotationSupplierBaseStageBO bo : baseStageBOList) {
                WinBidResultDetailErpReqBO bidResultDetailErpReqBO = new WinBidResultDetailErpReqBO();
                bidResultDetailErpReqBO.setBdxx(winBidResBO.getStageName());
                bidResultDetailErpReqBO.setTbdw(bo.getSupplierName());
                bidResultDetailErpReqBO.setZczj(bo.getRegistAmount());
                bidResultDetailErpReqBO.setLxr(bo.getBusiLinkMan());
                bidResultDetailErpReqBO.setLxdh(bo.getBusiLinkWay());
                bidResultDetailErpReqBO.setCcbj(bo.getInitialTotalPrice().toEngineeringString());
                bidResultDetailErpReqBO.setZzbj(bo.getEndTotalPrice().toEngineeringString());
                bidResultDetailErpReqBO.setPbbz(bo.getReviewRemark());
                bidResultDetailErpReqBO.setSxbs(bo.getReviewRemark());
                winBidResDetails.add(bidResultDetailErpReqBO);
            }
        }
        approvalReqBO.setZbxq(winBidResDetails);
        String s = JSON.toJSONString((Object)approvalReqBO);
        try {
            if (StringUtils.isEmpty((Object)this.abilityUri)) {
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u8c03\u7528erp\u63a5\u53e3!");
            } else {
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u53c2\u6570\uff1a:" + s);
                String outStr = HttpUtil.httpClient((String)this.abilityUri, (String)s);
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u53c2\u6570\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)outStr));
                SscExternalOutBaseRspBO erpRspBO = (SscExternalOutBaseRspBO)JSON.parseObject((String)outStr, SscExternalOutBaseRspBO.class);
                String RSP_CODE_SUCCESS = "0";
                if (Objects.isNull(erpRspBO) || !"0".equals(erpRspBO.getCode())) {
                    throw new BusinessException("8888", "\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u5931\u8d25 : " + erpRspBO.getMsg());
                }
                sscProjectProPO.setExtField2(reqBO.getAuditCardFile());
                sscProjectProPO.setProjectStatus("11");
                int update = this.sscProjectProMapper.updateById(sscProjectProPO);
                if (update < 1) {
                    throw new BusinessException("8888", "\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4\u5ba1\u6279\u66f4\u65b0\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528erp\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25" + e.getMessage());
        }
        return rspBO;
    }

    private String dateTimeForMatToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String thisTimeString = "";
        if (date != null) {
            try {
                thisTimeString = sdf.format(date);
                return thisTimeString;
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
            }
        }
        throw new BusinessException("8888", "\u65f6\u95f4\u4e3a\u7a7a!");
    }
}

