/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.advice;

import com.alibaba.fastjson.JSON;
import com.tydic.sscext.annotation.LogRecord;
import com.tydic.sscext.dao.SscSysn1688LogMapper;
import com.tydic.sscext.dao.po.SscSysn1688LogPO;
import java.lang.reflect.Method;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogRecordAdvice {
    private static final Logger log = LoggerFactory.getLogger(LogRecordAdvice.class);
    @Autowired
    private SscSysn1688LogMapper sscSysn1688LogMapper;

    @Pointcut(value="@annotation(com.tydic.sscext.annotation.LogRecord)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        this.handleLog(joinPoint, null, jsonResult);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object jsonResult) {
        try {
            LogRecord logRecord = this.getAnnotationLog(joinPoint);
            SscSysn1688LogPO sscSysn1688LogPO = new SscSysn1688LogPO();
            sscSysn1688LogPO.setRequest(this.argsArrayToString(joinPoint.getArgs()));
            if (jsonResult != null) {
                sscSysn1688LogPO.setResponse(JSON.toJSONString((Object)jsonResult));
            } else {
                sscSysn1688LogPO.setResponse(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            sscSysn1688LogPO.setVUser("SYS_AOP");
            sscSysn1688LogPO.setAction(logRecord.name());
            this.buildOrderLog(sscSysn1688LogPO);
        }
        catch (Exception exp) {
            log.error("1688\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
        }
    }

    private LogRecord getAnnotationLog(JoinPoint joinPoint) throws Exception {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(LogRecord.class);
        }
        return null;
    }

    private String argsArrayToString(Object[] paramsArray) {
        String params = "";
        if (paramsArray != null && paramsArray.length > 0) {
            for (int i = 0; i < paramsArray.length; ++i) {
                if (this.isFilterObject(paramsArray[i])) continue;
                Object jsonObj = JSON.toJSON((Object)paramsArray[i]);
                params = params + jsonObj.toString() + " ";
            }
        }
        return params.trim();
    }

    public boolean isFilterObject(Object o) {
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse;
    }

    private void buildOrderLog(SscSysn1688LogPO recordReqBO) {
        recordReqBO.setVTime(new Date());
        this.sscSysn1688LogMapper.insertSelective(recordReqBO);
    }
}

