/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscProjectAttachDAO;
import com.tydic.ssc.dao.po.SscProjectAttachPO;
import com.tydic.ssc.service.utils.HttpUtil;
import com.tydic.sscext.busi.bidding.SscEstoreSyncFileUploadBusiService;
import com.tydic.sscext.busi.bo.bidding.SscEstoreSyncFileUploadReqBO;
import com.tydic.sscext.busi.bo.bidding.SscEstoreSyncFileUploadRspBO;
import com.tydic.sscext.external.bo.open1688.SscAttachmentUploadReqBO;
import com.tydic.sscext.external.bo.open1688.SscAttachmentUploadRspBO;
import com.tydic.sscext.external.open1688.SscAttachmentUploadService;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscEstoreSyncFileUploadBusiServiceImpl
implements SscEstoreSyncFileUploadBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscEstoreSyncFileUploadBusiServiceImpl.class);
    private static final String PATH = "pesapp-common";
    @Autowired
    private SscAttachmentUploadService sscAttachmentUploadService;
    @Autowired
    private FileClient fileClient;
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private SscProjectAttachDAO sscProjectAttachDAO;

    @Override
    public SscEstoreSyncFileUploadRspBO estoreSyncFileUpload(SscEstoreSyncFileUploadReqBO reqBO) {
        this.initParam(reqBO);
        SscEstoreSyncFileUploadRspBO rspBO = new SscEstoreSyncFileUploadRspBO();
        byte[] bytes = null;
        try {
            log.info("\u5f00\u59cb\u5904\u7406\u4e0a\u4f201688\u9644\u4ef6\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)reqBO));
            String filePath = reqBO.getProjectAttachAddress();
            filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
            InputStream inputStream = this.fileClient.downLoadToInputStream(filePath);
            if (null != inputStream) {
                bytes = IOUtils.toByteArray((InputStream)inputStream);
                if (null != bytes) {
                    SscAttachmentUploadReqBO sscAttachmentUploadReqBO = new SscAttachmentUploadReqBO();
                    sscAttachmentUploadReqBO.setName(reqBO.getFileName());
                    sscAttachmentUploadReqBO.setFileBytes(bytes);
                    SscAttachmentUploadRspBO busiRspBO = this.sscAttachmentUploadService.upload1688(sscAttachmentUploadReqBO);
                    log.info("\u540c\u6b651688 \u8fd4\u56de\u53c2\u6570\uff1a{}" + JSON.toJSONString((Object)busiRspBO));
                    if (busiRspBO.getSuccess().booleanValue()) {
                        SscProjectAttachPO sscProjectAttachPO = new SscProjectAttachPO();
                        sscProjectAttachPO.setProjectAttachId(reqBO.getProjectAttachId());
                        sscProjectAttachPO.setAttachId1688(busiRspBO.getId());
                        this.sscProjectAttachDAO.updateByPrimaryKeySelective(sscProjectAttachPO);
                        rspBO.setId(busiRspBO.getId());
                    } else {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u4e0a\u4f201688\u9644\u4ef6\u5931\u8d25!" + busiRspBO.getErrorCode());
                    }
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u83b7\u53d6OSS\u6587\u4ef6\u6d41\u5931\u8d25");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("8888", "\u4eceOSS\u540c\u6b65\u9644\u4ef6\u52301688\u5904\u7406\u5931\u8d25\uff1a");
        }
        return rspBO;
    }

    @Override
    public SscEstoreSyncFileUploadRspBO estoreSyncFileDownload(SscEstoreSyncFileUploadReqBO reqBO) {
        SscEstoreSyncFileUploadRspBO rspBO = new SscEstoreSyncFileUploadRspBO();
        String sourcefileName = reqBO.getFileName();
        String suffix = sourcefileName.substring(sourcefileName.lastIndexOf("."));
        try {
            InputStream inputStream = HttpUtil.httpDownload((String)reqBO.getProjectAttachAddress());
            if (null != inputStream) {
                String fileName = UUID.randomUUID().toString().replaceAll("-", "") + suffix;
                String path = this.fileClient.uploadFileByInputStream(PATH, fileName, inputStream);
                String httphead = "https://";
                if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                    httphead = "http://";
                }
                rspBO.setFileUrl(httphead + this.ossFileUrl + path);
                return rspBO;
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6OSS\u6587\u4ef6\u6d41\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d1688\u6587\u4ef6\u5904\u7406\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("8888", "\u4ece1688\u540c\u6b65\u9644\u4ef6\u5230OSS\u5904\u7406\u5931\u8d25!");
        }
        return rspBO;
    }

    public void initParam(SscEstoreSyncFileUploadReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getProjectAttachId())) {
            throw new BusinessException("0001", "\u5165\u53c2\u3010\u9879\u76ee\u9644\u4ef6ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getProjectAttachAddress())) {
            throw new BusinessException("0001", "\u5165\u53c2\u6587\u4ef6url\u3010\u9644\u4ef6\u5730\u5740\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getFileName()) {
            throw new BusinessException("0001", "\u5165\u53c2\u9879\u76eeid\u3010\u6587\u4ef6\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

