/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.ability.impl.open1688;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectSupplierAttachBO;
import com.tydic.ssc.common.SscSupplierQuotationDetailBO;
import com.tydic.ssc.dao.SscProjectDAO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.ssc.dao.po.SscProjectPO;
import com.tydic.ssc.service.busi.SscSubmitSupQuotationBusiService;
import com.tydic.ssc.service.busi.bo.SscSubmitSupQuotationBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscSubmitSupQuotationBusiRspBO;
import com.tydic.sscext.external.bo.open1688.Attachment;
import com.tydic.sscext.external.bo.open1688.Quotation;
import com.tydic.sscext.external.bo.open1688.SscBuyerGetQuotationListByBuyOfferIdReqBO;
import com.tydic.sscext.external.bo.open1688.SscBuyerGetQuotationListByBuyOfferIdRspBO;
import com.tydic.sscext.external.bo.open1688.SscGetSupplierReqBO;
import com.tydic.sscext.external.bo.open1688.SscGetSupplierRspBO;
import com.tydic.sscext.external.bo.open1688.SupplyNoteItems;
import com.tydic.sscext.external.open1688.SscBuyerGetQuotationListByBuyOfferIdService;
import com.tydic.sscext.external.open1688.SscGetSupplierService;
import com.tydic.sscext.serivce.open1688.SscSupplierQuotationAbilityService;
import com.tydic.sscext.serivce.open1688.bo.SscSupplierQuotationAbilityReqBO;
import com.tydic.sscext.serivce.open1688.bo.SscSupplierQuotationAbilityRspBO;
import com.tydic.umcext.ability.supplier.UmcSupplierInternalRegisteredAbilityService;
import com.tydic.umcext.perf.ability.supplier.bo.UmcSupplierCreateAbilityReqBO;
import com.tydic.umcext.perf.ability.supplier.bo.UmcSupplierRegisteredAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="SSC_GROUP_TEST", serviceInterface=SscSupplierQuotationAbilityService.class)
public class SscSupplierQuotationAbilityServiceImpl
implements SscSupplierQuotationAbilityService {
    @Autowired
    private SscProjectDAO sscProjectDAO;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscGetSupplierService sscGetSupplierService;
    @Autowired
    private SscSubmitSupQuotationBusiService sscSubmitSupQuotationBusiService;
    @Autowired
    private SscBuyerGetQuotationListByBuyOfferIdService sscBuyerGetQuotationListByBuyOfferIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcSupplierInternalRegisteredAbilityService umcSupplierInternalRegisteredAbilityService;

    public SscSupplierQuotationAbilityRspBO supplierQuotation(SscSupplierQuotationAbilityReqBO reqBO) {
        if (reqBO == null || reqBO.getBuyOfferId() == null) {
            throw new BusinessException("0001", "1688\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO == null || reqBO.getQuotationId() == null) {
            throw new BusinessException("0001", "1688\u62a5\u4ef7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupplierMemberId())) {
            throw new BusinessException("0001", "1688\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SscProjectPO record = new SscProjectPO();
        record.setBuyOfferId(reqBO.getBuyOfferId());
        SscProjectPO sscProject = this.sscProjectDAO.getModelBy(record);
        if (null == sscProject) {
            throw new BusinessException("8888", "\u67e5\u8be2\u9879\u76ee\u4e3a\u7a7a!");
        }
        SscBuyerGetQuotationListByBuyOfferIdReqBO sscBuyerGetQuotationListByBuyOfferIdReqBO = new SscBuyerGetQuotationListByBuyOfferIdReqBO();
        sscBuyerGetQuotationListByBuyOfferIdReqBO.setBuyofferId(record.getBuyOfferId());
        SscBuyerGetQuotationListByBuyOfferIdRspBO sscBuyerGetQuotationListByBuyOfferIdRspBO = this.sscBuyerGetQuotationListByBuyOfferIdService.buyerGetQuotationListByBuyOfferId(sscBuyerGetQuotationListByBuyOfferIdReqBO);
        if ("1".equals(sscBuyerGetQuotationListByBuyOfferIdRspBO.getRespCode())) {
            throw new BusinessException("8888", sscBuyerGetQuotationListByBuyOfferIdRspBO.getRespDesc());
        }
        List quotationStream = sscBuyerGetQuotationListByBuyOfferIdRspBO.getQuotationList().stream().filter(e -> reqBO.getQuotationId().equals(e.getId())).collect(Collectors.toList());
        SscGetSupplierReqBO sscGetSupplierReqBO = new SscGetSupplierReqBO();
        sscGetSupplierReqBO.setMemberId(reqBO.getSupplierMemberId());
        SscGetSupplierRspBO supplier = this.sscGetSupplierService.getSupplier(sscGetSupplierReqBO);
        if ("1".equals(supplier.getRespCode())) {
            throw new BusinessException("8888", supplier.getRespDesc());
        }
        UmcSupplierCreateAbilityReqBO umcSupplierCreateAbilityReqBO = new UmcSupplierCreateAbilityReqBO();
        umcSupplierCreateAbilityReqBO.setMemName2(supplier.getData().getAccountContactName());
        umcSupplierCreateAbilityReqBO.setRegEmail(supplier.getData().getAccountContactEmail());
        umcSupplierCreateAbilityReqBO.setPhoneNumber(supplier.getData().getAccountContactPhone());
        umcSupplierCreateAbilityReqBO.setSex(Integer.valueOf(supplier.getData().getGender().equals("M") ? 2 : 1));
        umcSupplierCreateAbilityReqBO.setRegAccount(supplier.getData().getLoginId());
        umcSupplierCreateAbilityReqBO.setOrgCode(supplier.getData().getSupplierCompanyModel().getCreditCode());
        umcSupplierCreateAbilityReqBO.setRegMobile(supplier.getData().getAccountContactMobile());
        umcSupplierCreateAbilityReqBO.setSupplierName(supplier.getData().getSupplierCompanyModel().getCompanyName());
        UmcSupplierRegisteredAbilityRspBO umcSupplierRegisteredAbilityRspBO = this.umcSupplierInternalRegisteredAbilityService.dealSupplierInternalRegistered(umcSupplierCreateAbilityReqBO);
        if ("8888".equals(umcSupplierRegisteredAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", umcSupplierRegisteredAbilityRspBO.getRespDesc());
        }
        Long supplierId = umcSupplierRegisteredAbilityRspBO.getOrgId();
        String supplierName = supplier.getData().getSupplierCompanyModel().getCompanyName();
        SscSubmitSupQuotationBusiReqBO sscSubmitSupQuotationBusiReqBO = this.addSupplier((Quotation)quotationStream.get(0), sscProject.getProjectId(), supplierId, supplierName);
        SscSubmitSupQuotationBusiRspBO sscSubmitSupQuotationBusiRspBO = this.sscSubmitSupQuotationBusiService.dealSubmitSupQuotation(sscSubmitSupQuotationBusiReqBO);
        if ("8888".equals(sscSubmitSupQuotationBusiRspBO.getRespCode())) {
            throw new BusinessException("8888", sscSubmitSupQuotationBusiRspBO.getRespDesc());
        }
        SscSupplierQuotationAbilityRspBO rspBO = new SscSupplierQuotationAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private SscSubmitSupQuotationBusiReqBO addSupplier(Quotation quotation, Long projectId, Long supplierId, String supplierName) {
        SscSubmitSupQuotationBusiReqBO sscSubmitSupQuotationBusiReqBO = new SscSubmitSupQuotationBusiReqBO();
        sscSubmitSupQuotationBusiReqBO.setProjectId(projectId);
        sscSubmitSupQuotationBusiReqBO.setQuotationRound(Integer.valueOf(1));
        sscSubmitSupQuotationBusiReqBO.setSupplierId(supplierId);
        sscSubmitSupQuotationBusiReqBO.setSupplierName(supplierName);
        ArrayList<SscSupplierQuotationDetailBO> sscSupplierQuotationDetailList = new ArrayList<SscSupplierQuotationDetailBO>(quotation.getSupplyNoteItems().size());
        List<SupplyNoteItems> supplyNoteItems = quotation.getSupplyNoteItems();
        for (SupplyNoteItems supplyNoteItem : supplyNoteItems) {
            List<Attachment> attachments;
            SscProjectDetailPO sscProjectDetailPO = this.sscProjectDetailDAO.selectByPrimaryKey(Long.valueOf(supplyNoteItem.getPrItemId()));
            if (null == sscProjectDetailPO) continue;
            SscSupplierQuotationDetailBO sscSupplierQuotationDetailBO = new SscSupplierQuotationDetailBO();
            sscSupplierQuotationDetailBO.setProjectDetailId(sscProjectDetailPO.getProjectDetailId());
            sscSupplierQuotationDetailBO.setBrandname(supplyNoteItem.getBrandName());
            sscSupplierQuotationDetailBO.setQuotationUnitPriceBigDecimal(supplyNoteItem.getPriceNew());
            sscSupplierQuotationDetailBO.setQuotationNum(new BigDecimal(supplyNoteItem.getAmount()));
            if (StringUtils.isNotBlank((CharSequence)supplyNoteItem.getTaxRate())) {
                sscSupplierQuotationDetailBO.setTaxRate(new BigDecimal(supplyNoteItem.getTaxRate()));
            }
            if (!CollectionUtils.isEmpty(attachments = quotation.getAttachments())) {
                SscProjectSupplierAttachBO sscProjectSupplierAttachBO = new SscProjectSupplierAttachBO();
                sscProjectSupplierAttachBO.setSupplierAttachAddress(attachments.get(0).getDisplayName());
                sscProjectSupplierAttachBO.setSupplierAttachName(attachments.get(0).getFileUrl());
                sscSupplierQuotationDetailBO.setSscProjectSupplierAttachBO(sscProjectSupplierAttachBO);
            }
            sscSupplierQuotationDetailList.add(sscSupplierQuotationDetailBO);
        }
        sscSubmitSupQuotationBusiReqBO.setSscSupplierQuotationDetailBOs(sscSupplierQuotationDetailList);
        return sscSubmitSupQuotationBusiReqBO;
    }
}

