/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.external.impl.open1688;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.annotation.LogRecord;
import com.tydic.sscext.external.bo.open1688.BaseResult;
import com.tydic.sscext.external.bo.open1688.BatchAddOrUpdateErpProductResult;
import com.tydic.sscext.external.bo.open1688.ErpProducts;
import com.tydic.sscext.external.bo.open1688.SscBatchAddOrUpdateErpProductsReqBO;
import com.tydic.sscext.external.open1688.SscBatchAddOrUpdateErpProductsService;
import com.tydic.sscext.utils.CommonUtil;
import com.tydic.sscext.utils.PropertiesUtil;
import com.tydic.sscext.utils.http.HSHttpHelper;
import com.tydic.sscext.utils.http.HSNHttpHeader;
import com.tydic.sscext.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscBatchAddOrUpdateErpProductsServiceImpl
implements SscBatchAddOrUpdateErpProductsService {
    private static final Logger log = LoggerFactory.getLogger(SscBatchAddOrUpdateErpProductsServiceImpl.class);
    @Value(value="${esb.erp.mock.switch:false}")
    private Boolean esbErpMockSwitch;
    @Value(value="${open.1688.accesstoken:0f9b4c8b-90ad-4b83-9b53-57ca77b8ea35}")
    private String accessToken;
    @Value(value="${open.1688.apikey:6051840}")
    private String apiKey;
    @Value(value="${open.1688.appSecret:Ov2hs4wIdX3}")
    private String appSecret;
    private final String urlPath = "param2/1/cn.alibaba.open/alibaba.caigou.product.batchAddOrUpdateErpProducts/";

    @Override
    @LogRecord(name="batchAddOrUpdateProducts")
    public BaseResult<BatchAddOrUpdateErpProductResult> batchAddOrUpdateProducts(SscBatchAddOrUpdateErpProductsReqBO reqBo) {
        BaseResult<BatchAddOrUpdateErpProductResult> rspBo;
        if (this.esbErpMockSwitch.booleanValue()) {
            log.debug("1688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599mock\u5206\u652f");
            return this.mockData(reqBo);
        }
        List<ErpProducts> erpProductsList = reqBo.getCoopParams();
        if (erpProductsList == null || erpProductsList.size() == 0) {
            throw new BusinessException("1", "\u8c03\u75281688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        String jsonList = JSONObject.toJSONString(erpProductsList);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("coopParams", jsonList);
            String reqStr = CommonUtil.getAllString("param2/1/cn.alibaba.open/alibaba.caigou.product.batchAddOrUpdateErpProducts/" + this.apiKey, params, this.appSecret, this.accessToken);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_1688_BATCH_ADD_UPDATE_PRODUCTS_URL")), HSNHttpHeader.getRequestHeaders("form"), reqStr.toString().getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new BusinessException("1", httpRetBean.getStr());
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("1", "\u8c03\u75281688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBo = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u75281688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException("1", e.getMessage());
            }
            throw new BusinessException("1", "\u8c03\u75281688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBo;
    }

    private BaseResult<BatchAddOrUpdateErpProductResult> mockData(SscBatchAddOrUpdateErpProductsReqBO reqBo) {
        BaseResult<BatchAddOrUpdateErpProductResult> rsp = new BaseResult<BatchAddOrUpdateErpProductResult>();
        return rsp;
    }

    private BaseResult<BatchAddOrUpdateErpProductResult> resolveRsp(String returnString) {
        log.debug("\u8c03\u75281688\u6279\u91cf\u65b0\u589e/\u4fee\u6539erp\u7269\u6599\u8fd4\u56de\u6570\u636e:{}", (Object)returnString);
        return (BaseResult)((Object)JSONObject.parseObject((String)returnString, (TypeReference)new TypeReference<BaseResult<BatchAddOrUpdateErpProductResult>>(){}, (Feature[])new Feature[0]));
    }
}

