/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.busi.bidding.SscProSubmitRoundQuotationBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitRoundQuotationBusiServiceReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitRoundQuotationBusiServiceRspBO;
import com.tydic.sscext.dao.SscProjectSupplierProMapper;
import com.tydic.sscext.dao.SscSupplierQuotationDetailProMapper;
import com.tydic.sscext.dao.SscSupplierQuotationProMapper;
import com.tydic.sscext.dao.po.SscProjectSupplierProPO;
import com.tydic.sscext.dao.po.SscSupplierQuotationDetailProPO;
import com.tydic.sscext.dao.po.SscSupplierQuotationProPO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationDetailInfo;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscProSubmitRoundQuotationBusiServiceImpl
implements SscProSubmitRoundQuotationBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProSubmitRoundQuotationBusiServiceImpl.class);
    @Autowired
    private SscProjectSupplierProMapper sscProjectSupplierProMapper;
    @Autowired
    private SscSupplierQuotationProMapper sscSupplierQuotationProMapper;
    @Autowired
    private SscSupplierQuotationDetailProMapper sscSupplierQuotationDetailProMapper;

    @Override
    public SscProSubmitRoundQuotationBusiServiceRspBO submitQuotation(SscProSubmitRoundQuotationBusiServiceReqBO reqBO) {
        SscProSubmitRoundQuotationBusiServiceRspBO rspBO = new SscProSubmitRoundQuotationBusiServiceRspBO();
        SscProjectSupplierProPO modelProjectSupplierProPO = new SscProjectSupplierProPO();
        modelProjectSupplierProPO.setProjectSupplierId(reqBO.getProjectSupplierId());
        modelProjectSupplierProPO = this.sscProjectSupplierProMapper.getModelBy(modelProjectSupplierProPO);
        if (modelProjectSupplierProPO.getRoundsOfferEndTime() != null && modelProjectSupplierProPO.getRoundsOfferEndTime().compareTo(new Date()) <= 0) {
            throw new BusinessException("8888", "\u591a\u8f6e\u62a5\u4ef7\u622a\u6b62\u65e5\u671f\u5df2\u8fc7\uff0c\u65e0\u6cd5\u8fdb\u884c\u591a\u8f6e\u62a5\u4ef7\uff01");
        }
        BigDecimal supplierTaxTotalPrice = BigDecimal.ZERO;
        BigDecimal supplierTotalQuotationPrice = BigDecimal.ZERO;
        for (SscProQuotationInfo quotationInfo : reqBO.getQuotationInfoList()) {
            ArrayList<SscSupplierQuotationDetailProPO> quotationDetailProPOList = new ArrayList<SscSupplierQuotationDetailProPO>();
            BigDecimal quotationTaxTotalPrice = BigDecimal.ZERO;
            BigDecimal quotationTotalQuotationPrice = BigDecimal.ZERO;
            for (SscProQuotationDetailInfo quotationDetailInfo : quotationInfo.getQuotationDetailInfoList()) {
                SscSupplierQuotationDetailProPO PO = new SscSupplierQuotationDetailProPO();
                PO.setProjectDetailId(quotationDetailInfo.getProjectDetailId());
                PO.setProjectId(quotationInfo.getProjectId());
                PO.setStageId(quotationInfo.getStageId());
                PO.setSupplierId(quotationInfo.getSupplierId());
                PO = this.sscSupplierQuotationDetailProMapper.getRound(PO);
                if (PO == null) {
                    throw new BusinessException("8888", "\u62a5\u4ef7\u8f6e\u6b21\u67e5\u8be2\u5f02\u5e38\uff01");
                }
                SscSupplierQuotationDetailProPO quotationDetailProPO = new SscSupplierQuotationDetailProPO();
                BeanUtils.copyProperties((Object)quotationDetailInfo, (Object)quotationDetailProPO);
                quotationDetailProPO.setProjectId(quotationInfo.getProjectId());
                quotationDetailProPO.setStageId(quotationInfo.getStageId());
                quotationDetailProPO.setSupplierId(quotationInfo.getSupplierId());
                quotationDetailProPO.setSupplierName(quotationInfo.getSupplierName());
                quotationDetailProPO.setQuotationDetailId(Sequence.getInstance().nextId());
                quotationDetailProPO.setQuotationId(PO.getQuotationId());
                quotationDetailProPO.setQuotationRound(PO.getQuotationRound());
                BigDecimal quotationUnitPrice = quotationDetailInfo.getQuotationUnitPrice().multiply(new BigDecimal("10000"));
                quotationDetailProPO.setQuotationUnitPrice(quotationUnitPrice.longValue());
                BigDecimal noTaxUnitPrice = quotationUnitPrice.divide(BigDecimal.ONE.add(quotationDetailInfo.getTaxRate()), 2, 4);
                quotationDetailProPO.setNoTaxUnitPrice(noTaxUnitPrice.longValue());
                BigDecimal taxTotalPrice = quotationDetailInfo.getQuotationNum().multiply(noTaxUnitPrice);
                quotationDetailProPO.setTaxTotalPrice(taxTotalPrice.longValue());
                BigDecimal totalQuotationPrice = quotationDetailInfo.getQuotationNum().multiply(quotationUnitPrice);
                quotationDetailProPO.setTotalQuotationPrice(totalQuotationPrice.longValue());
                quotationDetailProPO.setOperId(reqBO.getMemIdIn());
                quotationDetailProPO.setOperName(reqBO.getName());
                quotationDetailProPO.setOperTime(new Date());
                quotationDetailProPO.setQuotationDetailStatus("1");
                quotationDetailProPO.setDelStatus("0");
                quotationDetailProPOList.add(quotationDetailProPO);
                quotationTaxTotalPrice = quotationTaxTotalPrice.add(taxTotalPrice);
                quotationTotalQuotationPrice = quotationTotalQuotationPrice.add(totalQuotationPrice);
            }
            SscSupplierQuotationProPO quotationProPO = new SscSupplierQuotationProPO();
            quotationProPO.setTaxTotalPrice(quotationTaxTotalPrice.longValue());
            quotationProPO.setTotalQuotationPrice(quotationTotalQuotationPrice.longValue());
            quotationProPO.setEndTotalPrice(quotationProPO.getTotalQuotationPrice());
            supplierTaxTotalPrice = supplierTaxTotalPrice.add(quotationTaxTotalPrice);
            supplierTotalQuotationPrice = supplierTotalQuotationPrice.add(quotationTotalQuotationPrice);
            quotationProPO.setWinBidStatus("1");
            quotationProPO.setQuotationStatus("1");
            quotationProPO.setDelStatus("0");
            SscSupplierQuotationProPO whereQuotationProPO = new SscSupplierQuotationProPO();
            whereQuotationProPO.setProjectId(reqBO.getProjectId());
            whereQuotationProPO.setStageId(quotationInfo.getStageId());
            whereQuotationProPO.setSupplierId(quotationInfo.getSupplierId());
            int var1 = this.sscSupplierQuotationProMapper.updateBy(quotationProPO, whereQuotationProPO);
            if (var1 < 1) {
                throw new BusinessException("8888", "\u66f4\u65b0\u62a5\u4ef7\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            try {
                this.sscSupplierQuotationDetailProMapper.insertBatch(quotationDetailProPOList);
            }
            catch (Exception e) {
                log.debug("\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff1a[{}]", (Object)e.getMessage());
                throw new BusinessException("8888", "\u65b0\u589e\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff01");
            }
        }
        SscProjectSupplierProPO projectSupplierProPO = new SscProjectSupplierProPO();
        projectSupplierProPO.setProjectSupplierId(reqBO.getProjectSupplierId());
        projectSupplierProPO.setDeliveryDate(reqBO.getDeliveryDate());
        projectSupplierProPO.setTaxTotalPrice(supplierTaxTotalPrice.longValue());
        projectSupplierProPO.setTotalQuotationPrice(supplierTotalQuotationPrice.longValue());
        projectSupplierProPO.setTenderFile(reqBO.getTenderFile());
        projectSupplierProPO.setProjectSupplierStatus("7");
        int var2 = this.sscProjectSupplierProMapper.updateById(projectSupplierProPO);
        if (var2 < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u591a\u8f6e\u62a5\u4ef7\u63d0\u4ea4\u6210\u529f");
        return rspBO;
    }
}

