/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.external.impl.open1688;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.sscext.annotation.LogRecord;
import com.tydic.sscext.external.bo.open1688.SscAddUserErpCategoryReqBO;
import com.tydic.sscext.external.bo.open1688.SscCategory;
import com.tydic.sscext.external.open1688.SscAddUserErpCategoryService;
import com.tydic.sscext.utils.CommonUtil;
import com.tydic.sscext.utils.PropertiesUtil;
import com.tydic.sscext.utils.http.HSHttpHelper;
import com.tydic.sscext.utils.http.HSNHttpHeader;
import com.tydic.sscext.utils.http.HttpRetBean;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SscAddUserErpCategoryServiceImpl
implements SscAddUserErpCategoryService {
    private static final Logger log = LoggerFactory.getLogger(SscAddUserErpCategoryServiceImpl.class);
    @Value(value="${esb.erp.mock.switch:false}")
    private Boolean esbErpMockSwitch;
    @Value(value="${open.1688.accesstoken:0f9b4c8b-90ad-4b83-9b53-57ca77b8ea35}")
    private String accessToken;
    @Value(value="${open.1688.apikey:6051840}")
    private String apiKey;
    @Value(value="${open.1688.appSecret:Ov2hs4wIdX3}")
    private String appSecret;
    private final String urlPath = "param2/1/cn.alibaba.open/alibaba.caigou.category.addUserErpCategory/";

    @Override
    @LogRecord(name="addCategory")
    public HashMap<String, String> addCategory(SscAddUserErpCategoryReqBO reqBo) {
        HashMap rspBo;
        if (this.esbErpMockSwitch.booleanValue()) {
            log.debug("1688\u521b\u5efaerp\u7c7b\u76eemock\u5206\u652f");
            return this.mockData(reqBo);
        }
        List<SscCategory> categoryList = reqBo.getCategoryList();
        if (categoryList == null || categoryList.size() == 0) {
            throw new BusinessException("1", "\u8c03\u75281688\u521b\u5efaerp\u7c7b\u76ee\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        String jsonList = JSONObject.toJSONString(categoryList);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("categoryList", jsonList);
            String reqStr = CommonUtil.getAllString("param2/1/cn.alibaba.open/alibaba.caigou.category.addUserErpCategory/" + this.apiKey, params, this.appSecret, this.accessToken);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_1688_ADD_USER_CATEGORY_URL")), HSNHttpHeader.getRequestHeaders("form"), reqStr.toString().getBytes(StandardCharsets.UTF_8), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                throw new BusinessException("1", httpRetBean.getStr());
            }
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new BusinessException("1", "\u8c03\u75281688\u65b0\u589eerp\u7c7b\u76ee\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            rspBo = this.resolveRsp(returnString);
        }
        catch (Exception e) {
            log.error("\u8c03\u75281688\u65b0\u589eerp\u7c7b\u76ee\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            if (e instanceof BusinessException) {
                throw new BusinessException("1", e.getMessage());
            }
            throw new BusinessException("1", "\u8c03\u75281688\u65b0\u589eerp\u7c7b\u76ee\u4fe1\u606f\u5f02\u5e38");
        }
        return rspBo;
    }

    private HashMap<String, String> mockData(SscAddUserErpCategoryReqBO reqBo) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return hashMap;
    }

    private HashMap resolveRsp(String returnString) {
        log.debug("\u8c03\u75281688\u65b0\u589eerp\u7c7b\u76ee\u8fd4\u56de\u6570\u636e:{}", (Object)returnString);
        HashMap hashMap = (HashMap)JSON.parseObject((String)returnString, HashMap.class);
        return hashMap;
    }
}

