/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectDetailBO;
import com.tydic.ssc.dao.SscProjectDetailDAO;
import com.tydic.ssc.dao.SscProjectDetailExtDAO;
import com.tydic.ssc.dao.po.SscProjectDetailExtPO;
import com.tydic.ssc.dao.po.SscProjectDetailPO;
import com.tydic.sscext.busi.bidding.SscBatchImportSupplierQuotationBusiService;
import com.tydic.sscext.busi.bo.bidding.SscBatchImportSupplierQuotationBusiServiceReqBO;
import com.tydic.sscext.busi.bo.bidding.SscBatchImportSupplierQuotationBusiServiceRspBO;
import com.tydic.sscext.utils.ExcelUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SscBatchImportSupplierQuotationBusiServiceImpl
implements SscBatchImportSupplierQuotationBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscBatchImportSupplierQuotationBusiServiceImpl.class);
    @Value(value="${oss.accessUrl:}")
    private String ossAccessUrl;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private SscProjectDetailDAO sscProjectDetailDAO;
    @Autowired
    private SscProjectDetailExtDAO sscProjectDetailExtDAO;

    @Override
    public SscBatchImportSupplierQuotationBusiServiceRspBO batchImportSupplierQuotation(SscBatchImportSupplierQuotationBusiServiceReqBO reqBO) {
        SscBatchImportSupplierQuotationBusiServiceRspBO rspBO = new SscBatchImportSupplierQuotationBusiServiceRspBO();
        ArrayList<SscProjectDetailBO> sscProjectDetailBOs = new ArrayList<SscProjectDetailBO>();
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        if (reqBO.getExcelFileUrl() == null || "".equals(reqBO.getExcelFileUrl())) {
            throw new BusinessException("8888", "\u6587\u4ef6url\u5165\u53c2\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        String substringURl = reqBO.getExcelFileUrl().substring(reqBO.getExcelFileUrl().lastIndexOf(".") + 1);
        if (!"xlsx".equalsIgnoreCase(substringURl)) {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        SscProjectDetailPO sscProjectDetailPO = new SscProjectDetailPO();
        sscProjectDetailPO.setProjectId(reqBO.getProjectId());
        List projectDetailList = this.sscProjectDetailDAO.getList(sscProjectDetailPO);
        if (CollectionUtils.isEmpty((Collection)projectDetailList)) {
            throw new BusinessException("8888", "\u6839\u636e\u9879\u76eeID\u67e5\u8be2\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a!");
        }
        List projectDetailIdList = projectDetailList.stream().map(SscProjectDetailPO::getProjectDetailId).collect(Collectors.toList());
        Map<Long, SscProjectDetailPO> projectDetailIdMap = projectDetailList.stream().collect(Collectors.toMap(SscProjectDetailPO::getProjectDetailId, sPdPO -> sPdPO, (o1, o2) -> o1));
        InputStream inputStream = this.downloadFile(reqBO.getExcelFileUrl());
        List<Row> rows = this.getRowsFromFile(inputStream, reqBO.getExcelFileUrl());
        log.error("\u96c6\u5408\u957f\u5ea6==" + rows.size());
        if (CollectionUtils.isEmpty(rows)) {
            throw new BusinessException("8888", "\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u518d\u5bfc\u5165");
        }
        for (int i = 0; i < rows.size(); ++i) {
            String taxRate;
            int colNum = 0;
            Row row = rows.get(i);
            if (i == 0) {
                String row4 = ExcelUtils.cellToString(row.getCell(4), false);
                String row5 = ExcelUtils.cellToString(row.getCell(5), false);
                String row6 = ExcelUtils.cellToString(row.getCell(6), false);
                if ("\u54c1\u724c/\u751f\u4ea7\u5546\uff08\u5fc5\u586b\uff09".equals(row4) || "\u542b\u7a0e\u5355\u4ef7\uff08\u5fc5\u586b\uff09".equals(row5) || "\u7a0e\u7387\uff08\u5fc5\u586b\uff09".equals(row6)) continue;
                throw new BusinessException("8888", "\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u5148\u4e0b\u8f7d\u6a21\u677f\u518d\u5bfc\u5165");
            }
            if (CollectionUtils.isEmpty(rows)) continue;
            SscProjectDetailBO sscProjectDetailBO = new SscProjectDetailBO();
            String rownumber = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String materialCode = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String materialName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String measureName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String brandName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setBrandName(brandName);
            String taxUnitPrice = row.getCell(colNum++).getNumericCellValue() + "";
            if (StringUtils.isNotBlank((CharSequence)taxUnitPrice)) {
                if (!taxUnitPrice.matches("([1-9]+[0-9]*|0)(\\.[\\d]+)?")) {
                    throw new BusinessException("8888", "\u542b\u7a0e\u5355\u4ef7\u4ec5\u652f\u6301\u6570\u5b57\uff01");
                }
                sscProjectDetailBO.setTaxUnitPrice(new BigDecimal(taxUnitPrice));
            }
            if (StringUtils.isNotBlank((CharSequence)(taxRate = row.getCell(colNum++).getNumericCellValue() + "")) && !taxRate.matches("([1-9]+[0-9]*|0)(\\.[\\d]+)?")) {
                throw new BusinessException("8888", "\u7a0e\u7387\u4ec5\u652f\u6301\u6570\u5b57\uff01");
            }
            sscProjectDetailBO.setTaxRate(taxRate);
            String singleWeight = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setSingleWeight(singleWeight);
            String thickness = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setThickness(thickness);
            String material = ExcelUtils.cellToString(row.getCell(colNum++), false);
            sscProjectDetailBO.setMaterial(material);
            String totalTaxPrice = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String model = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String purchaseNumber = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String field9Value = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String field10Value = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String materialLongName = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String remark = ExcelUtils.cellToString(row.getCell(colNum++), false);
            String projectDetailId = ExcelUtils.cellToString(row.getCell(colNum++), false);
            if (StringUtils.isBlank((CharSequence)projectDetailId)) {
                throw new BusinessException("8888", "\u5e8f\u5217\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4e0b\u8f7d\u539f\u59cb\u6587\u4ef6\uff01");
            }
            Long projectDetailIdLong = Long.valueOf(projectDetailId);
            if (!projectDetailIdList.contains(projectDetailIdLong)) {
                throw new BusinessException("8888", "\u7269\u6599\u660e\u7ec6\u5e8f\u5217\u53f7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4e0b\u8f7d\u6587\u4ef6\u540e\u518d\u8bd5\uff01");
            }
            SscProjectDetailPO sscProjectDetailPO1 = projectDetailIdMap.get(projectDetailIdLong);
            sscProjectDetailBO.setMaterailCode(sscProjectDetailPO1.getMaterailCode());
            sscProjectDetailBO.setMaterailName(sscProjectDetailPO1.getMaterailName());
            sscProjectDetailBO.setMeasureName(sscProjectDetailPO1.getMeasureName());
            sscProjectDetailBO.setModel(sscProjectDetailPO1.getModel());
            sscProjectDetailBO.setPurchaseNumber(sscProjectDetailPO1.getPurchaseNumber());
            SscProjectDetailExtPO qryParam = new SscProjectDetailExtPO();
            qryParam.setProjectDetailId(projectDetailIdLong);
            SscProjectDetailExtPO qryResult = this.sscProjectDetailExtDAO.getModelBy(qryParam);
            if (null != qryResult) {
                sscProjectDetailBO.setField9Value(qryResult.getField4Value());
                sscProjectDetailBO.setField10Value(qryResult.getField5Value());
            }
            sscProjectDetailBO.setMaterailLongName(sscProjectDetailPO1.getMaterailLongName());
            sscProjectDetailBO.setRemark(sscProjectDetailPO1.getRemark());
            sscProjectDetailBO.setProjectDetailId(projectDetailIdLong);
            sscProjectDetailBOs.add(sscProjectDetailBO);
        }
        rspBO.setSscProjectDetailList(sscProjectDetailBOs);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private InputStream downloadFile(String filePath) {
        InputStream inputStream;
        filePath = filePath.replace(this.ossAccessUrl, "").replace(this.ossFileUrl, "").replace("https://", "").replace("http://", "");
        try {
            inputStream = this.fileClient.downLoadToInputStream(filePath);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        if (inputStream == null) {
            throw new ZTBusinessException("\u8bfb\u53d6\u4e0d\u5230\u6587\u4ef6\u3010" + filePath + "\u3011\uff01");
        }
        return inputStream;
    }

    private List<Row> getRowsFromFile(InputStream inputStream, String fileUrl) {
        ArrayList<HSSFRow> rows;
        String suffix = ExcelUtils.getSuffix(fileUrl);
        if (!StringUtils.isEmpty((CharSequence)suffix)) {
            suffix = suffix.toLowerCase();
        }
        if ("xls".equals(suffix)) {
            List<HSSFRow> hssfRows = ExcelUtils.readXls(inputStream, 0, 1, 3);
            rows = new ArrayList<HSSFRow>(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List<XSSFRow> xssfRows = ExcelUtils.readXlsx(inputStream, 0, 1, 3);
            rows = new ArrayList<XSSFRow>(xssfRows);
        } else {
            throw new BusinessException("8888", "\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9,\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f\uff01");
        }
        return rows;
    }
}

