/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.dao.SscCreateSupplierLogDAO;
import com.tydic.ssc.dao.SscProjectSupplierDAO;
import com.tydic.ssc.dao.SscSupplierAttachDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDetailDAO;
import com.tydic.ssc.dao.po.SscProjectSupplierPO;
import com.tydic.ssc.dao.po.SscSupplierMemberLogPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationDetailPO;
import com.tydic.ssc.dao.po.SscSupplierQuotationPO;
import com.tydic.ssc.service.busi.SscUpdateXunBiJiaProjectSupplierWinBidStatusBusiService;
import com.tydic.sscext.busi.bidding.SscCreatePtSupplierBusiService;
import com.tydic.sscext.busi.bo.bidding.SscCreatePtSupplierBusiReqBO;
import com.tydic.sscext.external.bo.open1688.SscGetSupplierReqBO;
import com.tydic.sscext.external.bo.open1688.SscGetSupplierRspBO;
import com.tydic.sscext.external.bo.open1688.SupplierAccountOceanModel;
import com.tydic.sscext.external.open1688.SscGetSupplierService;
import com.tydic.umcext.ability.supplier.UmcSupplierInternalRegisteredAbilityService;
import com.tydic.umcext.perf.ability.supplier.bo.UmcSupplierCreateAbilityReqBO;
import com.tydic.umcext.perf.ability.supplier.bo.UmcSupplierRegisteredAbilityRspBO;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscCreatePtSupplierBusiServiceImpl
implements SscCreatePtSupplierBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscCreatePtSupplierBusiServiceImpl.class);
    @Autowired
    private SscGetSupplierService sscGetSupplierService;
    @Autowired
    SscUpdateXunBiJiaProjectSupplierWinBidStatusBusiService sscUpdateXunBiJiaProjectSupplierWinBidStatusBusiService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    UmcSupplierInternalRegisteredAbilityService umcSupplierInternalRegisteredAbilityService;
    @Autowired
    SscSupplierQuotationDetailDAO sscSupplierQuotationDetailDAO;
    @Autowired
    SscSupplierQuotationDAO sscSupplierQuotationDAO;
    @Autowired
    SscProjectSupplierDAO sscProjectSupplierDAO;
    @Autowired
    SscCreateSupplierLogDAO sscCreateSupplierLogDAO;
    @Autowired
    SscSupplierAttachDAO sscSupplierAttachDAO;

    @Override
    public void createPtSupplier(SscCreatePtSupplierBusiReqBO reqBO) {
        this.creatMember(reqBO);
    }

    public void creatMember(SscCreatePtSupplierBusiReqBO reqBO) {
        List<String> memberIds = reqBO.getMemberIds();
        if (!memberIds.isEmpty()) {
            List<String> myList = memberIds.stream().distinct().collect(Collectors.toList());
            myList.forEach(s -> {
                try {
                    SscGetSupplierReqBO sscGetSupplierReqBO = new SscGetSupplierReqBO();
                    sscGetSupplierReqBO.setMemberId((String)s);
                    SscGetSupplierRspBO supplier = this.sscGetSupplierService.getSupplier(sscGetSupplierReqBO);
                    if (supplier != null && supplier.getData() != null) {
                        SupplierAccountOceanModel data = supplier.getData();
                        UmcSupplierCreateAbilityReqBO umcSupplierCreateAbilityReqBO = new UmcSupplierCreateAbilityReqBO();
                        umcSupplierCreateAbilityReqBO.setMemName2(data.getAccountContactName());
                        umcSupplierCreateAbilityReqBO.setRegEmail(data.getAccountContactEmail());
                        umcSupplierCreateAbilityReqBO.setPhoneNumber(data.getAccountContactPhone());
                        umcSupplierCreateAbilityReqBO.setSex(Integer.valueOf(data.getGender().equals("M") ? 2 : 1));
                        umcSupplierCreateAbilityReqBO.setRegAccount(data.getLoginId());
                        umcSupplierCreateAbilityReqBO.setOrgCode(data.getSupplierCompanyModel().getCreditCode());
                        umcSupplierCreateAbilityReqBO.setRegMobile(data.getAccountContactMobile());
                        umcSupplierCreateAbilityReqBO.setSupplierName(data.getSupplierCompanyModel().getCompanyName());
                        umcSupplierCreateAbilityReqBO.setProjectName(reqBO.getProjectName());
                        UmcSupplierRegisteredAbilityRspBO umcSupplierRegisteredAbilityRspBO = this.umcSupplierInternalRegisteredAbilityService.dealSupplierInternalRegistered(umcSupplierCreateAbilityReqBO);
                        if (umcSupplierRegisteredAbilityRspBO == null || !"0000".equals(umcSupplierRegisteredAbilityRspBO.getRespCode())) {
                            throw new BusinessException(umcSupplierRegisteredAbilityRspBO.getRespCode(), umcSupplierRegisteredAbilityRspBO.getRespDesc());
                        }
                        SscProjectSupplierPO sscProjectSupplierPO = new SscProjectSupplierPO();
                        sscProjectSupplierPO.setSupplierId(umcSupplierRegisteredAbilityRspBO.getOrgId());
                        sscProjectSupplierPO.setSupplierMemberId(s);
                        this.sscProjectSupplierDAO.updateByPrimaryKeySupplierMemberIdSelective(sscProjectSupplierPO);
                        SscSupplierQuotationPO sscSupplierQuotationPO = new SscSupplierQuotationPO();
                        sscSupplierQuotationPO.setSupplierMemberId(s);
                        sscSupplierQuotationPO.setSupplierId(umcSupplierRegisteredAbilityRspBO.getOrgId());
                        this.sscSupplierQuotationDAO.updateByPrimaryKeySupplierMemberIdSelective(sscSupplierQuotationPO);
                        SscSupplierQuotationDetailPO sscSupplierQuotationDetailPO = new SscSupplierQuotationDetailPO();
                        sscSupplierQuotationDetailPO.setSupplierMemberId(s);
                        sscSupplierQuotationDetailPO.setSupplierId(umcSupplierRegisteredAbilityRspBO.getOrgId());
                        this.sscSupplierQuotationDetailDAO.updateByPrimaryKeySupplierMemberIdSelective(sscSupplierQuotationDetailPO);
                        this.sscSupplierAttachDAO.updateByProjectIdAndSupplierId(reqBO.getProjectId(), data.getSupplierCompanyModel().getSupplierCompanyId(), umcSupplierRegisteredAbilityRspBO.getOrgId());
                    } else {
                        this.RegisteredErr(JSON.toJSONString((Object)reqBO), (String)s, "1688\u4f1a\u5458\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", 0);
                    }
                }
                catch (Exception e) {
                    log.error("1688\u4f1a\u5458\u521b\u5efa\u4e3a\u5e73\u53f0\u4f9b\u5e94\u5546\u5931\u8d25", (Throwable)e);
                    this.RegisteredErr(JSON.toJSONString((Object)reqBO), (String)s, e.toString(), 0);
                }
            });
        }
    }

    private void RegisteredErr(String req, String s, String errInfo, Integer status) {
        SscSupplierMemberLogPO sscSupplierMemberLogPO = new SscSupplierMemberLogPO();
        sscSupplierMemberLogPO.setMemberId(s);
        sscSupplierMemberLogPO.setStatus(status);
        sscSupplierMemberLogPO.setReqInfo(req);
        sscSupplierMemberLogPO.setErrInfo(errInfo);
        sscSupplierMemberLogPO.setCreateTime(new Date());
        this.sscCreateSupplierLogDAO.addSupplierLog(sscSupplierMemberLogPO);
    }
}

