/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.busi.impl.bidding;

import com.alibaba.fastjson.JSON;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscExternalOutBaseRspBO;
import com.tydic.ssc.service.atom.SscDicDictionaryAtomService;
import com.tydic.ssc.service.utils.HttpUtil;
import com.tydic.sscext.busi.bidding.SscProSubmitApprovalBusiService;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitApprovalBusiReqBO;
import com.tydic.sscext.busi.bo.bidding.SscProSubmitApprovalBusiRspBO;
import com.tydic.sscext.dao.SscProjectProMapper;
import com.tydic.sscext.dao.SscProjectSupplierProMapper;
import com.tydic.sscext.dao.po.SscProjectProPO;
import com.tydic.sscext.serivce.bidding.SscProQryWinBiddingSupplierBaseStageListAbilityService;
import com.tydic.sscext.serivce.bidding.bo.SscErpBidResDeleteReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscErpSubmitApprovalReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQryWinBiddingSupplierBaseStageListAbilityServiceRspBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationStageBO;
import com.tydic.sscext.serivce.bidding.bo.SscProQuotationSupplierBaseStageBO;
import com.tydic.sscext.serivce.bidding.bo.WinBidResultDetailErpReqBO;
import com.tydic.sscext.utils.PropertiesUtil;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="sscProSubmitApprovalBusiService")
public class SscProSubmitApprovalBusiServiceImpl
implements SscProSubmitApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscProSubmitApprovalBusiServiceImpl.class);
    @Autowired
    private SscProjectProMapper sscProjectProMapper;
    @Autowired
    private SscProQryWinBiddingSupplierBaseStageListAbilityService sscProQryWinBiddingSupplierBaseStageListAbilityService;
    @Autowired
    private SscProjectSupplierProMapper sscProjectSupplierProMapper;
    @Autowired
    SscDicDictionaryAtomService sscDicDictionaryAtomService;
    @Value(value="${ERP_PROJECT_CREATE_TENDER_RESULT_URL}")
    private String abilityUri;
    @Value(value="${ERP_PROJECT_DELETE_TENDER_RESULT_URL}")
    private String abilityDelUri;

    @Override
    public SscProSubmitApprovalBusiRspBO submitApproval(SscProSubmitApprovalBusiReqBO reqBO) {
        SscProSubmitApprovalBusiRspBO rspBO = new SscProSubmitApprovalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SscProjectProPO sscProjectProPO = new SscProjectProPO();
        sscProjectProPO.setProjectId(reqBO.getProjectId());
        sscProjectProPO.setDelStatus("0");
        SscProjectProPO projectDetail = this.sscProjectProMapper.getModelBy(sscProjectProPO);
        if (Objects.nonNull(projectDetail.getExtField3())) {
            SscErpBidResDeleteReqBO erpBidResDeleteReqBO = new SscErpBidResDeleteReqBO();
            erpBidResDeleteReqBO.setTendercode(String.valueOf(projectDetail.getProjectId()));
            erpBidResDeleteReqBO.setBillmaker(reqBO.getUsername());
            String c = JSON.toJSONString((Object)erpBidResDeleteReqBO);
            try {
                if (StringUtils.isEmpty((Object)this.abilityDelUri)) {
                    log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5220\u9664\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u8c03\u7528erp\u63a5\u53e3!");
                } else {
                    log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5220\u9664\u5730\u5740\u4e3a : " + this.abilityDelUri);
                    log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5220\u9664\u53c2\u6570 :" + c);
                    String outStr = HttpUtil.httpClient((String)this.abilityDelUri, (String)c);
                    log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5220\u9664\u53c2\u6570\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)outStr));
                    SscExternalOutBaseRspBO erpRspBO = (SscExternalOutBaseRspBO)JSON.parseObject((String)outStr, SscExternalOutBaseRspBO.class);
                    String RSP_CODE_SUCCESS = "0";
                    if (Objects.isNull(erpRspBO) || !"0".equals(erpRspBO.getCode())) {
                        throw new BusinessException("8888", "\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5220\u9664\u5931\u8d25 : " + erpRspBO.getMsg());
                    }
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u9879\u76ee\u7f16\u53f7-" + projectDetail.getProjectId() + "," + e.getMessage());
            }
        }
        SscErpSubmitApprovalReqBO approvalReqBO = new SscErpSubmitApprovalReqBO();
        approvalReqBO.setTenderid(String.valueOf(reqBO.getProjectId()));
        approvalReqBO.setTendercode(projectDetail.getProjectCode());
        approvalReqBO.setTendername(projectDetail.getProjectName());
        approvalReqBO.setCgdw(reqBO.getCompanyCode());
        approvalReqBO.setBillmaker(reqBO.getUsername());
        Map projectCategoryMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "BIDDING_CATEGORY_PRO");
        approvalReqBO.setZbpl((String)projectCategoryMap.get(projectDetail.getProjectCategory()));
        String BIDEVALUATION = "C";
        String APPROVECARD = "D";
        approvalReqBO.setPbzl(this.getTokenAndUrl(reqBO.getProjectId(), "C"));
        approvalReqBO.setSpk(this.getTokenAndUrl(reqBO.getProjectId(), "D"));
        approvalReqBO.setPbdd(projectDetail.getBidReviewAddr());
        approvalReqBO.setZbdw(projectDetail.getPurchaseUnitName());
        approvalReqBO.setGsje(projectDetail.getBudgetAmount().toEngineeringString());
        approvalReqBO.setZjly(projectDetail.getExtField6());
        approvalReqBO.setDhrq(this.dateTimeForMatToString(projectDetail.getArrivalTime()));
        SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO qryBidResReqBO = new SscProQryWinBiddingSupplierBaseStageListAbilityServiceReqBO();
        qryBidResReqBO.setProjectId(reqBO.getProjectId());
        SscProQryWinBiddingSupplierBaseStageListAbilityServiceRspBO qryBidResRspBO = this.sscProQryWinBiddingSupplierBaseStageListAbilityService.qryWinBiddingSupplierBaseStageList(qryBidResReqBO);
        log.debug("\u67e5\u8be2\u4e2d\u6807\u4fe1\u606f\u7ed3\u679c: " + JSON.toJSONString((Object)qryBidResRspBO));
        if (!"0000".equals(qryBidResRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528erp\u63d0\u4ea4\u5ba1\u6279:\u4e2d\u6807\u4fe1\u606f\u67e5\u8be2\u5931\u8d25 :" + qryBidResRspBO.getRespDesc());
        }
        List winBidResBOS = qryBidResRspBO.getSscProQuotationStageBOList();
        ArrayList<WinBidResultDetailErpReqBO> winBidResDetails = new ArrayList<WinBidResultDetailErpReqBO>();
        Map winBidStatusProMap = this.sscDicDictionaryAtomService.queryDictBySysCodeAndPcode("SSC", "win_bid_status_pro");
        for (SscProQuotationStageBO winBidResBO : winBidResBOS) {
            List baseStageBOList = winBidResBO.getSscProQuotationSupplierBaseStageBOList();
            for (SscProQuotationSupplierBaseStageBO bo : baseStageBOList) {
                WinBidResultDetailErpReqBO bidResultDetailErpReqBO = new WinBidResultDetailErpReqBO();
                bidResultDetailErpReqBO.setBdxx(winBidResBO.getStageName());
                bidResultDetailErpReqBO.setTbdw(bo.getSupplierName());
                bidResultDetailErpReqBO.setZczj(bo.getRegistAmount());
                bidResultDetailErpReqBO.setLxr(bo.getBusiLinkMan());
                bidResultDetailErpReqBO.setLxdh(bo.getBusiLinkWay());
                bidResultDetailErpReqBO.setCcbj(bo.getInitialTotalPrice().toEngineeringString());
                bidResultDetailErpReqBO.setZzbj(bo.getEndTotalPrice().toEngineeringString());
                bidResultDetailErpReqBO.setPbbz(bo.getReviewRemark());
                bidResultDetailErpReqBO.setSxbs((String)winBidStatusProMap.get(bo.getWinBidStatus()));
                bidResultDetailErpReqBO.setFkfs(bo.getPaymentType());
                bidResultDetailErpReqBO.setJhq(bo.getDeliveryDate());
                winBidResDetails.add(bidResultDetailErpReqBO);
            }
        }
        approvalReqBO.setZbxq(winBidResDetails);
        String s = JSON.toJSONString((Object)approvalReqBO);
        try {
            if (StringUtils.isEmpty((Object)this.abilityUri)) {
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u5730\u5740\u4e3a\u7a7a\uff0c\u4e0d\u8c03\u7528erp\u63a5\u53e3!");
            } else {
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u53c2\u6570\uff1a:" + s);
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279url\uff1a:" + this.abilityUri);
                String outStr = HttpUtil.httpClient((String)this.abilityUri, (String)s);
                log.debug("\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u53c2\u6570\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)outStr));
                SscExternalOutBaseRspBO erpRspBO = (SscExternalOutBaseRspBO)JSON.parseObject((String)outStr, SscExternalOutBaseRspBO.class);
                String RSP_CODE_SUCCESS = "0";
                if (Objects.isNull(erpRspBO) || !"0".equals(erpRspBO.getCode())) {
                    throw new BusinessException("8888", "\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4erp\u5ba1\u6279\u5931\u8d25 : " + erpRspBO.getMsg());
                }
                sscProjectProPO.setExtField2(reqBO.getAuditCardFile());
                sscProjectProPO.setProjectStatus("11");
                int update = this.sscProjectProMapper.updateById(sscProjectProPO);
                if (update < 1) {
                    throw new BusinessException("8888", "\u4e2d\u6807\u7ed3\u679c\u63d0\u4ea4\u5ba1\u6279\u66f4\u65b0\u9879\u76ee\u72b6\u6001\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u8c03\u7528erp\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25" + e.getMessage());
        }
        return rspBO;
    }

    private String dateTimeForMatToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String thisTimeString = "";
        if (!StringUtils.isEmpty((Object)date)) {
            try {
                thisTimeString = sdf.format(date);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u65f6\u95f4\u8f6c\u6362\u5931\u8d25");
            }
        }
        return thisTimeString;
    }

    private String getTokenAndUrl(Long projectId, String type) {
        StringBuilder builder = new StringBuilder();
        builder.append(projectId.toString());
        builder.append("ztb");
        byte[] bytes1 = builder.toString().getBytes(StandardCharsets.UTF_8);
        String url = PropertiesUtil.getProperty("ZTB_LOAD_FILE") + type + DigestUtils.sha256Hex((byte[])bytes1) + "&projectId=" + projectId.toString();
        return url;
    }
}

