/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.utils;

import com.tydic.sscext.utils.SecurityUtil;
import com.tydic.sscext.utils.SscExtStringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CommonUtil {
    public static String signatureWithParamsAndUrlPath(String urlPath, Map<String, Object> params, String appSecretKey) {
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue().toString());
            }
        }
        String[] datas = new String[1 + paramValueList.size()];
        datas[0] = urlPath;
        Collections.sort(paramValueList);
        for (int i = 0; i < paramValueList.size(); ++i) {
            datas[i + 1] = (String)paramValueList.get(i);
        }
        byte[] signature = SecurityUtil.hmacSha1(datas, SscExtStringUtil.toBytes(appSecretKey));
        return SscExtStringUtil.encodeHexStr(signature);
    }

    public static String signatureWithParamsOnly(Map<String, String> params, String appSecretKey) {
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue());
            }
        }
        Collections.sort(paramValueList);
        String[] datas = new String[paramValueList.size()];
        paramValueList.toArray(datas);
        byte[] signature = SecurityUtil.hmacSha1(datas, SscExtStringUtil.toBytes(appSecretKey));
        return SscExtStringUtil.encodeHexStr(signature);
    }

    public static String buildInvokeUrlPath(String apiNamespace, String apiName, int apiVersion, String protocol, String appKey) {
        String url = protocol + "/" + apiVersion + "/" + apiNamespace + "/" + apiName + "/" + appKey;
        return url;
    }

    public static String getWholeUrl(String url, Map<String, String> params) {
        String param;
        Map.Entry<String, String> entry;
        if (url == null) {
            return null;
        }
        if (params == null) {
            return url;
        }
        Set<Map.Entry<String, String>> set = params.entrySet();
        if (set.size() <= 0) {
            return url;
        }
        url = url + "?";
        Iterator<Map.Entry<String, String>> it = set.iterator();
        if (it.hasNext()) {
            entry = it.next();
            param = entry.getKey() + "=" + entry.getValue();
            url = url + param;
        }
        while (it.hasNext()) {
            entry = it.next();
            param = entry.getKey() + "=" + entry.getValue();
            url = url + "&" + param;
        }
        return url;
    }

    public static String getAllString(String url, Map<String, Object> params, String appSecretKey, String accessToken) {
        if (params == null) {
            return null;
        }
        if (accessToken != null) {
            params.put("access_token", accessToken);
        }
        if (appSecretKey != null) {
            params.put("_aop_signature", CommonUtil.signatureWithParamsAndUrlPath(url, params, appSecretKey));
        }
        StringBuffer reqStr = new StringBuffer();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            try {
                if (reqStr.length() != 0) {
                    reqStr.append('&');
                }
                reqStr.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                reqStr.append('=');
                reqStr.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return reqStr.toString();
    }
}

