/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.sscext.utils;

import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.StringUtils;

public class SscExtStringUtil {
    public static final String CHARSET_NAME_UTF8 = "UTF-8";
    public static final char[] digital = "0123456789ABCDEF".toCharArray();
    public static final String DEFAULT_DATA_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String strLengthSub(String sourceStr, Integer lengthLimit) {
        int defaultLengthLimit = 255;
        lengthLimit = null == lengthLimit || 0 > lengthLimit ? 255 : lengthLimit;
        if (StringUtils.hasText((String)sourceStr)) {
            if (sourceStr.length() > lengthLimit) {
                return sourceStr.substring(0, lengthLimit);
            }
            return sourceStr;
        }
        return "";
    }

    public static String format(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATA_TIME_FORMAT);
        return format.format(date);
    }

    public static String encodeHexStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            result[i * 2] = digital[(bytes[i] & 0xF0) >> 4];
            result[i * 2 + 1] = digital[bytes[i] & 0xF];
        }
        return new String(result);
    }

    public static byte[] decodeHexStr(String str) {
        if (str == null) {
            return null;
        }
        char[] charArray = str.toCharArray();
        if (charArray.length % 2 != 0) {
            throw new RuntimeException("hex str length must can mod 2, str:" + str);
        }
        byte[] bytes = new byte[charArray.length / 2];
        for (int i = 0; i < charArray.length; ++i) {
            int b;
            char c = charArray[i];
            if (c >= '0' && c <= '9') {
                b = c - 48 << 4;
            } else if (c >= 'A' && c <= 'F') {
                b = c - 65 + 10 << 4;
            } else {
                throw new RuntimeException("unsport hex str:" + str);
            }
            c = charArray[++i];
            if (c >= '0' && c <= '9') {
                b |= c - 48;
            } else if (c >= 'A' && c <= 'F') {
                b |= c - 65 + 10;
            } else {
                throw new RuntimeException("unsport hex str:" + str);
            }
            bytes[i / 2] = (byte)b;
        }
        return bytes;
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes(CHARSET_NAME_UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

