/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.ssc.base.bo.BusinessException;
import com.tydic.ssc.common.SscProjectTempResultDetailBO;
import com.tydic.ssc.common.SscProjectTempResultSupplierBO;
import com.tydic.ssc.constant.SscCommConstant;
import com.tydic.ssc.dao.SscProjectApprovalDAO;
import com.tydic.ssc.dao.SscProjectBidRoundDAO;
import com.tydic.ssc.dao.SscProjectTempResultDAO;
import com.tydic.ssc.dao.SscProjectTempResultDetailDAO;
import com.tydic.ssc.dao.SscProjectTempResultSupplierDAO;
import com.tydic.ssc.dao.SscProjectTempResultVoteDAO;
import com.tydic.ssc.dao.po.SscProjectApprovalPO;
import com.tydic.ssc.dao.po.SscProjectBidRoundPO;
import com.tydic.ssc.dao.po.SscProjectTempResultDetailPO;
import com.tydic.ssc.dao.po.SscProjectTempResultPO;
import com.tydic.ssc.dao.po.SscProjectTempResultSupplierPO;
import com.tydic.ssc.dao.po.SscProjectTempResultVotePO;
import com.tydic.ssc.service.busi.SscAddProjectTempResultBusiService;
import com.tydic.ssc.service.busi.bo.SscAddProjectTempResultBusiReqBO;
import com.tydic.ssc.service.busi.bo.SscAddProjectTempResultBusiRspBO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SscAddProjectTempResultBusiServiceImpl
implements SscAddProjectTempResultBusiService {
    @Autowired
    private SscProjectTempResultDAO sscProjectTempResultDAO;
    @Autowired
    private SscProjectTempResultDetailDAO sscProjectTempResultDetailDAO;
    @Autowired
    private SscProjectTempResultSupplierDAO sscProjectTempResultSupplierDAO;
    @Autowired
    private SscProjectTempResultVoteDAO sscProjectTempResultVoteDAO;
    @Autowired
    private SscProjectBidRoundDAO sscProjectBidRoundDAO;
    @Autowired
    private SscProjectApprovalDAO sscProjectApprovalDAO;

    @Override
    public SscAddProjectTempResultBusiRspBO addProjectTempResult(SscAddProjectTempResultBusiReqBO busiReqBO) {
        SscAddProjectTempResultBusiRspBO rsp = new SscAddProjectTempResultBusiRspBO();
        SscProjectTempResultPO whereProjectTempResultPO = new SscProjectTempResultPO();
        whereProjectTempResultPO.setProjectId(busiReqBO.getProjectId());
        whereProjectTempResultPO.setPlanId(busiReqBO.getPlanId());
        whereProjectTempResultPO.setStageId(busiReqBO.getStageId());
        SscProjectTempResultPO sscProjectTempResultPO = this.sscProjectTempResultDAO.getModeyBy(whereProjectTempResultPO);
        if (null != sscProjectTempResultPO) {
            if (!"3".equals(sscProjectTempResultPO.getTempResultStatus()) && !"2".equals(sscProjectTempResultPO.getTempResultStatus())) {
                throw new BusinessException("8888", "\u53ea\u6709\u5f85\u6295\u7968\u7684\u6216\u5ba1\u6279\u4e0d\u901a\u8fc7\u7684\u62df\u5b9a\u7ed3\u679c\u624d\u80fd\u518d\u6b21\u62df\u5b9a\u7ed3\u679c\uff01");
            }
            this.deleteProjectTempResult(sscProjectTempResultPO);
            this.deleteProjectTempResultDetail(sscProjectTempResultPO);
            this.deleteProjectTempResultSupplier(sscProjectTempResultPO);
            this.deleteProjectTempResultVote(sscProjectTempResultPO);
            this.deleteProjectApproval(sscProjectTempResultPO.getProjectId());
        }
        Long tempResultId = Sequence.getInstance().nextId();
        this.insertProjectTempResult(busiReqBO, tempResultId);
        this.insertProjectTempResultDetail(busiReqBO, tempResultId);
        this.insertProjectTempResultSupplier(busiReqBO, tempResultId);
        this.updateProjectBidRoundStatus(busiReqBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u62df\u5b9a\u7ed3\u679c\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }

    private void deleteProjectApproval(Long projectId) {
        SscProjectApprovalPO deleteWherePO = new SscProjectApprovalPO();
        deleteWherePO.setProjectId(projectId);
        deleteWherePO.setApprovalType(SscCommConstant.AuditObjType.PROJECT_TEMP_RESULT_AUDIT);
        this.sscProjectApprovalDAO.deleteBy(deleteWherePO);
    }

    private void updateProjectBidRoundStatus(SscAddProjectTempResultBusiReqBO busiReqBO) {
        SscProjectBidRoundPO updatePO = new SscProjectBidRoundPO();
        updatePO.setProjectId(busiReqBO.getProjectId());
        updatePO.setPlanId(busiReqBO.getPlanId());
        updatePO.setStageId(busiReqBO.getStageId());
        updatePO.setScoreRound(busiReqBO.getScoreRound());
        updatePO.setBidStatus("5");
        int isUpdate = this.sscProjectBidRoundDAO.updateByCondition(updatePO);
        if (isUpdate < 1) {
            throw new BusinessException("8888", "\u66f4\u65b0\u9879\u76ee\u8bc4\u6807\u8f6e\u6b21\u8868\u5931\u8d25\uff01");
        }
    }

    private void insertProjectTempResultSupplier(SscAddProjectTempResultBusiReqBO busiReqBO, Long tempResultId) {
        ArrayList<SscProjectTempResultSupplierPO> sscProjectTempResultSupplierPOs = new ArrayList<SscProjectTempResultSupplierPO>();
        for (SscProjectTempResultSupplierBO bo : busiReqBO.getSscProjectTempResultSupplierBOs()) {
            SscProjectTempResultSupplierPO sscProjectTempResultSupplierPO = new SscProjectTempResultSupplierPO();
            BeanUtils.copyProperties((Object)bo, (Object)sscProjectTempResultSupplierPO);
            sscProjectTempResultSupplierPO.setTempResultSupplierId(Sequence.getInstance().nextId());
            sscProjectTempResultSupplierPO.setTempResultId(tempResultId);
            sscProjectTempResultSupplierPO.setPlanId(busiReqBO.getPlanId());
            sscProjectTempResultSupplierPO.setProjectId(busiReqBO.getProjectId());
            sscProjectTempResultSupplierPO.setStageId(busiReqBO.getStageId());
            sscProjectTempResultSupplierPO.setScoreRound(busiReqBO.getScoreRound());
            sscProjectTempResultSupplierPOs.add(sscProjectTempResultSupplierPO);
        }
        int isInsert = this.sscProjectTempResultSupplierDAO.insertBatch(sscProjectTempResultSupplierPOs);
        if (isInsert != busiReqBO.getSscProjectTempResultSupplierBOs().size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u62df\u5b9a\u7ed3\u679c\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
        }
    }

    private void insertProjectTempResultDetail(SscAddProjectTempResultBusiReqBO busiReqBO, Long tempResultId) {
        ArrayList<SscProjectTempResultDetailPO> sscProjectTempResultDetailPOs = new ArrayList<SscProjectTempResultDetailPO>();
        for (SscProjectTempResultDetailBO bo : busiReqBO.getSscProjectTempResultDetailBOs()) {
            SscProjectTempResultDetailPO sscProjectTempResultDetailPO = new SscProjectTempResultDetailPO();
            BeanUtils.copyProperties((Object)bo, (Object)sscProjectTempResultDetailPO);
            sscProjectTempResultDetailPO.setTempResultDetailId(Sequence.getInstance().nextId());
            sscProjectTempResultDetailPO.setTempResultId(tempResultId);
            sscProjectTempResultDetailPO.setPlanId(busiReqBO.getPlanId());
            sscProjectTempResultDetailPO.setProjectId(busiReqBO.getProjectId());
            sscProjectTempResultDetailPO.setStageId(busiReqBO.getStageId());
            sscProjectTempResultDetailPO.setScoreRound(busiReqBO.getScoreRound());
            sscProjectTempResultDetailPOs.add(sscProjectTempResultDetailPO);
        }
        int isInsert = this.sscProjectTempResultDetailDAO.insertBatch(sscProjectTempResultDetailPOs);
        if (isInsert != busiReqBO.getSscProjectTempResultDetailBOs().size()) {
            throw new BusinessException("8888", "\u65b0\u589e\u62df\u5b9a\u7ed3\u679c\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }

    private void insertProjectTempResult(SscAddProjectTempResultBusiReqBO busiReqBO, Long tempResultId) {
        SscProjectTempResultPO insertValuePO = new SscProjectTempResultPO();
        insertValuePO.setTempResultId(tempResultId);
        insertValuePO.setPlanId(busiReqBO.getPlanId());
        insertValuePO.setProjectId(busiReqBO.getProjectId());
        insertValuePO.setStageId(busiReqBO.getStageId());
        insertValuePO.setOperNo(busiReqBO.getOperId());
        insertValuePO.setOperName(busiReqBO.getOperName());
        insertValuePO.setOperTime(new Date());
        insertValuePO.setTempResultStatus("3");
        insertValuePO.setScoreRound(busiReqBO.getScoreRound());
        insertValuePO.setTempResultOpinion(busiReqBO.getTempResultOpinion());
        int isInsert = this.sscProjectTempResultDAO.insert(insertValuePO);
        if (isInsert < 1) {
            throw new BusinessException("8888", "\u65b0\u589e\u62df\u5b9a\u7ed3\u679c\u8868\u5931\u8d25\uff01");
        }
    }

    private void deleteProjectTempResultVote(SscProjectTempResultPO sscProjectTempResultPO) {
        SscProjectTempResultVotePO deleteWherePO = new SscProjectTempResultVotePO();
        deleteWherePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        deleteWherePO.setProjectId(sscProjectTempResultPO.getProjectId());
        deleteWherePO.setPlanId(sscProjectTempResultPO.getPlanId());
        int isDelete = this.sscProjectTempResultVoteDAO.deleteBy(deleteWherePO);
    }

    private void deleteProjectTempResultSupplier(SscProjectTempResultPO sscProjectTempResultPO) {
        SscProjectTempResultSupplierPO deleteWherePO = new SscProjectTempResultSupplierPO();
        deleteWherePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        deleteWherePO.setProjectId(sscProjectTempResultPO.getProjectId());
        deleteWherePO.setPlanId(sscProjectTempResultPO.getPlanId());
        deleteWherePO.setStageId(sscProjectTempResultPO.getStageId());
        int isDelete = this.sscProjectTempResultSupplierDAO.deleteBy(deleteWherePO);
        if (isDelete < 1) {
            throw new BusinessException("8888", "\u5220\u9664\u62df\u5b9a\u7ed3\u679c\u4f9b\u5e94\u5546\u8868\u5931\u8d25\uff01");
        }
    }

    private void deleteProjectTempResultDetail(SscProjectTempResultPO sscProjectTempResultPO) {
        SscProjectTempResultDetailPO deleteWherePO = new SscProjectTempResultDetailPO();
        deleteWherePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        deleteWherePO.setProjectId(sscProjectTempResultPO.getProjectId());
        deleteWherePO.setPlanId(sscProjectTempResultPO.getPlanId());
        deleteWherePO.setStageId(sscProjectTempResultPO.getStageId());
        int isDelete = this.sscProjectTempResultDetailDAO.deleteBy(deleteWherePO);
        if (isDelete < 1) {
            throw new BusinessException("8888", "\u5220\u9664\u62df\u5b9a\u7ed3\u679c\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
    }

    private void deleteProjectTempResult(SscProjectTempResultPO sscProjectTempResultPO) {
        SscProjectTempResultPO deleteWherePO = new SscProjectTempResultPO();
        deleteWherePO.setTempResultId(sscProjectTempResultPO.getTempResultId());
        deleteWherePO.setProjectId(sscProjectTempResultPO.getProjectId());
        deleteWherePO.setPlanId(sscProjectTempResultPO.getPlanId());
        deleteWherePO.setStageId(sscProjectTempResultPO.getStageId());
        int isDelete = this.sscProjectTempResultDAO.deleteBy(deleteWherePO);
        if (isDelete < 1) {
            throw new BusinessException("8888", "\u5220\u9664\u62df\u5b9a\u7ed3\u679c\u8868\u5931\u8d25\uff01");
        }
    }
}

