/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.ssc.service.busi.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.ssc.ability.bo.SscQryProjectDetailQuotationListAbilityReqBO;
import com.tydic.ssc.common.SscProjectDetailQuotationBO;
import com.tydic.ssc.common.SscProjectSupplierAttachBO;
import com.tydic.ssc.common.SscSupplierAttachBO;
import com.tydic.ssc.common.SscSupplierAttachListBO;
import com.tydic.ssc.common.SscSupplierProjectBO;
import com.tydic.ssc.dao.SscQryProjectDetailQuotationListDAO;
import com.tydic.ssc.dao.SscSupplierAttachDAO;
import com.tydic.ssc.dao.SscSupplierQuotationDAO;
import com.tydic.ssc.dao.po.SscQryProjectDetailQuotationListBusiPO;
import com.tydic.ssc.dao.po.SscSupplierAttachPO;
import com.tydic.ssc.service.busi.SscQryProjectDetailQuotationListBusiService;
import com.tydic.ssc.service.busi.bo.SscQryProjectDetailQuotationListBusiRspBO;
import com.tydic.ssc.service.busi.bo.SscQrySupplierAttachLisBusiReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscQryProjectDetailQuotationListBusiServiceImpl
implements SscQryProjectDetailQuotationListBusiService {
    private static final Logger log = LoggerFactory.getLogger(SscQryProjectDetailQuotationListBusiServiceImpl.class);
    @Autowired
    private SscQryProjectDetailQuotationListDAO sscQryProjectDetailQuotationListDAO;
    @Autowired
    private SscSupplierAttachDAO sscSupplierAttachDAO;
    @Autowired
    private SscSupplierQuotationDAO sscSupplierQuotationDAO;

    @Override
    public SscQryProjectDetailQuotationListBusiRspBO qryProjectDetailQuotationList(SscQryProjectDetailQuotationListAbilityReqBO reqBO) {
        SscQryProjectDetailQuotationListBusiRspBO rspBO = new SscQryProjectDetailQuotationListBusiRspBO();
        SscQryProjectDetailQuotationListBusiPO busiReqPO = new SscQryProjectDetailQuotationListBusiPO();
        busiReqPO.setProjectId(reqBO.getProjectId());
        busiReqPO.setSupplierId(reqBO.getSupplierId());
        busiReqPO.setStageId(reqBO.getStageId());
        busiReqPO.setQuotationRound(reqBO.getQuotationRound());
        if (reqBO.getQueryType() == null) {
            busiReqPO.setQueryType(1);
        } else {
            busiReqPO.setQueryType(reqBO.getQueryType());
        }
        busiReqPO.setProjectDetailIds(reqBO.getProjectDetailIds());
        if (!reqBO.getQueryPageFlag().booleanValue()) {
            reqBO.setPageNo(Integer.valueOf(-1));
            reqBO.setPageSize(Integer.valueOf(-1));
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectDetailQuotationBO> list = this.sscQryProjectDetailQuotationListDAO.getProjectDetailQuotationList(busiReqPO, (Page<SscQryProjectDetailQuotationListBusiPO>)page);
        log.debug("\u62a5\u4ef7\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c{}", (Object)JSON.toJSONString(list));
        ArrayList<SscProjectDetailQuotationBO> resultList = new ArrayList<SscProjectDetailQuotationBO>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SscProjectDetailQuotationBO bo : list) {
                SscProjectDetailQuotationBO po = new SscProjectDetailQuotationBO();
                SscSupplierAttachPO sscSupplierAttachPO = new SscSupplierAttachPO();
                sscSupplierAttachPO.setProjectId(bo.getProjectId());
                sscSupplierAttachPO.setQuotationDetailId(bo.getQuotationDetailId());
                sscSupplierAttachPO.setSupplierId(bo.getSupplierId());
                List<SscSupplierAttachBO> supplierAttachBOList = this.sscSupplierAttachDAO.getList(sscSupplierAttachPO);
                BeanUtils.copyProperties((Object)bo, (Object)po);
                po.setSupplierAttachBOList(supplierAttachBOList);
                if (StringUtils.isEmpty((Object)bo.getFlag1688())) {
                    po.setFlag1688("0");
                    po.setFlag1688Str("\u65ed\u9633\u7535\u5546\u5e73\u53f0");
                } else if ("1".equals(bo.getFlag1688())) {
                    po.setFlag1688Str("1688\u5e73\u53f0");
                } else {
                    po.setFlag1688("0");
                    po.setFlag1688Str("1688\u5e73\u53f0");
                }
                SscQrySupplierAttachLisBusiReqBO sscQryProjectDetailDetailBusiReqBO = new SscQrySupplierAttachLisBusiReqBO();
                sscQryProjectDetailDetailBusiReqBO.setProjectId(bo.getProjectId());
                sscQryProjectDetailDetailBusiReqBO.setQuotationDetailId(bo.getQuotationDetailId());
                sscQryProjectDetailDetailBusiReqBO.setSupplierIds(Arrays.asList(po.getSupplierId()));
                List<SscSupplierAttachListBO> sscSupplierAttachListBOS = this.sscSupplierAttachDAO.selectSupplierList(sscQryProjectDetailDetailBusiReqBO);
                if (!CollectionUtils.isEmpty(sscSupplierAttachListBOS) && !CollectionUtils.isEmpty((Collection)sscSupplierAttachListBOS.get(0).getSscSupplierAttachBOs())) {
                    SscProjectSupplierAttachBO sscProjectSupplierAttachBO = new SscProjectSupplierAttachBO();
                    BeanUtils.copyProperties(sscSupplierAttachListBOS.get(0).getSscSupplierAttachBOs().get(0), (Object)sscProjectSupplierAttachBO);
                    po.setSscProjectSupplierAttachBO(sscProjectSupplierAttachBO);
                }
                if (null != bo.getBugetUnitPrice()) {
                    BigDecimal bugetUnitPriceBigDecimal = new BigDecimal(bo.getBugetUnitPrice());
                    po.setBugetUnitPriceBigDecimal(bugetUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getBugetTotalPrice()) {
                    BigDecimal bugetTotalPriceBigDecimal = new BigDecimal(bo.getBugetTotalPrice());
                    po.setBugetTotalPriceBigDecimal(bugetTotalPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getQuotationUnitPrice()) {
                    BigDecimal quotationUnitPriceBigDecimal = new BigDecimal(bo.getQuotationUnitPrice());
                    po.setQuotationUnitPriceBigDecimal(quotationUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getTotalQuotationPrice()) {
                    BigDecimal totalQuotationPriceBigDecimal = new BigDecimal(bo.getTotalQuotationPrice());
                    po.setTotalQuotationPriceBigDecimal(totalQuotationPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerId())) {
                    po.setBuyerId(bo.getBuyerId());
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerName())) {
                    po.setBuyerName(bo.getBuyerName());
                }
                if (StringUtils.isEmpty((Object)bo.getField8Value())) {
                    po.setField8Value(bo.getField8Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField9Value())) {
                    po.setField9Value(bo.getField9Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField10Value())) {
                    po.setField10Value(bo.getField10Value());
                }
                BigDecimal calculationTaxUnitPrice = new BigDecimal("0.00");
                if (po.getTaxUnitPrice() != null) {
                    calculationTaxUnitPrice = new BigDecimal(po.getTaxUnitPrice()).divide(new BigDecimal(100), 2, 4);
                    po.setTaxUnitPriceShow(calculationTaxUnitPrice.toString());
                }
                if (po.getTaxTotalPrice() != null) {
                    BigDecimal calculationTaxTotalPrice = new BigDecimal(po.getTaxTotalPrice()).divide(new BigDecimal(100000000), 2, 4);
                    po.setTaxTotalPriceShow(calculationTaxTotalPrice.toString());
                }
                BigDecimal bidTaxTotalPrice = new BigDecimal("0.00");
                if (po.getBidPortion() != null && po.getBidPortion().compareTo(BigDecimal.ZERO) != 0 && calculationTaxUnitPrice.compareTo(BigDecimal.ZERO) != 0) {
                    bidTaxTotalPrice = po.getBidPortion().multiply(calculationTaxUnitPrice).setScale(2, 4);
                }
                po.setBidPriceShow(bidTaxTotalPrice.toString());
                resultList.add(po);
            }
        }
        rspBO.setRows(resultList);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public SscProjectDetailQuotationBO qryProjectDetailQuotationListCount(SscQryProjectDetailQuotationListAbilityReqBO reqBO) {
        SscProjectDetailQuotationBO sscProjectDetailQuotationBO = new SscProjectDetailQuotationBO();
        SscQryProjectDetailQuotationListBusiPO busiReqPO = new SscQryProjectDetailQuotationListBusiPO();
        busiReqPO.setProjectId(reqBO.getProjectId());
        busiReqPO.setSupplierId(reqBO.getSupplierId());
        busiReqPO.setQuotationRound(reqBO.getQuotationRound());
        SscProjectDetailQuotationBO sb = this.sscQryProjectDetailQuotationListDAO.getProjectDetailQuotationListCount(busiReqPO);
        if (sb != null) {
            BeanUtils.copyProperties((Object)sb, (Object)sscProjectDetailQuotationBO);
        }
        return sscProjectDetailQuotationBO;
    }

    @Override
    public SscQryProjectDetailQuotationListBusiRspBO exportProjectDetailQuotationList(SscQryProjectDetailQuotationListAbilityReqBO reqBO) {
        SscQryProjectDetailQuotationListBusiRspBO rspBO = new SscQryProjectDetailQuotationListBusiRspBO();
        SscQryProjectDetailQuotationListBusiPO busiReqPO = new SscQryProjectDetailQuotationListBusiPO();
        busiReqPO.setProjectId(reqBO.getProjectId());
        busiReqPO.setSupplierId(reqBO.getSupplierId());
        busiReqPO.setStageId(reqBO.getStageId());
        busiReqPO.setQuotationRound(reqBO.getQuotationRound());
        busiReqPO.setSupplierIds(reqBO.getSupplierIds());
        if (reqBO.getQueryType() == null) {
            busiReqPO.setQueryType(1);
        } else {
            busiReqPO.setQueryType(reqBO.getQueryType());
        }
        busiReqPO.setProjectDetailIds(reqBO.getProjectDetailIds());
        if (!reqBO.getQueryPageFlag().booleanValue()) {
            reqBO.setPageNo(Integer.valueOf(-1));
            reqBO.setPageSize(Integer.valueOf(-1));
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SscProjectDetailQuotationBO> list = this.sscQryProjectDetailQuotationListDAO.getProjectDetailQuotationList2(busiReqPO, (Page<SscQryProjectDetailQuotationListBusiPO>)page);
        log.debug("\u62a5\u4ef7\u660e\u7ec6\u67e5\u8be2\u7ed3\u679c{}", (Object)JSON.toJSONString(list));
        ArrayList<SscProjectDetailQuotationBO> resultList = new ArrayList<SscProjectDetailQuotationBO>();
        if (!CollectionUtils.isEmpty(list)) {
            for (SscProjectDetailQuotationBO bo : list) {
                SscProjectDetailQuotationBO po = new SscProjectDetailQuotationBO();
                BeanUtils.copyProperties((Object)bo, (Object)po);
                if (null != bo.getBugetUnitPrice()) {
                    BigDecimal bugetUnitPriceBigDecimal = new BigDecimal(bo.getBugetUnitPrice());
                    po.setBugetUnitPriceBigDecimal(bugetUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getBugetTotalPrice()) {
                    BigDecimal bugetTotalPriceBigDecimal = new BigDecimal(bo.getBugetTotalPrice());
                    po.setBugetTotalPriceBigDecimal(bugetTotalPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getQuotationUnitPrice()) {
                    BigDecimal quotationUnitPriceBigDecimal = new BigDecimal(bo.getQuotationUnitPrice());
                    po.setQuotationUnitPriceBigDecimal(quotationUnitPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (null != bo.getTotalQuotationPrice()) {
                    BigDecimal totalQuotationPriceBigDecimal = new BigDecimal(bo.getTotalQuotationPrice());
                    po.setTotalQuotationPriceBigDecimal(totalQuotationPriceBigDecimal.divide(new BigDecimal(10000)));
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerId())) {
                    po.setBuyerId(bo.getBuyerId());
                }
                if (StringUtils.isEmpty((Object)bo.getBuyerName())) {
                    po.setBuyerName(bo.getBuyerName());
                }
                if (StringUtils.isEmpty((Object)bo.getField8Value())) {
                    po.setField8Value(bo.getField8Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField9Value())) {
                    po.setField9Value(bo.getField9Value());
                }
                if (StringUtils.isEmpty((Object)bo.getField10Value())) {
                    po.setField10Value(bo.getField10Value());
                }
                resultList.add(po);
            }
        }
        rspBO.setRows(resultList);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9879\u76ee\u660e\u7ec6\u4f9b\u5e94\u5546\u62a5\u4ef7\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    @Override
    public int selectSupplierIsOffer(SscSupplierProjectBO sscSupplierProjectBO) {
        return this.sscSupplierQuotationDAO.selectSupplierIsOffer(sscSupplierProjectBO);
    }
}

