/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula.service.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaLogMethodEnum;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class TanggulaUserOperLogAbleImpl
implements TanggulaLogCollectAble {
    private static final Logger log = LoggerFactory.getLogger(TanggulaUserOperLogAbleImpl.class);
    private CacheClient cacheClient;
    private static final String TANG_GU_LA_CACHE_PREFIX = "TANG_GU_LA_";
    private static final String RESP_CODE_KEY = "respCode";
    private static final String USER_ID = "userId";
    private static final String MDP_USER_ID = "mdpUserId";
    private static final String USER_NAME = "userName";
    private static final String RESP_CODE_SUCCESS = "0000";
    private static final String RESP_CODE_SUCCESS_OTHER = "0";
    private static final String POINT = ".";
    private static final String SUCCESS_DESC = "\u6210\u529f";
    private static final String FAIL_DESC = "\u5931\u8d25";
    private static final String LOG_TITLE = "\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7";

    public TanggulaUserOperLogAbleImpl(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    @Override
    public Long getLogCollectMethod() {
        return TanggulaLogMethodEnum.LOG_USER_OPER.getLogMethod();
    }

    @Override
    public TanggulaDealLogCollectRspBO doCollect(TanggulaMethodParamDTO dto) {
        TanggulaDealLogCollectRspBO rspBO = new TanggulaDealLogCollectRspBO();
        rspBO.setCode(TanggulaResultCodeEnum.SUCCESS.getCode());
        rspBO.setMessage(TanggulaResultCodeEnum.SUCCESS.getMessage());
        String serviceCode = dto.getServiceCode();
        String methodCode = dto.getMethodCode();
        String cacheKey = TANG_GU_LA_CACHE_PREFIX + serviceCode + POINT + methodCode;
        String logInfo = (String)this.cacheClient.get(cacheKey);
        if (StringUtils.isEmpty((Object)logInfo)) {
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }
        Map inputMap = dto.getInputMap();
        Map outputMap = dto.getOutputMap();
        String respCode = (String)outputMap.get(RESP_CODE_KEY);
        if (StringUtils.isEmpty((Object)respCode)) {
            log.error("\u672a\u83b7\u53d6\u5230\u6267\u884c\u7ed3\u679c\u5173\u952e\u5b57\u6bb5\uff1arespCode");
            rspBO.setCode(TanggulaResultCodeEnum.FAIL.getCode());
            rspBO.setMessage(TanggulaResultCodeEnum.FAIL.getMessage());
            return rspBO;
        }
        rspBO.setLogTitle(LOG_TITLE);
        rspBO.setLogDetail(logInfo);
        rspBO.setLogTime(new Date());
        rspBO.setOperDesc(logInfo);
        rspBO.setOperState(respCode);
        rspBO.setOperStateDesc(RESP_CODE_SUCCESS.equals(respCode) || RESP_CODE_SUCCESS_OTHER.equals(respCode) ? SUCCESS_DESC : FAIL_DESC);
        String userId = (String)inputMap.get(USER_ID);
        if (StringUtils.isEmpty((Object)userId)) {
            userId = (String)inputMap.get(MDP_USER_ID);
        }
        rspBO.setUserId(userId);
        String userName = (String)inputMap.get(USER_NAME);
        rspBO.setUserName(userName);
        rspBO.setInputParam(inputMap.toString());
        rspBO.setOutputParam(outputMap.toString());
        return rspBO;
    }
}

