/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.tanggula;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.tanggula.bo.TanggulaDealLogCollectRspBO;
import com.tydic.tanggula.dto.TanggulaMethodParamDTO;
import com.tydic.tanggula.enums.TanggulaResultCodeEnum;
import com.tydic.tanggula.result.TanggulaResult;
import com.tydic.tanggula.service.TanggulaLogCollectAble;
import com.tydic.tanggula.util.TanggulaLogCollectAbleManager;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TanggulaClient {
    private static final Logger log = LoggerFactory.getLogger(TanggulaClient.class);
    private TanggulaLogCollectAbleManager logCollectAbleManager;
    private ProxyMessageProducer pluginProvider;
    private String apiUrl;
    private static final String SEND_OK = "SEND_OK";

    public TanggulaClient(ProxyMessageProducer pluginProvider, TanggulaLogCollectAbleManager tanggulaLogCollectAbleManager, String apiUrl) {
        this.pluginProvider = pluginProvider;
        this.logCollectAbleManager = tanggulaLogCollectAbleManager;
        this.apiUrl = apiUrl;
    }

    public TanggulaResult execute(TanggulaMethodParamDTO dto) {
        TanggulaResult tanggulaResult = new TanggulaResult(TanggulaResultCodeEnum.SUCCESS);
        dto.setQryGenObjNameListApi(this.apiUrl);
        List logMethods = dto.getLogMethods();
        if (CollectionUtils.isEmpty((Collection)logMethods)) {
            tanggulaResult.buildFail("\u672a\u914d\u7f6e\u65e5\u5fd7\u91c7\u96c6\u80fd\u529b");
            return tanggulaResult;
        }
        for (Long logMethod : logMethods) {
            TanggulaLogCollectAble logCollcetionAble = this.logCollectAbleManager.getLogCollcetionAble(logMethod);
            TanggulaDealLogCollectRspBO collectRspBO = logCollcetionAble.doCollect(dto);
            if (!TanggulaResultCodeEnum.SUCCESS.getCode().equals(collectRspBO.getCode())) {
                log.info("\u672a\u914d\u7f6e\u63a8\u9001\uff1a{},", (Object)logMethod);
                continue;
            }
            log.info("\u5f00\u59cb\u53d1\u9001\u65e5\u5fd7\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)collectRspBO));
            ProxyMessage proxyMessage = new ProxyMessage(dto.getTopic(), dto.getTag(), JSON.toJSONString((Object)collectRspBO));
            ProxySendResult sendResult = this.pluginProvider.send(proxyMessage);
            if (SEND_OK.equals(sendResult.getStatus())) continue;
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u6d88\u606f\u5185\u5bb9\uff1a{},", (Object)proxyMessage.getContent());
            tanggulaResult.buildFail("\u53d1\u9001\u6d88\u606f\u5931\u8d25!");
            return tanggulaResult;
        }
        return tanggulaResult;
    }
}

