/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.atom.bo.task.UacBusiOperRecordReqBO;
import com.tydic.uac.atom.bo.task.UacBusiOperRecordRspBO;
import com.tydic.uac.atom.task.UacBusiOperRecordAtomService;
import com.tydic.uac.dao.task.UacOrdBusiOperRecordMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdBusiOperRecordPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacBusiOperRecordAtomService")
public class UacBusiOperRecordAtomServiceImpl
implements UacBusiOperRecordAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UacBusiOperRecordAtomServiceImpl.class);
    private UacOrdBusiOperRecordMapper ordBusiOperRecordMapper;

    @Autowired
    public UacBusiOperRecordAtomServiceImpl(UacOrdBusiOperRecordMapper ordBusiOperRecordMapper) {
        this.ordBusiOperRecordMapper = ordBusiOperRecordMapper;
    }

    @Override
    @Transactional
    public UacBusiOperRecordRspBO createBusiOperRecord(UacBusiOperRecordReqBO reqBO) {
        this.validParam(reqBO);
        OrdBusiOperRecordPO busiOperRecordPO = new OrdBusiOperRecordPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiOperRecordPO);
        Sequence sequence = Sequence.getInstance();
        busiOperRecordPO.setId(sequence.nextId());
        try {
            this.ordBusiOperRecordMapper.insert(busiOperRecordPO);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u8ba2\u5355\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u8868\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("5001", "\u63d2\u5165\u8ba2\u5355\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u8868\u5f02\u5e38");
        }
        UacBusiOperRecordRspBO rspBO = new UacBusiOperRecordRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u6210\u529f");
        return rspBO;
    }

    private void validParam(UacBusiOperRecordReqBO reqBO) {
        if (reqBO.getRecordType() == null || reqBO.getOrderId() == null || reqBO.getObjType() == null || reqBO.getCreateTime() == null || reqBO.getDealOperId() == null) {
            throw new BusinessException("8000", "\u8ba2\u5355\u4e2d\u5fc3\u6838\u5fc3\u4e1a\u52a1\u64cd\u4f5c\u8bb0\u5f55\u539f\u5b50\u670d\u52a1\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        }
    }
}

