/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.uac.ability.bo.UacApproveEntrustBO;
import com.tydic.uac.atom.UacApproveEntrustStationSelectAtomService;
import com.tydic.uac.atom.bo.UacApproveEntrustStationSelectAtomBO;
import com.tydic.uac.atom.bo.UacApproveEntrustStationSelectAtomReqBO;
import com.tydic.uac.atom.bo.UacApproveEntrustStationSelectAtomRspBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskRspBO;
import com.tydic.uac.atom.task.UacCreateTaskAtomService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.UocOrdTaskApproveEntrustMapper;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.UocOrdTaskApproveEntrustPO;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="uacCreateTaskAtomService")
public class UacCreateTaskAtomServiceImpl
implements UacCreateTaskAtomService {
    private static final Logger log = LoggerFactory.getLogger(UacCreateTaskAtomServiceImpl.class);
    @Autowired
    private UacOrdTaskMapper uacOrdTaskMapper;
    @Autowired
    private UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper;
    @Autowired
    private UacApproveEntrustStationSelectAtomService uacApproveEntrustStationSelectAtomService;
    @Autowired
    private UocOrdTaskApproveEntrustMapper uocOrdTaskApproveEntrustMapper;

    @Override
    public UacCreateTaskRspBO createTask(UacCreateTaskReqBO reqBO) {
        List candidates;
        UacCreateTaskRspBO rspBO = new UacCreateTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Sequence sequence = Sequence.getInstance();
        OrdTaskPO taskPO = new OrdTaskPO();
        taskPO.setOrderId(reqBO.getOrderId());
        taskPO.setObjId(reqBO.getAuditOrderId());
        taskPO.setObjType(UacCommConstant.ORDER_TYPE.AUDIT_NO_TASK);
        taskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        StepWithOutInstance instance = reqBO.getInstance();
        taskPO.setTacheCode(instance.getStepId());
        taskPO.setProcInstId(instance.getProcDefId());
        taskPO.setBusiCode(instance.getProcDefKey());
        taskPO.setTaskName(instance.getStepName());
        taskPO.setProcTaskState(UacCommConstant.TASK_CREATE);
        taskPO.setCreateTime(new Date());
        taskPO.setTaskId(String.valueOf(sequence.nextId()));
        taskPO.setTaskType(reqBO.getTaskType());
        taskPO.setLimitTime(reqBO.getLimitTime());
        try {
            this.uacOrdTaskMapper.insert(taskPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u521b\u5efa\u4efb\u52a1\u5931\u8d25" + e.getMessage());
        }
        if (reqBO.getCandidates() != null && !reqBO.getCandidates().isEmpty()) {
            List<UacApproveEntrustBO> approvalInNotice = this.save(reqBO.getCandidates(), reqBO, sequence, taskPO, null);
            rspBO.setApprovalInNotice(approvalInNotice);
            return rspBO;
        }
        if (instance.getCustomAttributes() != null && !instance.getCustomAttributes().isEmpty()) {
            Map map = instance.getCustomAttributes();
            List<UacApproveEntrustBO> approvalInNotice = this.save(map, reqBO, sequence, taskPO, UacCommConstant.CandidateType.STATION);
            rspBO.setApprovalInNotice(approvalInNotice);
        }
        if (instance.getTaskList() != null && !instance.getTaskList().isEmpty() && (candidates = ((Task)instance.getTaskList().get(0)).getCandidates()) != null && candidates.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String str : candidates) {
                JSONObject jsonObject = JSON.parseObject((String)str);
                map.put(jsonObject.getString("userId"), jsonObject.getString("userName"));
            }
            List<UacApproveEntrustBO> approvalInNotice = this.save(map, reqBO, sequence, taskPO, UacCommConstant.CandidateType.USER);
            if (!CollectionUtils.isEmpty(rspBO.getApprovalInNotice())) {
                rspBO.getApprovalInNotice().addAll(approvalInNotice);
            } else {
                rspBO.setApprovalInNotice(approvalInNotice);
            }
        }
        rspBO.setTaskId(taskPO.getTaskId());
        return rspBO;
    }

    private List<UacApproveEntrustBO> save(Map<String, Object> map, UacCreateTaskReqBO reqBO, Sequence sequence, OrdTaskPO taskPO, Integer type) {
        ArrayList<OrdTaskCandidatePO> taskCandidatePOS = new ArrayList<OrdTaskCandidatePO>(map.size());
        for (String key : map.keySet()) {
            OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
            candidatePO.setOperName((String)map.get(key));
            candidatePO.setOperId(key);
            candidatePO.setType(type);
            candidatePO.setOrderId(reqBO.getOrderId());
            candidatePO.setId(sequence.nextId());
            candidatePO.setTaskId(taskPO.getTaskId());
            taskCandidatePOS.add(candidatePO);
        }
        try {
            this.uacOrdTaskCandidateMapper.insertBatch(taskCandidatePOS);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u521b\u5efa\u4efb\u52a1\u5019\u9009\u4eba\u5931\u8d25" + e.getMessage());
        }
        List<UacApproveEntrustBO> approvalInNotice = new ArrayList<UacApproveEntrustBO>();
        if (type != null && UacCommConstant.CandidateType.STATION.equals(type)) {
            approvalInNotice = this.saveApproveEntrust(map, taskPO);
        }
        return approvalInNotice;
    }

    private List<UacApproveEntrustBO> saveApproveEntrust(Map<String, Object> map, OrdTaskPO taskPO) {
        ArrayList<UacApproveEntrustBO> approvalInNotice = new ArrayList<UacApproveEntrustBO>();
        log.info("UacCreateTaskAtomService\u67e5\u8be2\u5904\u7406\u662f\u5426\u6709\u5ba1\u6279\u59d4\u6258\uff0c\u5165\u53c2map:" + map.keySet());
        try {
            HashSet<Long> stationIdSet = new HashSet<Long>();
            for (String operId : map.keySet()) {
                stationIdSet.add(Long.valueOf(operId));
            }
            if (!CollectionUtils.isEmpty(stationIdSet)) {
                UacApproveEntrustStationSelectAtomReqBO atomReqBO = new UacApproveEntrustStationSelectAtomReqBO();
                atomReqBO.setStationIds(new ArrayList<Long>(stationIdSet));
                UacApproveEntrustStationSelectAtomRspBO atomRspBO = this.uacApproveEntrustStationSelectAtomService.selectApproveEntrustStation(atomReqBO);
                if (!CollectionUtils.isEmpty(atomRspBO.getUserList())) {
                    Date nowDate = new Date();
                    ArrayList<UocOrdTaskApproveEntrustPO> list = new ArrayList<UocOrdTaskApproveEntrustPO>();
                    for (UacApproveEntrustStationSelectAtomBO bo : atomRspBO.getUserList()) {
                        UocOrdTaskApproveEntrustPO entrustPO = new UocOrdTaskApproveEntrustPO();
                        entrustPO.setId(Sequence.getInstance().nextId());
                        entrustPO.setTaskId(taskPO.getTaskId());
                        entrustPO.setOrderId(taskPO.getOrderId());
                        entrustPO.setEntrustUserId(bo.getEntrustUserId());
                        entrustPO.setEntrustUserCode(bo.getEntrustUserCode());
                        entrustPO.setEntrustUserName(bo.getEntrustUserName());
                        entrustPO.setCommissionedUserId(bo.getCommissionedUserId());
                        entrustPO.setCommissionedUserCode(bo.getCommissionedUserCode());
                        entrustPO.setCommissionedUserName(bo.getCommissionedUserName());
                        entrustPO.setIsApprovalInNotice(bo.getIsApprovalInNotice());
                        entrustPO.setIsApprovalEndNotice(bo.getIsApprovalEndNotice());
                        entrustPO.setCreateTime(nowDate);
                        list.add(entrustPO);
                        if (bo.getIsApprovalInNotice() == null || bo.getIsApprovalInNotice() != 0 || bo.getEntrustUserId() == null) continue;
                        UacApproveEntrustBO uacApproveEntrustBO = new UacApproveEntrustBO();
                        uacApproveEntrustBO.setEntrustUserId(bo.getEntrustUserId());
                        uacApproveEntrustBO.setEntrustUserCode(bo.getEntrustUserCode());
                        uacApproveEntrustBO.setEntrustUserName(bo.getEntrustUserName());
                        uacApproveEntrustBO.setCommissionedUserId(bo.getCommissionedUserId());
                        uacApproveEntrustBO.setCommissionedUserCode(bo.getCommissionedUserCode());
                        uacApproveEntrustBO.setCommissionedUserName(bo.getCommissionedUserName());
                        approvalInNotice.add(uacApproveEntrustBO);
                    }
                    this.uocOrdTaskApproveEntrustMapper.insertBatch(list);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u662f\u5426\u6709\u5ba1\u6279\u59d4\u6258\u5931\u8d25", (Throwable)e);
        }
        return approvalInNotice;
    }
}

