/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstRspBO;
import com.tydic.uac.atom.task.UacCreateTaskInstAtomService;
import com.tydic.uac.bo.task.TaskBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="UacCreateTaskInstAtomService")
public class UacCreateTaskInstAtomServiceImpl
implements UacCreateTaskInstAtomService {
    private UacOrdTaskMapper ordTaskMapper;
    private UacOrdTaskCandidateMapper ordTaskCandidateMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UacCreateTaskInstAtomServiceImpl.class);

    @Autowired
    public UacCreateTaskInstAtomServiceImpl(UacOrdTaskMapper ordTaskMapper, UacOrdTaskCandidateMapper ordTaskCandidateMapper) {
        this.ordTaskMapper = ordTaskMapper;
        this.ordTaskCandidateMapper = ordTaskCandidateMapper;
    }

    @Override
    @Transactional
    public UacCreateTaskInstRspBO dealCoreCreateTaskInst(UacCreateTaskInstReqBO reqBO) {
        LOGGER.debug("\u8ba2\u5355\u57fa\u7840\u4efb\u52a1\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5b9e\u73b0\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        Long orderId = reqBO.getOrderId();
        Integer objType = reqBO.getObjType();
        List<TaskBO> taskList = reqBO.getTaskList();
        if (orderId == null || objType == null || taskList == null || taskList.size() == 0) {
            throw new BusinessException("8000", "\u8ba2\u5355ID\u3001\u5355\u636e\u7c7b\u578b\u3001\u4efb\u52a1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UacCreateTaskInstRspBO rspBO = new UacCreateTaskInstRspBO();
        for (TaskBO taskInfo : taskList) {
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setTaskId(taskInfo.getTaskId());
            ordTaskPO.setOrderId(orderId);
            ordTaskPO.setObjId(reqBO.getObjId());
            ordTaskPO.setObjType(objType);
            ordTaskPO.setTaskName(taskInfo.getTaskName());
            ordTaskPO.setTacheCode(taskInfo.getTacheCode());
            ordTaskPO.setProcInstId(taskInfo.getProcInstId());
            ordTaskPO.setBusiCode(taskInfo.getBusiCode());
            ordTaskPO.setGroupId(taskInfo.getGroupId());
            ordTaskPO.setOwnOperName(taskInfo.getTaskAssignee());
            ordTaskPO.setTaskType(UacCommConstant.TASK_TYPE.HANDLE_TASK);
            ordTaskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
            ordTaskPO.setProcTaskState(UacCommConstant.TASK_CREATE);
            ordTaskPO.setTaskProperty(UacCommConstant.TASK_PROPERTY.COMMON_TASK);
            ordTaskPO.setCreateTime(DateUtils.strToDateLong((String)taskInfo.getCreateTime()));
            ordTaskPO.setLimitTime(DateUtils.strToDateLong((String)taskInfo.getDueDate()));
            this.ordTaskMapper.insert(ordTaskPO);
            ArrayList<OrdTaskCandidatePO> candidates = new ArrayList<OrdTaskCandidatePO>();
            if (!CollectionUtils.isEmpty((Collection)taskInfo.getCandidateIds())) {
                for (String operId : taskInfo.getCandidateIds()) {
                    this.candidate(candidates, operId, orderId, taskInfo);
                }
            }
            if (taskInfo.getTaskAssignee() != null) {
                this.candidate(candidates, taskInfo.getTaskAssignee(), orderId, taskInfo);
            }
            if (CollectionUtils.isEmpty(candidates)) continue;
            this.ordTaskCandidateMapper.insertBatch(candidates);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u521b\u5efa\u6210\u529f");
        return rspBO;
    }

    private void candidate(List<OrdTaskCandidatePO> candidates, String operId, Long orderId, TaskBO taskInfo) {
        OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
        Sequence sequence = Sequence.getInstance();
        candidatePO.setId(sequence.nextId());
        candidatePO.setOrderId(orderId);
        candidatePO.setTaskId(taskInfo.getTaskId());
        JSONObject jsonObject = JSON.parseObject((String)operId);
        candidatePO.setOperId(jsonObject.getString("userId"));
        candidatePO.setOperName(jsonObject.getString("userName"));
        candidates.add(candidatePO);
    }
}

