/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.TaskService;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstRspBO;
import com.tydic.uac.atom.bo.task.UacDealTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacDealTaskInstRspBO;
import com.tydic.uac.atom.task.UacCreateTaskInstAtomService;
import com.tydic.uac.atom.task.UacDealTaskInstAtomService;
import com.tydic.uac.bo.task.TaskBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.dao.task.UacOrdTaskRecordMapper;
import com.tydic.uac.dao.task.UacOrdVoucherProcessMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import com.tydic.uac.po.task.OrdTaskRecordPO;
import com.tydic.uac.po.task.OrdVoucherProcessPO;
import com.tydic.uac.util.ParamUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacDealTaskInstAtomService")
public class UacDealTaskInstAtomServiceImpl
implements UacDealTaskInstAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UacDealTaskInstAtomServiceImpl.class);
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String prcSysCode;
    private UacOrdTaskRecordMapper ordTaskRecordMapper;
    private UacOrdTaskMapper ordTaskMapper;
    private UacOrdVoucherProcessMapper ordVoucherProcMapper;
    private UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper;
    private TaskService taskService;
    private ProcessService processService;
    private UacCreateTaskInstAtomService createTaskInstAtomService;

    @Autowired
    public UacDealTaskInstAtomServiceImpl(UacOrdTaskRecordMapper ordTaskRecordMapper, UacOrdTaskMapper ordTaskMapper, UacOrdVoucherProcessMapper ordVoucherProcMapper, UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper, TaskService taskService, UacCreateTaskInstAtomService createTaskInstAtomService, ProcessService processService) {
        this.ordTaskRecordMapper = ordTaskRecordMapper;
        this.ordTaskMapper = ordTaskMapper;
        this.ordVoucherProcMapper = ordVoucherProcMapper;
        this.uacOrdTaskCandidateMapper = uacOrdTaskCandidateMapper;
        this.taskService = taskService;
        this.createTaskInstAtomService = createTaskInstAtomService;
        this.processService = processService;
    }

    @Override
    @Transactional
    public UacDealTaskInstRspBO dealCoreDealTaskInst(UacDealTaskInstReqBO reqBO) {
        String operId = reqBO.getOperId();
        String dealType = reqBO.getDealType();
        if (reqBO.getOrderId() == null || StringUtils.isBlank((String)reqBO.getTaskId()) || StringUtils.isBlank((String)operId) || StringUtils.isBlank((String)dealType)) {
            throw new BusinessException("8000", "\u8ba2\u5355ID\u3001\u4efb\u52a1ID\u3001\u5de5\u53f7\u3001\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long orderId = reqBO.getOrderId();
        String taskId = reqBO.getTaskId();
        UacDealTaskInstRspBO rspBO = new UacDealTaskInstRspBO();
        OrdTaskRecordPO ordTaskRecordPO = new OrdTaskRecordPO();
        Sequence sequence = Sequence.getInstance();
        ordTaskRecordPO.setId(sequence.nextId());
        ordTaskRecordPO.setOrderId(orderId);
        ordTaskRecordPO.setTaskId(taskId);
        ordTaskRecordPO.setDealDesc(reqBO.getDealDesc());
        ordTaskRecordPO.setDealOperId(operId);
        ordTaskRecordPO.setDealCode(dealType);
        try {
            OrdTaskPO ordTaskQuery = new OrdTaskPO();
            ordTaskQuery.setOrderId(orderId);
            ordTaskQuery.setTaskId(taskId);
            ordTaskQuery = this.ordTaskMapper.getModelBy(ordTaskQuery);
            if (ordTaskQuery == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4efb\u52a1ID\u4e3a" + taskId + "\u7684\u5f85\u5904\u7406\u4efb\u52a1\u5b9e\u4f8b");
                return rspBO;
            }
            OrdTaskPO ordTaskPO = new OrdTaskPO();
            ordTaskPO.setOrderId(orderId);
            ordTaskPO.setTaskId(taskId);
            if ("CLAIM".equals(dealType)) {
                OrdTaskCandidatePO taskCandidatePO = new OrdTaskCandidatePO();
                taskCandidatePO.setTaskId(taskId);
                taskCandidatePO.setOrderId(orderId);
                taskCandidatePO.setOperId(reqBO.getAssignOperId());
                int check = this.uacOrdTaskCandidateMapper.getCheckBy(taskCandidatePO);
                if (check < 1) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5de5\u53f7\u4e3a" + reqBO.getAssignOperId() + "\u7684\u4efb\u52a1\u5019\u9009\u4eba");
                    return rspBO;
                }
                ordTaskPO.setOwnOperId(reqBO.getAssignOperId());
                ordTaskPO.setOwnOperName(reqBO.getAssignOperName());
                this.ordTaskMapper.updateById(ordTaskPO);
            } else if ("COMPLETE".equals(dealType)) {
                NextStepsResult nextStepsResult = this.taskService.newTaskCompleteBuilder().variables(reqBO.getParamMap()).taskId(taskId).stepId(ordTaskQuery.getTacheCode()).completeWithInstance();
                ordTaskPO.setTaskState(UacCommConstant.TASK_STATE.PROCESSED);
                ordTaskPO.setProcTaskState(UacCommConstant.TASK_COMPLETE_SUCCESS);
                ordTaskPO.setFinishTime(new Date());
                this.ordTaskMapper.updateById(ordTaskPO);
                OrdVoucherProcessPO ordVoucherProcPO = new OrdVoucherProcessPO();
                ordVoucherProcPO.setOrderId(orderId);
                ordVoucherProcPO.setProcInstId(ordTaskQuery.getProcInstId());
                if (nextStepsResult.getIsfinish().booleanValue()) {
                    ordVoucherProcPO.setProcState("COMPLETE");
                    ordVoucherProcPO.setFinishTime(new Date());
                    this.ordVoucherProcMapper.updateById(ordVoucherProcPO);
                } else {
                    if ((ordVoucherProcPO = this.ordVoucherProcMapper.getModelBy(ordVoucherProcPO)) == null) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5b9e\u4f8bID\u4e3a" + ordTaskQuery.getProcInstId() + "\u7684\u5355\u636e\u4fe1\u606f");
                        return rspBO;
                    }
                    UacCreateTaskInstReqBO createTaskInstAtomReqBO = new UacCreateTaskInstReqBO();
                    createTaskInstAtomReqBO.setOrderId(orderId);
                    createTaskInstAtomReqBO.setObjId(UacCommConstant.OBJ_TYPE.ORDER.equals(ordVoucherProcPO.getObjType()) ? null : Long.valueOf(ordVoucherProcPO.getObjId()));
                    createTaskInstAtomReqBO.setObjType(ordVoucherProcPO.getObjType());
                    createTaskInstAtomReqBO.setOperId(operId);
                    if (CollectionUtils.isNotEmpty((Collection)nextStepsResult.getTaskList())) {
                        List<TaskBO> taskList = ParamUtils.getTask(nextStepsResult.getTaskList());
                        createTaskInstAtomReqBO.setTaskList(taskList);
                        rspBO.setTaskList(taskList);
                    }
                    createTaskInstAtomReqBO.setDealDesc(reqBO.getDealDesc());
                    UacCreateTaskInstRspBO createTaskInstAtomRspBO = this.createTaskInstAtomService.dealCoreCreateTaskInst(createTaskInstAtomReqBO);
                    if (!"0000".equals(createTaskInstAtomRspBO.getRespCode())) {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc(createTaskInstAtomRspBO.getRespDesc());
                        return rspBO;
                    }
                }
                rspBO.setIsFinish(nextStepsResult.getIsfinish());
            } else if ("DELETE".equals(dealType)) {
                this.processService.suspendProcessInstance(ordTaskQuery.getProcInstId());
                ordTaskPO.setTaskState(UacCommConstant.TASK_STATE.PROCESSED);
                ordTaskPO.setProcTaskState(UacCommConstant.TASK_COMPLETE_FAIL);
                ordTaskPO.setFinishTime(new Date());
                this.ordTaskMapper.updateById(ordTaskPO);
                OrdVoucherProcessPO ordVoucherProcPO = new OrdVoucherProcessPO();
                ordVoucherProcPO.setOrderId(orderId);
                ordVoucherProcPO.setProcInstId(ordTaskQuery.getProcInstId());
                ordVoucherProcPO.setProcState("DELETE");
                ordVoucherProcPO.setFinishTime(new Date());
                this.ordVoucherProcMapper.updateById(ordVoucherProcPO);
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
                return rspBO;
            }
            this.ordTaskRecordMapper.insert(ordTaskRecordPO);
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }
}

