/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uac.ability.bo.UacTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacTaskAuditCreateRspBO;
import com.tydic.uac.atom.UacAuditOrderCreateAtomService;
import com.tydic.uac.atom.UacCreateAuditLogAtomService;
import com.tydic.uac.atom.UacCreateLogParamAtomService;
import com.tydic.uac.atom.UacQryUserNameAtomService;
import com.tydic.uac.atom.bo.UacAuditOrderCreateAtomReqBO;
import com.tydic.uac.atom.bo.UacAuditOrderCreateAtomRspBO;
import com.tydic.uac.atom.bo.UacCreateAuditLogReqBO;
import com.tydic.uac.atom.bo.UacCreateAuditLogRsqBO;
import com.tydic.uac.atom.bo.UacCreateLogParamReqBO;
import com.tydic.uac.atom.bo.UacQryUserNameReqBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.busi.UacTaskAuditCreateBusiService;
import com.tydic.uac.busi.impl.UacNoTaskAuditCreateBusiServiceImpl;
import com.tydic.uac.exception.BusinessException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacTaskAuditCreateBusiService")
public class UacTaskAuditCreateBusiServiceImpl
implements UacTaskAuditCreateBusiService {
    @Autowired
    private UacAuditOrderCreateAtomService uocAuditOrderCreateAtomService;
    @Autowired
    private UacCreateLogParamAtomService uacCreateLogParamAtomService;
    @Autowired
    private UacCreateAuditLogAtomService uocAuditLogAtomService;
    private Logger logger = LoggerFactory.getLogger(UacNoTaskAuditCreateBusiServiceImpl.class);
    @Autowired
    private UacQryUserNameAtomService uacQryUserNameAtomService;

    @Transactional
    public UacTaskAuditCreateRspBO auditOrderCreate(UacTaskAuditCreateReqBO reqBO) {
        this.validateParam(reqBO);
        UacTaskAuditCreateRspBO rspBO = new UacTaskAuditCreateRspBO();
        UacAuditOrderCreateAtomReqBO uocAuditOrderCreateAtomReqBO = this.uocAuditOrderCreateAtomParam(reqBO);
        UacAuditOrderCreateAtomRspBO uocAuditOrderCreateAtomRspBO = this.uocAuditOrderCreateAtomService.dealAuditOrderCreate(uocAuditOrderCreateAtomReqBO);
        if (!"0000".equals(uocAuditOrderCreateAtomRspBO.getRespCode())) {
            throw new BusinessException("6001", "\u8c03\u7528\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + uocAuditOrderCreateAtomRspBO.getRespDesc());
        }
        BeanUtils.copyProperties((Object)((Object)uocAuditOrderCreateAtomRspBO), (Object)rspBO);
        rspBO.setTaskList(uocAuditOrderCreateAtomRspBO.getTaskList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        this.saveLog(uocAuditOrderCreateAtomRspBO, reqBO);
        return rspBO;
    }

    private void saveLog(UacAuditOrderCreateAtomRspBO rspBO, UacTaskAuditCreateReqBO reqBO) {
        try {
            this.logger.debug("\u521b\u5efa\u65e5\u5fd7log\uff1a" + JSON.toJSONString((Object)((Object)rspBO)));
            UacCreateAuditLogReqBO logReqBO = new UacCreateAuditLogReqBO();
            logReqBO.setOperid(reqBO.getCreateOperId());
            if (StringUtils.isNotBlank((CharSequence)reqBO.getRemark())) {
                logReqBO.setAuditAdvice(reqBO.getRemark());
            } else {
                logReqBO.setAuditAdvice("\u53d1\u8d77\u5ba1\u6279");
            }
            logReqBO.setOperName(this.getName(reqBO.getCreateOperId()));
            logReqBO.setCreateTime(rspBO.getApprovalOrderPO().getCreateTime() == null ? new Date() : rspBO.getApprovalOrderPO().getCreateTime());
            UacCreateLogParamReqBO uacCreateLogParamReqBO = new UacCreateLogParamReqBO();
            uacCreateLogParamReqBO.setLogReqBO(logReqBO);
            uacCreateLogParamReqBO.setTaskList(rspBO.getTaskList());
            logReqBO = this.uacCreateLogParamAtomService.buildLogParam(uacCreateLogParamReqBO).getLogReqBO();
            logReqBO.setAuditOrderId(rspBO.getApprovalOrderPO().getAuditOrderId());
            logReqBO.setOrderId(rspBO.getOrderId());
            UacCreateAuditLogRsqBO logRsqBO = this.uocAuditLogAtomService.saveLog(logReqBO);
            if (!"0000".equals(logRsqBO.getRespCode())) {
                throw new BusinessException("6001", logRsqBO.getRespDesc());
            }
        }
        catch (Exception e) {
            this.logger.debug("\u5ba1\u6279\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25" + e.getMessage());
            throw new BusinessException("6001", "\u5ba1\u6279\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private void validateParam(UacTaskAuditCreateReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getObjType()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u7c7b\u578b\uff08objType\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getObjNum()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u6570\u91cf\uff08objNum\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getApprovalObjInfo()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u5bf9\u8c61\u4fe1\u606f\uff08approvalObjInfo\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getBusiCode()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e1a\u52a1\u7f16\u7801\uff08busiCode\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != reqBO.getApprovalObjInfo()) {
            for (ApprovalObjBO approvalObjBO : reqBO.getApprovalObjInfo()) {
                if (null != approvalObjBO.getObjId()) continue;
                throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u5bf9\u8c61\u4fe1\u606f\u4e2d\u5bf9\u8c61ID\uff08objId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private UacAuditOrderCreateAtomReqBO uocAuditOrderCreateAtomParam(UacTaskAuditCreateReqBO reqBO) {
        UacAuditOrderCreateAtomReqBO uocAuditOrderCreateAtomReqBO = new UacAuditOrderCreateAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocAuditOrderCreateAtomReqBO);
        uocAuditOrderCreateAtomReqBO.setObjType(reqBO.getObjType());
        uocAuditOrderCreateAtomReqBO.setObjNum(reqBO.getObjNum());
        uocAuditOrderCreateAtomReqBO.setBusiCode(reqBO.getBusiCode());
        uocAuditOrderCreateAtomReqBO.setAuditConsumerType(reqBO.getAuditConsumerType());
        if (null != reqBO.getExtField1()) {
            uocAuditOrderCreateAtomReqBO.setExtField1(reqBO.getExtField1());
        }
        if (null != reqBO.getParamMap()) {
            uocAuditOrderCreateAtomReqBO.setParamMap(reqBO.getParamMap());
        }
        uocAuditOrderCreateAtomReqBO.setOrderId(reqBO.getOrderId());
        uocAuditOrderCreateAtomReqBO.setCreateOperId(reqBO.getCreateOperId());
        uocAuditOrderCreateAtomReqBO.setApprovalObjInfo(reqBO.getApprovalObjInfo());
        return uocAuditOrderCreateAtomReqBO;
    }

    private String getName(String id) {
        UacQryUserNameReqBO uacQryUserNameReqBO = new UacQryUserNameReqBO();
        uacQryUserNameReqBO.setUserId(id);
        return this.uacQryUserNameAtomService.qryUserName(uacQryUserNameReqBO).getUserName();
    }
}

