/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.tydic.uac.bo.common.ApprovalOrderBO;
import com.tydic.uac.busi.UacTaskAuditOrderAuditBusiService;
import com.tydic.uac.busi.bo.UacTaskAuditOrderAuditBusiReqBO;
import com.tydic.uac.busi.bo.UacTaskAuditOrderAuditBusiRspBO;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.util.FieldTranslationUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacTaskAuditOrderAuditBusiService")
public class UacTaskAuditOrderAuditBusiServiceImpl
implements UacTaskAuditOrderAuditBusiService {
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;

    @Transactional
    public UacTaskAuditOrderAuditBusiRspBO dealObjectAudit(UacTaskAuditOrderAuditBusiReqBO reqBO) {
        ApprovalObjPO approvalObjPO;
        ApprovalOrderPO modelBy;
        this.validateParam(reqBO);
        UacTaskAuditOrderAuditBusiRspBO rspBO = new UacTaskAuditOrderAuditBusiRspBO();
        ApprovalOrderPO approvalOrderObjTypeParam = this.getApprovalOrderObjTypeParam(reqBO);
        ApprovalOrderBO approvalOrderBO = new ApprovalOrderBO();
        try {
            if (approvalOrderObjTypeParam.getOrderId() != null) {
                modelBy = this.approvalOrderMapper.getModelBy(approvalOrderObjTypeParam);
            } else {
                approvalObjPO = new ApprovalObjPO();
                approvalObjPO.setObjType(reqBO.getObjType());
                approvalObjPO.setObjId(reqBO.getObjId());
                List<ApprovalOrderPO> list = this.approvalOrderMapper.getByObjId(approvalObjPO);
                if (CollectionUtils.isEmpty(list)) {
                    throw new BusinessException("6001", "\u901a\u8fc7\u8ba2\u5355ID\uff08orderId\uff09\u8c03\u7528\u5ba1\u6279\u5355\u8868\uff08ApprovalOrderMapper\uff09\u67e5\u8be2\u5bf9\u5e94\u7684\u5bf9\u8c61\u7c7b\u578b\u5f02\u5e38\uff01");
                }
                modelBy = list.get(0);
            }
            BeanUtils.copyProperties((Object)modelBy, (Object)approvalOrderBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("6001", "\u901a\u8fc7\u8ba2\u5355ID\uff08orderId\uff09\u8c03\u7528\u5ba1\u6279\u5355\u8868\uff08ApprovalOrderMapper\uff09\u67e5\u8be2\u5bf9\u5e94\u7684\u5bf9\u8c61\u7c7b\u578b\u5f02\u5e38\uff01");
        }
        if (null != reqBO.getAuditAdvice()) {
            modelBy.setRemark(reqBO.getAuditAdvice());
        }
        modelBy.setPreOperId(modelBy.getUpdateOperId());
        modelBy.setUpdateOperId(reqBO.getOperId());
        modelBy.setUpdateTime(new Date());
        this.approvalOrderMapper.updateById(modelBy);
        approvalObjPO = this.buildApprovalObjParam(modelBy);
        List<ApprovalObjPO> approvalObjPOList = this.approvalObjMapper.getList(approvalObjPO);
        ArrayList<String> objIdList = new ArrayList<String>();
        for (ApprovalObjPO approvalObjPOL : approvalObjPOList) {
            objIdList.add(approvalObjPOL.getObjId());
        }
        rspBO.setObjIdList(objIdList);
        ApprovalOrderBO approvalOrderBOTranslation = this.approvalOrderFieldTranslation(approvalOrderBO);
        rspBO.setApprovalOrderInfo(approvalOrderBOTranslation);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u5bf9\u8c61\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private void validateParam(UacTaskAuditOrderAuditBusiReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u5bf9\u8c61\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOrderId() && null == reqBO.getObjId()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u5bf9\u8c61\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\uff08orderId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getAuditResult()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u5bf9\u8c61\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u7ed3\u679c\uff08auditResult\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getOperId()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u5bf9\u8c61\u5ba1\u6279\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u5904\u7406\u4eba\uff08operId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private ApprovalOrderPO getApprovalOrderObjTypeParam(UacTaskAuditOrderAuditBusiReqBO reqBO) {
        ApprovalOrderPO approvalOrderPO = new ApprovalOrderPO();
        approvalOrderPO.setOrderId(reqBO.getOrderId());
        return approvalOrderPO;
    }

    private ApprovalObjPO buildApprovalObjParam(ApprovalOrderPO reqBO) {
        ApprovalObjPO approvalObjPO = new ApprovalObjPO();
        approvalObjPO.setOrderId(reqBO.getOrderId());
        return approvalObjPO;
    }

    private ApprovalOrderBO approvalOrderFieldTranslation(ApprovalOrderBO approvalOrderBO) {
        FieldTranslationUtil.approvalObjTypeStr(approvalOrderBO);
        FieldTranslationUtil.approvalStatusStr(approvalOrderBO);
        return approvalOrderBO;
    }
}

