/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.ability.bo.UacTaskAuditUpdateCandidateReqBO;
import com.tydic.uac.ability.bo.UacTaskAuditUpdateCandidateRspBO;
import com.tydic.uac.busi.UacTaskAuditUpdateCandidateBusiService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UacTaskAuditUpdateCandidateBusiServiceImpl
implements UacTaskAuditUpdateCandidateBusiService {
    private static final Logger log = LoggerFactory.getLogger(UacTaskAuditUpdateCandidateBusiServiceImpl.class);
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private UacOrdTaskMapper uacOrdTaskMapper;
    @Autowired
    private UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper;

    @Transactional
    public UacTaskAuditUpdateCandidateRspBO updateCandidate(UacTaskAuditUpdateCandidateReqBO reqBO) {
        if (reqBO.getAuditOrderId() == null) {
            throw new BusinessException("8000", "\u5ba1\u6279\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getCandidates() == null || reqBO.getCandidates().size() == 0) {
            throw new BusinessException("8000", "\u5019\u9009\u4eba\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ApprovalOrderPO selectApprovalOrderPO = new ApprovalOrderPO();
        selectApprovalOrderPO.setAuditOrderId(reqBO.getAuditOrderId());
        ApprovalOrderPO approvalOrderPO = this.approvalOrderMapper.getModelBy(selectApprovalOrderPO);
        if (approvalOrderPO != null) {
            OrdTaskPO selectOrdTaskPO = new OrdTaskPO();
            selectOrdTaskPO.setOrderId(approvalOrderPO.getOrderId());
            selectOrdTaskPO.setObjId(approvalOrderPO.getAuditOrderId());
            selectOrdTaskPO.setObjType(UacCommConstant.ORDER_TYPE.AUDIT_NO_TASK);
            selectOrdTaskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
            OrdTaskPO ordTaskPO = null;
            try {
                ordTaskPO = this.uacOrdTaskMapper.getModelBy(selectOrdTaskPO);
            }
            catch (Exception e) {
                log.debug("\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25" + e.getMessage());
                throw new BusinessException("6001", "\u67e5\u8be2\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
            }
            if (ordTaskPO != null) {
                try {
                    OrdTaskCandidatePO deleteOrdTaskCandidatePO = new OrdTaskCandidatePO();
                    deleteOrdTaskCandidatePO.setTaskId(ordTaskPO.getTaskId());
                    this.uacOrdTaskCandidateMapper.deleteBy(deleteOrdTaskCandidatePO);
                    ArrayList<OrdTaskCandidatePO> taskCandidatePOS = new ArrayList<OrdTaskCandidatePO>();
                    for (String key : reqBO.getCandidates().keySet()) {
                        OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
                        candidatePO.setOperName((String)reqBO.getCandidates().get(key));
                        candidatePO.setOperId(key);
                        candidatePO.setType(reqBO.getType());
                        candidatePO.setOrderId(ordTaskPO.getOrderId());
                        candidatePO.setId(Sequence.getInstance().nextId());
                        candidatePO.setTaskId(ordTaskPO.getTaskId());
                        taskCandidatePOS.add(candidatePO);
                    }
                    this.uacOrdTaskCandidateMapper.insertBatch(taskCandidatePOS);
                }
                catch (Exception e) {
                    throw new BusinessException("6001", "\u521b\u5efa\u4efb\u52a1\u5019\u9009\u4eba\u5931\u8d25" + e.getMessage());
                }
                UacTaskAuditUpdateCandidateRspBO rspBO = new UacTaskAuditUpdateCandidateRspBO();
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            throw new BusinessException("6001", "\u672a\u67e5\u8be2\u5230\u73af\u8282\u5b9e\u4f8b");
        }
        throw new BusinessException("6001", "auditOrderId\u4e3a\uff1a" + reqBO.getAuditOrderId() + "\u7684\u8ba2\u5355\u5ba1\u6279\u5355\u4e0d\u5b58\u5728");
    }
}

