/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class PageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PageUtil.class);
    private static final Integer PAGE_SIZE = 500;

    private static Integer getTotalRecordCount(JdbcTemplate jdbcTemplate, String sql, Object ... args) {
        StringBuilder sqlBuilder = new StringBuilder("select count(*) as total from (");
        sqlBuilder.append(sql);
        sqlBuilder.append(") al");
        LOG.debug("\u67e5\u8be2\u603b\u6761\u6570sql:[{}]", (Object)sqlBuilder.toString());
        List maps = jdbcTemplate.queryForList(sqlBuilder.toString(), args);
        Integer total = 0;
        for (Map next1 : maps) {
            total = ((Long)next1.get("total")).intValue();
        }
        return total;
    }

    public static Integer getPageCount(JdbcTemplate jdbcTemplate, String sql, Object ... args) {
        Integer totalRecordCount = PageUtil.getTotalRecordCount(jdbcTemplate, sql, args);
        return (int)Math.ceil((double)totalRecordCount.intValue() / (double)PAGE_SIZE.intValue());
    }

    public static List<Map<String, Object>> getPageRecord(JdbcTemplate jdbcTemplate, String sql, Integer pageNumber, Object ... args) {
        int startPos = (pageNumber - 1) * PAGE_SIZE;
        StringBuilder sqlBuilder = new StringBuilder(sql);
        sqlBuilder.append(" limit ");
        sqlBuilder.append(startPos);
        sqlBuilder.append(",").append(PAGE_SIZE);
        return jdbcTemplate.queryForList(sqlBuilder.toString(), args);
    }

    public static List<Object[]> getPageObjectList(JdbcTemplate jdbcTemplate, String sql, Integer pageNumber, Object ... args) throws Exception {
        int startPos = (pageNumber - 1) * PAGE_SIZE;
        StringBuilder sqlBuilder = new StringBuilder(sql);
        sqlBuilder.append(" limit ");
        sqlBuilder.append(startPos);
        sqlBuilder.append(",").append(PAGE_SIZE);
        final ArrayList<Object[]> retList = new ArrayList<Object[]>();
        RowCallbackHandler handler = new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                int columnCount = resultSet.getMetaData().getColumnCount();
                LOG.debug("\u5217\u603b\u662f\uff1a" + columnCount);
                while (resultSet.next()) {
                    Object[] parm = new Object[columnCount];
                    for (int i = 1; i <= columnCount; ++i) {
                        LOG.debug(resultSet.getObject(i).toString());
                        parm[i - 1] = resultSet.getObject(i).toString();
                    }
                    retList.add(parm);
                }
            }
        };
        jdbcTemplate.query(sqlBuilder.toString(), args, handler);
        return retList;
    }
}

