/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.util;

import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.util.CollectionUtils;

public class ListUtils {
    public static final int DEFAULT_BATCH_LIST_SIZE = 200;

    public static <T> List<T> removeNull(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<T> list1 = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            T object = list.get(i);
            if (null == object) continue;
            list1.add(object);
        }
        return list1;
    }

    public static <T> List<T> removeReapet(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<T> list1 = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            if (list1.contains(list.get(i))) continue;
            list1.add(list.get(i));
        }
        return list1;
    }

    public static <T> List<List<T>> batchListToSize(@NotNull List<T> list, int batchSize) {
        if (batchSize < 1) {
            batchSize = 200;
        }
        return ListUtils.getListList(list, batchSize);
    }

    public static <T> List<List<T>> batchListToCount(@NotNull List<T> list, int batchSize) {
        if (batchSize >= list.size()) {
            return ListUtils.batchListToSize(list, 1);
        }
        if (batchSize <= 1) {
            ArrayList<List<T>> alist = new ArrayList<List<T>>();
            alist.add(list);
            return alist;
        }
        int size = list.size() % batchSize == 0 ? list.size() / batchSize : list.size() / batchSize + 1;
        return ListUtils.getListList(list, size);
    }

    private static <T> List<List<T>> getListList(List<T> list, int batchSize) {
        ArrayList<List<T>> batchList = new ArrayList<List<T>>();
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T obj : list) {
            arrayList.add(obj);
            if (arrayList.size() < batchSize) continue;
            batchList.add(arrayList);
            arrayList = new ArrayList();
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            batchList.add(arrayList);
        }
        return batchList;
    }
}

