/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.atom.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tydic.uec.atom.UecAnswerListQryAtomService;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomReqBO;
import com.tydic.uec.atom.bo.UecAnswerListQryAtomRspBO;
import com.tydic.uec.common.bo.answer.CommodityAnswerBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.CommodityAnswerMapper;
import com.tydic.uec.dao.po.CommodityAnswerPO;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecAnswerListQryAtomServiceImpl
implements UecAnswerListQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(UecAnswerListQryAtomServiceImpl.class);
    private static final String ORDER_COLUMN = "ANSWER_TIME DESC";
    private final CommodityAnswerMapper commodityAnswerMapper;
    private final RedisUtil redisUtil;

    @Autowired
    public UecAnswerListQryAtomServiceImpl(CommodityAnswerMapper commodityAnswerMapper, RedisUtil redisUtil) {
        this.commodityAnswerMapper = commodityAnswerMapper;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecAnswerListQryAtomRspBO qryAnswerList(UecAnswerListQryAtomReqBO reqBO) {
        UecAnswerListQryAtomRspBO rspBO;
        String redisQryKey = this.getAnswerListRedisKey(reqBO);
        Long redisListSize = null;
        boolean saveRedis = false;
        if (redisQryKey != null && (redisListSize = this.redisUtil.zGetSize(redisQryKey)) != null) {
            saveRedis = true;
            rspBO = this.returnAnswerListFromRedis(redisQryKey, redisListSize.intValue(), reqBO.getPageNo(), reqBO.getPageSize());
            if (rspBO != null) {
                return rspBO;
            }
        }
        rspBO = new UecAnswerListQryAtomRspBO();
        CommodityAnswerPO paramPO = new CommodityAnswerPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)paramPO);
        paramPO.setOrderBy(ORDER_COLUMN);
        Page answerPage = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.commodityAnswerMapper.getList(paramPO));
        ArrayList<CommodityAnswerBO> answerList = new ArrayList<CommodityAnswerBO>(reqBO.getPageSize());
        if (!CollectionUtils.isEmpty((Collection)answerPage.getResult())) {
            if (saveRedis && (long)((reqBO.getPageNo() - 1) * reqBO.getPageSize()) > redisListSize) {
                saveRedis = false;
            }
            HashSet answerIdTuples = null;
            HashMap answerInfoMap = null;
            if (saveRedis) {
                answerIdTuples = Sets.newHashSetWithExpectedSize((int)reqBO.getPageSize());
                answerInfoMap = Maps.newHashMapWithExpectedSize((int)(reqBO.getPageSize() + 1));
            }
            this.handleAnswerListProcess(answerList, answerPage.getResult(), answerIdTuples, answerInfoMap);
            if (saveRedis) {
                this.saveAnswerListIntoRedis(redisQryKey, redisListSize.intValue(), answerPage.getResult().size(), (int)answerPage.getTotal(), answerIdTuples, answerInfoMap);
            }
        } else {
            this.redisUtil.hashSet("uec_answer_list_", redisQryKey + "_totalRecords", 0, UecRedisConstant.getExpireMinutes(30, 5));
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotalRecords((int)answerPage.getTotal());
        rspBO.setTotalPages(answerPage.getPages());
        rspBO.setRows(answerList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u56de\u7b54\u5217\u8868\u6210\u529f");
        return rspBO;
    }

    private String getAnswerListRedisKey(UecAnswerListQryAtomReqBO reqBO) {
        String redisKey = null;
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getState()) && reqBO.getQuestionId() != null && StringUtils.isBlank((CharSequence)reqBO.getMemId()) && reqBO.getIsAnonymous() == null) {
            redisKey = "uec_answer_list_" + reqBO.getQuestionId();
        }
        return redisKey;
    }

    private UecAnswerListQryAtomRspBO returnAnswerListFromRedis(String redisKey, int redisListSize, int pageNo, int pageSize) {
        Object hashCount = this.redisUtil.hashGet("uec_answer_list_", redisKey + "_totalRecords");
        if (hashCount == null) {
            return null;
        }
        int totalCount = (Integer)hashCount;
        if (totalCount == 0) {
            UecAnswerListQryAtomRspBO rspBO = new UecAnswerListQryAtomRspBO();
            rspBO.setPageNo(pageNo);
            rspBO.setTotalRecords(totalCount);
            rspBO.setTotalPages(totalCount);
            rspBO.setRows(new ArrayList());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u56de\u7b54\u5217\u8868\u6210\u529f");
            return rspBO;
        }
        if ((pageNo - 1) * pageSize < redisListSize) {
            boolean notInPage;
            int totalPage = (totalCount - 1) / pageSize + 1;
            boolean bl = notInPage = pageNo < totalPage && pageNo * pageSize > redisListSize || pageNo == totalPage && totalCount - (totalPage - 1) * pageSize != redisListSize - (pageNo - 1) * pageSize;
            if (notInPage) {
                return null;
            }
            Set<Object> answerIds = this.redisUtil.zGet(redisKey, (pageNo - 1) * pageSize, pageNo * pageSize - 1, true);
            if (CollectionUtils.isEmpty(answerIds)) {
                return null;
            }
            List<Object> hashObjects = this.redisUtil.hashMultiGet("uec_answer_list_", answerIds);
            if (CollectionUtils.isEmpty(hashObjects) || hashObjects.size() != answerIds.size()) {
                this.redisUtil.zRemove(redisKey, answerIds.toArray());
                return null;
            }
            ArrayList<CommodityAnswerBO> answerList = new ArrayList<CommodityAnswerBO>(hashObjects.size());
            try {
                for (Object e : hashObjects) {
                    if (e == null) continue;
                    answerList.add((CommodityAnswerBO)e);
                }
            }
            catch (ClassCastException e) {
                log.error("\u56de\u7b54\u5217\u8868\u67e5\u8be2\u670d\u52a1\u7f13\u5b58\u5bf9\u8c61\u8f6c\u56de\u7b54\u5bf9\u8c61\u5f02\u5e38");
                this.redisUtil.hashDel("uec_answer_list_", answerIds.toArray());
            }
            if (answerList.size() != answerIds.size()) {
                this.redisUtil.zRemove(redisKey, answerIds.toArray());
                return null;
            }
            UecAnswerListQryAtomRspBO rspBO = new UecAnswerListQryAtomRspBO();
            rspBO.setPageNo(pageNo);
            rspBO.setTotalRecords(totalCount);
            rspBO.setTotalPages(totalPage);
            rspBO.setRows(answerList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u56de\u7b54\u5217\u8868\u6210\u529f");
            return rspBO;
        }
        return null;
    }

    private void handleAnswerListProcess(List<CommodityAnswerBO> answerList, List<CommodityAnswerPO> answerPOList, Set<ZSetOperations.TypedTuple<Object>> answerIdTuples, Map<String, Object> answerInfoMap) {
        boolean saveRedis = answerIdTuples != null;
        for (CommodityAnswerPO answerPO : answerPOList) {
            CommodityAnswerBO answerBO = new CommodityAnswerBO();
            BeanUtils.copyProperties((Object)answerPO, (Object)answerBO);
            if (StringUtils.isNotBlank((CharSequence)answerBO.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(answerBO.getIsAnonymous())) {
                answerBO.setMemName(answerBO.getMemName().substring(0, 1) + "***" + answerBO.getMemName().substring(answerBO.getMemName().length() - 1));
            }
            answerBO.setAnswerId(answerPO.getAnswerId().toString());
            answerList.add(answerBO);
            if (!saveRedis) continue;
            answerIdTuples.add((ZSetOperations.TypedTuple<Object>)new DefaultTypedTuple((Object)answerBO.getAnswerId(), Double.valueOf(answerBO.getAnswerTime().getTime())));
            answerInfoMap.put(answerBO.getAnswerId(), answerBO);
        }
    }

    private void saveAnswerListIntoRedis(String redisKey, int redisListSize, int saveSize, int totalCount, Set<ZSetOperations.TypedTuple<Object>> answerIdTuples, Map<String, Object> answerInfoMap) {
        if (redisListSize + saveSize > 30) {
            this.redisUtil.zRemoveRange(redisKey, 0L, redisListSize + saveSize - 30 - 1);
        }
        this.redisUtil.zAddTuple(redisKey, answerIdTuples, UecRedisConstant.getExpireMinutes(30, 10));
        answerInfoMap.put(redisKey + "_totalRecords", totalCount);
        this.redisUtil.hashMapSet("uec_answer_list_", answerInfoMap, UecRedisConstant.getExpireMinutes(30, 30));
    }
}

