/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.atom.UecReplyListQryAtomService;
import com.tydic.uec.atom.bo.UecReplyListQryAtomReqBO;
import com.tydic.uec.atom.bo.UecReplyListQryAtomRspBO;
import com.tydic.uec.busi.UecAnswerDetailQryBusiService;
import com.tydic.uec.busi.bo.UecAnswerDetailQryBusiReqBO;
import com.tydic.uec.busi.bo.UecAnswerDetailQryBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.common.bo.answer.AnswerThumbUpRecBO;
import com.tydic.uec.common.bo.answer.CommodityAnswerBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.dao.AnswerExtMapper;
import com.tydic.uec.dao.AnswerThumbUpRecMapper;
import com.tydic.uec.dao.CommodityAnswerMapper;
import com.tydic.uec.dao.po.AnswerExtPO;
import com.tydic.uec.dao.po.AnswerThumbUpRecPO;
import com.tydic.uec.dao.po.CommodityAnswerPO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecAnswerDetailQryBusiServiceImpl
implements UecAnswerDetailQryBusiService {
    private final CommodityAnswerMapper commodityAnswerMapper;
    private final UecReplyListQryAtomService uecReplyListQryAtomService;
    private final AnswerExtMapper answerExtMapper;
    private final AnswerThumbUpRecMapper answerThumbUpRecMapper;

    @Autowired
    public UecAnswerDetailQryBusiServiceImpl(CommodityAnswerMapper commodityAnswerMapper, UecReplyListQryAtomService uecReplyListQryAtomService, AnswerExtMapper answerExtMapper, AnswerThumbUpRecMapper answerThumbUpRecMapper) {
        this.commodityAnswerMapper = commodityAnswerMapper;
        this.uecReplyListQryAtomService = uecReplyListQryAtomService;
        this.answerExtMapper = answerExtMapper;
        this.answerThumbUpRecMapper = answerThumbUpRecMapper;
    }

    @Override
    public UecAnswerDetailQryBusiRspBO qryAnswerDetail(UecAnswerDetailQryBusiReqBO reqBO) {
        UecAnswerDetailQryBusiRspBO rspBO = new UecAnswerDetailQryBusiRspBO();
        Long questionId = reqBO.getQuestionId();
        Long answerId = reqBO.getAnswerId();
        CommodityAnswerPO answerPO = new CommodityAnswerPO();
        answerPO.setQuestionId(questionId);
        answerPO.setAnswerId(answerId);
        answerPO = this.commodityAnswerMapper.getModelBy(answerPO);
        if (answerPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u67e5\u8be2\u56de\u7b54\u8be6\u60c5\u5931\u8d25\uff0c\u56de\u7b54\u4e0d\u5b58\u5728[questionId=" + questionId + "\uff0canswerId=" + answerId + "]");
            return rspBO;
        }
        CommodityAnswerBO answerInfo = new CommodityAnswerBO();
        BeanUtils.copyProperties((Object)answerPO, (Object)answerInfo);
        answerInfo.setAnswerId(answerId.toString());
        rspBO.setAnswerInfo(answerInfo);
        UecReplyListQryAtomReqBO atomReqBO = new UecReplyListQryAtomReqBO();
        atomReqBO.setPageNo(reqBO.getPageNo());
        atomReqBO.setPageSize(reqBO.getPageSize());
        atomReqBO.setSysCode(reqBO.getSysCode());
        atomReqBO.setObjId(answerId.toString());
        atomReqBO.setObjType(UecCommonConstant.ReplyType.ANSWER);
        atomReqBO.setReplyState(UecCommonConstant.StateEnum.YES.value);
        atomReqBO.setSortByLikeCount(UecCommonConstant.YES_FLAG);
        UecReplyListQryAtomRspBO atomRspBO = this.uecReplyListQryAtomService.qryReplyList(atomReqBO);
        rspBO.setReplyRecords(atomRspBO.getTotalRecords());
        rspBO.setReplyPages(atomRspBO.getTotalPages());
        rspBO.setReplyList(atomRspBO.getRows());
        this.qryAnswerExtList(questionId, answerId, rspBO);
        this.qryLikeInfo(questionId, answerId, UecCommonConstant.YES_FLAG.equals(reqBO.getNeedLikeInfo()), rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u56de\u7b54\u8be6\u60c5\u6210\u529f");
        return rspBO;
    }

    private void qryAnswerExtList(Long questionId, Long answerId, UecAnswerDetailQryBusiRspBO rspBO) {
        AnswerExtPO extParam = new AnswerExtPO();
        extParam.setQuestionId(questionId);
        extParam.setAnswerId(answerId);
        List<AnswerExtPO> extPOList = this.answerExtMapper.getList(extParam);
        if (!CollectionUtils.isEmpty(extPOList)) {
            ArrayList<AnswerExtBO> extList = new ArrayList<AnswerExtBO>(extPOList.size());
            for (AnswerExtPO extPO : extPOList) {
                AnswerExtBO extBO = new AnswerExtBO();
                BeanUtils.copyProperties((Object)extPO, (Object)extBO);
                extList.add(extBO);
            }
            rspBO.setExtList(extList);
        }
    }

    private void qryLikeInfo(Long questionId, Long answerId, boolean qryDetail, UecAnswerDetailQryBusiRspBO rspBO) {
        AnswerThumbUpRecPO thumbParam = new AnswerThumbUpRecPO();
        thumbParam.setQuestionId(questionId);
        thumbParam.setAnswerId(answerId);
        thumbParam.setState(UecCommonConstant.StateEnum.YES.value);
        int likeCount = 0;
        if (qryDetail) {
            List<AnswerThumbUpRecPO> thumbPOList = this.answerThumbUpRecMapper.getList(thumbParam);
            if (!CollectionUtils.isEmpty(thumbPOList)) {
                likeCount = (int)thumbPOList.stream().filter(e -> UecCommonConstant.ThumbUpEnum.YES.value.equals(e.getThumbUpType())).count();
                ArrayList<AnswerThumbUpRecBO> thumbList = new ArrayList<AnswerThumbUpRecBO>(thumbPOList.size());
                for (AnswerThumbUpRecPO thumbUpRecPO : thumbPOList) {
                    AnswerThumbUpRecBO thumbBO = new AnswerThumbUpRecBO();
                    BeanUtils.copyProperties((Object)thumbUpRecPO, (Object)thumbBO);
                    thumbList.add(thumbBO);
                }
                rspBO.setThumbList(thumbList);
            }
        } else {
            thumbParam.setThumbUpType(UecCommonConstant.ThumbUpEnum.YES.value);
            likeCount = this.answerThumbUpRecMapper.getCountBy(thumbParam);
        }
        rspBO.setLikeCount(likeCount);
    }
}

