/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.tydic.uec.busi.UecQuestionCreateBusiService;
import com.tydic.uec.busi.bo.UecQuestionCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecQuestionCreateBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.common.bo.answer.CommodityQuestionBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.AnswerExtMapper;
import com.tydic.uec.dao.CommodityQuestionMapper;
import com.tydic.uec.dao.po.AnswerExtPO;
import com.tydic.uec.dao.po.CommodityQuestionPO;
import com.tydic.uec.utils.GenerateIdUtil;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecQuestionCreateBusiServiceImpl
implements UecQuestionCreateBusiService {
    private final CommodityQuestionMapper commodityQuestionMapper;
    private final AnswerExtMapper answerExtMapper;
    private final GenerateIdUtil generateIdUtil;
    private final RedisUtil redisUtil;

    @Autowired
    public UecQuestionCreateBusiServiceImpl(CommodityQuestionMapper commodityQuestionMapper, AnswerExtMapper answerExtMapper, GenerateIdUtil generateIdUtil, RedisUtil redisUtil) {
        this.commodityQuestionMapper = commodityQuestionMapper;
        this.answerExtMapper = answerExtMapper;
        this.generateIdUtil = generateIdUtil;
        this.redisUtil = redisUtil;
    }

    @Override
    public UecQuestionCreateBusiRspBO createQuestion(UecQuestionCreateBusiReqBO reqBO) {
        CommodityQuestionPO questionPO = new CommodityQuestionPO();
        BeanUtils.copyProperties((Object)reqBO.getQuestionInfo(), (Object)questionPO);
        questionPO.setQuestionId(this.generateIdUtil.nextId());
        this.commodityQuestionMapper.insert(questionPO);
        Long questionId = questionPO.getQuestionId();
        if (!CollectionUtils.isEmpty(reqBO.getExtList())) {
            ArrayList<AnswerExtPO> insertList = new ArrayList<AnswerExtPO>(reqBO.getExtList().size());
            for (AnswerExtBO extBO : reqBO.getExtList()) {
                AnswerExtPO extPO = new AnswerExtPO();
                BeanUtils.copyProperties((Object)extBO, (Object)extPO);
                extPO.setId(this.generateIdUtil.nextId());
                extPO.setQuestionId(questionId);
                insertList.add(extPO);
            }
            this.answerExtMapper.insertBatch(insertList);
        }
        if (UecCommonConstant.StateEnum.YES.value.equals(reqBO.getQuestionInfo().getState())) {
            this.saveQuestionIntoRedis(reqBO.getQuestionInfo(), questionId.toString());
        }
        UecQuestionCreateBusiRspBO rspBO = new UecQuestionCreateBusiRspBO();
        rspBO.setQuestionId(questionId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u95ee\u9898\u521b\u5efa\u6210\u529f");
        return rspBO;
    }

    private void saveQuestionIntoRedis(CommodityQuestionBO questionInfo, String questionId) {
        String memKey = "uec_question_list_" + questionInfo.getSysCode() + "_memId#" + questionInfo.getMemId();
        String objKey = "uec_question_list_" + questionInfo.getSysCode() + "_objType#" + questionInfo.getObjType() + "_objId#" + questionInfo.getObjId();
        questionInfo.setQuestionId(questionId);
        if (StringUtils.isNotBlank((String)questionInfo.getMemName()) && UecCommonConstant.AnonymousEnum.YES.value.equals(questionInfo.getIsAnonymous())) {
            questionInfo.setMemName(questionInfo.getMemName().substring(0, 1) + "***" + questionInfo.getMemName().substring(questionInfo.getMemName().length() - 1));
        }
        this.redisUtil.hashSet("uec_question_list_", questionId, questionInfo, UecRedisConstant.getExpireMinutes(30, 30));
        this.redisUtil.hashAdd("uec_question_list_", memKey + "_totalRecords", 1.0);
        this.redisUtil.hashAdd("uec_question_list_", objKey + "_totalRecords", 1.0);
        Long memKeySize = this.redisUtil.zGetSize(memKey);
        Long objKeySize = this.redisUtil.zGetSize(objKey);
        if (memKeySize != null && memKeySize > 0L) {
            this.redisUtil.zAdd(memKey, questionId, System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(30, 10));
        }
        if (objKeySize != null && objKeySize > 0L) {
            this.redisUtil.zAdd(objKey, questionId, System.currentTimeMillis(), UecRedisConstant.getExpireMinutes(30, 10));
        }
    }
}

