/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uec.busi.UecTemplateDetailQryBusiService;
import com.tydic.uec.busi.bo.UecTemplateDetailQryBusiReqBO;
import com.tydic.uec.busi.bo.UecTemplateDetailQryBusiRspBO;
import com.tydic.uec.common.bo.mod.ConfBaseFieldBO;
import com.tydic.uec.common.bo.mod.ConfEvaTypeBO;
import com.tydic.uec.common.bo.mod.ConfStarItemBO;
import com.tydic.uec.common.bo.mod.TemplateBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.constant.UecRedisConstant;
import com.tydic.uec.dao.ConfBaseFieldMapper;
import com.tydic.uec.dao.ConfEvaModMapper;
import com.tydic.uec.dao.ConfEvaTypeMapper;
import com.tydic.uec.dao.ConfItemLevelMapper;
import com.tydic.uec.dao.ConfStarItemMapper;
import com.tydic.uec.dao.UnionQuerySqlMapper;
import com.tydic.uec.dao.po.ConfBaseFieldPO;
import com.tydic.uec.dao.po.ConfEvaModPO;
import com.tydic.uec.dao.po.ConfEvaTypePO;
import com.tydic.uec.utils.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UecTemplateDetailQryBusiServiceImpl
implements UecTemplateDetailQryBusiService {
    private static final String NEED_STAR_INFO = "needStarInfo";
    private final RedisUtil redisUtil;
    private final ConfEvaModMapper confEvaModMapper;
    private final ConfEvaTypeMapper confEvaTypeMapper;
    private final ConfBaseFieldMapper confBaseFieldMapper;
    private final UnionQuerySqlMapper unionQuerySqlMapper;

    @Autowired
    public UecTemplateDetailQryBusiServiceImpl(RedisUtil redisUtil, ConfEvaModMapper confEvaModMapper, ConfEvaTypeMapper confEvaTypeMapper, ConfBaseFieldMapper confBaseFieldMapper, ConfStarItemMapper confStarItemMapper, ConfItemLevelMapper confItemLevelMapper, UnionQuerySqlMapper unionQuerySqlMapper) {
        this.redisUtil = redisUtil;
        this.confEvaModMapper = confEvaModMapper;
        this.confEvaTypeMapper = confEvaTypeMapper;
        this.confBaseFieldMapper = confBaseFieldMapper;
        this.unionQuerySqlMapper = unionQuerySqlMapper;
    }

    @Override
    public UecTemplateDetailQryBusiRspBO qryTemplateDetail(UecTemplateDetailQryBusiReqBO reqBO) {
        String redisKey = "uec_mod_detail_" + reqBO.getModId();
        Object hashValue = this.redisUtil.get(redisKey);
        if (hashValue != null) {
            UecTemplateDetailQryBusiRspBO rspBO = (UecTemplateDetailQryBusiRspBO)((Object)this.redisUtil.get(redisKey));
            int refreshMin = 10;
            if (this.redisUtil.getExpire(redisKey) < (long)refreshMin) {
                this.redisUtil.expire(redisKey, UecRedisConstant.getExpireMinutes(60, 5));
            }
            return rspBO;
        }
        UecTemplateDetailQryBusiRspBO rspBO = new UecTemplateDetailQryBusiRspBO();
        Long modId = Long.parseLong(reqBO.getModId());
        ConfEvaModPO confEvaModPO = this.confEvaModMapper.getModelById(modId);
        if (confEvaModPO == null) {
            rspBO.setRespCode("2222");
            rspBO.setRespDesc("\u67e5\u8be2\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728[modId=" + modId + "]");
            return rspBO;
        }
        if (UecCommonConstant.StateEnum.NO.value.equals(confEvaModPO.getState())) {
            rspBO.setRespCode("4001");
            rspBO.setRespDesc("\u67e5\u8be2\u6a21\u677f\u8be6\u60c5\u5931\u8d25\uff0c\u6a21\u677f\u5931\u6548[modId=" + modId + "]");
            return rspBO;
        }
        TemplateBO templateBO = new TemplateBO();
        BeanUtils.copyProperties((Object)confEvaModPO, (Object)templateBO);
        templateBO.setReviewLen(Integer.valueOf(confEvaModPO.getReviewLen() / UecCommonConstant.DAY_TO_SECONDS));
        templateBO.setPostLen(Integer.valueOf(confEvaModPO.getPostLen() / UecCommonConstant.DAY_TO_SECONDS));
        templateBO.setModId(confEvaModPO.getModId().toString());
        rspBO.setTemplateInfo(templateBO);
        ConfEvaTypePO evaTypePO = this.confEvaTypeMapper.getModelById(reqBO.getTypeCode());
        if (evaTypePO != null) {
            ConfEvaTypeBO evaTypeBO = new ConfEvaTypeBO();
            BeanUtils.copyProperties((Object)evaTypePO, (Object)evaTypeBO);
            rspBO.setConfEvaType(evaTypeBO);
        }
        List<ConfStarItemBO> starItemList = this.unionQuerySqlMapper.qryStarItemList(modId);
        ConfBaseFieldPO baseFieldParam = new ConfBaseFieldPO();
        baseFieldParam.setModId(modId);
        baseFieldParam.setOrderBy("sort");
        List<ConfBaseFieldPO> baseFieldPOList = this.confBaseFieldMapper.getList(baseFieldParam);
        if (!CollectionUtils.isEmpty(baseFieldPOList)) {
            ArrayList<ConfBaseFieldBO> baseFieldList = new ArrayList<ConfBaseFieldBO>(baseFieldPOList.size());
            for (ConfBaseFieldPO baseFieldPO : baseFieldPOList) {
                ConfBaseFieldBO baseField = new ConfBaseFieldBO();
                BeanUtils.copyProperties((Object)baseFieldPO, (Object)baseField);
                if (StringUtils.isNotBlank((CharSequence)baseFieldPO.getApiInParam())) {
                    JSONObject paramJson = JSONObject.parseObject((String)baseFieldPO.getApiInParam());
                    if (UecCommonConstant.YES_FLAG.toString().equals(paramJson.get((Object)NEED_STAR_INFO))) {
                        ConfBaseFieldBO filterBaseField = baseField;
                        baseField.setStarItemList(starItemList.stream().filter(item -> filterBaseField.getFieldCode().equals(item.getItemCode())).collect(Collectors.toList()));
                    }
                }
                baseFieldList.add(baseField);
            }
            rspBO.setBaseFieldList(baseFieldList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6a21\u677f\u8be6\u60c5\u6210\u529f");
        this.redisUtil.set(redisKey, (Object)rspBO, UecRedisConstant.getExpireMinutes(60, 5));
        return rspBO;
    }
}

