/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecAnswerQuestionAbilityService;
import com.tydic.uec.ability.bo.UecAnswerQuestionAbilityReqBO;
import com.tydic.uec.ability.bo.UecAnswerQuestionAbilityRspBO;
import com.tydic.uec.busi.UecAnswerCreateBusiService;
import com.tydic.uec.busi.bo.UecAnswerCreateBusiReqBO;
import com.tydic.uec.busi.bo.UecAnswerCreateBusiRspBO;
import com.tydic.uec.common.bo.answer.AnswerExtBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_PROD/1.0.0/com.tydic.uec.ability.UecAnswerQuestionAbilityService"})
public class UecAnswerQuestionAbilityServiceImpl
implements UecAnswerQuestionAbilityService {
    private final UecAnswerCreateBusiService uecAnswerCreateBusiService;

    public UecAnswerQuestionAbilityServiceImpl(UecAnswerCreateBusiService uecAnswerCreateBusiService) {
        this.uecAnswerCreateBusiService = uecAnswerCreateBusiService;
    }

    @PostMapping(value={"answerQuestion"})
    public UecAnswerQuestionAbilityRspBO answerQuestion(@RequestBody UecAnswerQuestionAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecAnswerCreateBusiReqBO busiReqBO = new UecAnswerCreateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UecAnswerCreateBusiRspBO busiRspBO = this.uecAnswerCreateBusiService.createAnswer(busiReqBO);
        UecAnswerQuestionAbilityRspBO rspBO = new UecAnswerQuestionAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validArgs(UecAnswerQuestionAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u56de\u7b54\u95ee\u9898\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (reqBO.getAnswerInfo() == null) {
            throw new BusinessException("4444", "\u56de\u7b54\u95ee\u9898\u670d\u52a1\u56de\u7b54\u57fa\u672c\u4fe1\u606f[answerInfo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAnswerInfo().getAnswerContent())) {
            throw new BusinessException("4444", "\u56de\u7b54\u95ee\u9898\u670d\u52a1\u56de\u7b54\u6b63\u6587[answerInfo.answerContent]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAnswerInfo().getQuestionId() == null) {
            throw new BusinessException("4444", "\u56de\u7b54\u95ee\u9898\u670d\u52a1\u56de\u7b54\u95ee\u9898ID[answerInfo.questionId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAnswerInfo().getIsAnonymous() == null) {
            reqBO.getAnswerInfo().setIsAnonymous(UecCommonConstant.AnonymousEnum.NO.value);
        }
        reqBO.getAnswerInfo().setState(UecCommonConstant.StateEnum.YES.value);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExtList())) {
            for (AnswerExtBO extBO : reqBO.getExtList()) {
                if (!StringUtils.isBlank((CharSequence)extBO.getFieldCode())) continue;
                throw new BusinessException("4444", "\u56de\u7b54\u95ee\u9898\u670d\u52a1\u6269\u5c55\u5c5e\u6027\u7f16\u7801[extList.fieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

