/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecEvaluateDataStatsAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateDataStatsAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateDataStatsAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateDataStatsBusiService;
import com.tydic.uec.busi.bo.UecEvaluateDataStatsBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateDataStatsBusiRspBO;
import com.tydic.uec.common.bo.eva.EvaDataStatsBO;
import com.tydic.uec.constant.UecCommonConstant;
import com.tydic.uec.exception.BusinessException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_PROD/1.0.0/com.tydic.uec.ability.UecEvaluateDataStatsAbilityService"})
public class UecEvaluateDataStatsAbilityServiceImpl
implements UecEvaluateDataStatsAbilityService {
    private final UecEvaluateDataStatsBusiService uecEvaluateDataStatsBusiService;

    public UecEvaluateDataStatsAbilityServiceImpl(UecEvaluateDataStatsBusiService uecEvaluateDataStatsBusiService) {
        this.uecEvaluateDataStatsBusiService = uecEvaluateDataStatsBusiService;
    }

    @PostMapping(value={"dataStatistics"})
    public UecEvaluateDataStatsAbilityRspBO dataStatistics(@RequestBody UecEvaluateDataStatsAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        UecEvaluateDataStatsBusiReqBO busiReqBO = new UecEvaluateDataStatsBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)busiReqBO);
        UecEvaluateDataStatsBusiRspBO busiRspBO = this.uecEvaluateDataStatsBusiService.dealDataStatistics(busiReqBO);
        UecEvaluateDataStatsAbilityRspBO rspBO = new UecEvaluateDataStatsAbilityRspBO();
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)rspBO);
        return rspBO;
    }

    private void validArgs(UecEvaluateDataStatsAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSysCode())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u4e1a\u52a1\u7cfb\u7edf[sysCode]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getDataList())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u6570\u636e[dataList]\u4e3a\u7a7a");
        }
        if (reqBO.getStatsType() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a[statsType]\u4e3a\u7a7a");
        }
        if (UecCommonConstant.StatsType.LABEL.equals(reqBO.getStatsType())) {
            if (reqBO.getDataList().size() != 1) {
                throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u53ea\u80fd\u7edf\u8ba1\u552f\u4e00\u5bf9\u8c61\u6807\u7b7e\u4fe1\u606f\uff0c\u4f20\u5165\u5bf9\u8c61dataList.size=" + reqBO.getDataList().size());
            }
            if (((EvaDataStatsBO)reqBO.getDataList().get(0)).getObjType() == null) {
                throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u5bf9\u8c61\u7c7b\u578b[objType]\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)((EvaDataStatsBO)reqBO.getDataList().get(0)).getObjId())) {
                throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u5bf9\u8c61ID[objId]\u4e3a\u7a7a");
            }
        } else {
            reqBO.getDataList().forEach(data -> {
                if (data.getObjType() == null) {
                    throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u5bf9\u8c61\u7c7b\u578b[objType]\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)data.getObjId())) {
                    throw new BusinessException("4444", "\u8bc4\u4ef7\u7edf\u8ba1\u5bf9\u8c61ID[objId]\u4e3a\u7a7a");
                }
            });
        }
    }
}

