/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.impl;

import com.tydic.uec.ability.UecEvaluateStateUpdateAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateStateUpdateAbilityReqBO;
import com.tydic.uec.ability.bo.UecEvaluateStateUpdateAbilityRspBO;
import com.tydic.uec.busi.UecEvaluateUpdateBusiService;
import com.tydic.uec.busi.bo.UecEvaluateUpdateBusiReqBO;
import com.tydic.uec.busi.bo.UecEvaluateUpdateBusiRspBO;
import com.tydic.uec.exception.BusinessException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UEC_GROUP_PROD/1.0.0/com.tydic.uec.ability.UecEvaluateStateUpdateAbilityService"})
public class UecEvaluateStateUpdateAbilityServiceImpl
implements UecEvaluateStateUpdateAbilityService {
    private final UecEvaluateUpdateBusiService uecEvaluateUpdateBusiService;

    public UecEvaluateStateUpdateAbilityServiceImpl(UecEvaluateUpdateBusiService uecEvaluateUpdateBusiService) {
        this.uecEvaluateUpdateBusiService = uecEvaluateUpdateBusiService;
    }

    @PostMapping(value={"updateEvaluateState"})
    public UecEvaluateStateUpdateAbilityRspBO updateEvaluateState(@RequestBody UecEvaluateStateUpdateAbilityReqBO reqBO) {
        this.validArgs(reqBO);
        String respCode = "0000";
        StringBuilder respDesc = new StringBuilder();
        for (Long evaId : reqBO.getEvaIds()) {
            UecEvaluateUpdateBusiReqBO busiReqBO = new UecEvaluateUpdateBusiReqBO();
            busiReqBO.setEvaId(evaId);
            busiReqBO.setEvaState(reqBO.getEvaState());
            UecEvaluateUpdateBusiRspBO busiRspBO = this.uecEvaluateUpdateBusiService.updateEvaluateInfo(busiReqBO);
            respDesc.append(evaId);
            if ("0000".equals(busiRspBO.getRespCode())) {
                respDesc.append("\u8bc4\u4ef7\u72b6\u6001\u4fee\u6539\u6210\u529f");
            } else {
                respCode = "4012";
                respDesc.append("\u8bc4\u4ef7\u72b6\u6001\u4fee\u6539\u5931\u8d25");
            }
            respDesc.append("\uff1b");
        }
        UecEvaluateStateUpdateAbilityRspBO rspBO = new UecEvaluateStateUpdateAbilityRspBO();
        rspBO.setRespCode(respCode);
        rspBO.setRespDesc(respDesc.toString());
        return rspBO;
    }

    private void validArgs(UecEvaluateStateUpdateAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u72b6\u6001\u4fee\u6539\u670d\u52a1\u53c2\u6570\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getEvaIds())) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u72b6\u6001\u4fee\u6539\u670d\u52a1\u8bc4\u4ef7ID[evaIds]\u4e3a\u7a7a");
        }
        if (reqBO.getEvaState() == null) {
            throw new BusinessException("4444", "\u8bc4\u4ef7\u72b6\u6001\u4fee\u6539\u670d\u52a1\u4fee\u6539\u72b6\u6001[evaState]\u4e3a\u7a7a");
        }
    }
}

