package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-售后申请入参〉
 * @author : yuhao
 * @date : 2022/9/10 12:19
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocAfterOrderCreateReqBo extends BaseReqBo {
    private static final long serialVersionUID = -7070282953681938211L;

    /**
     * 发货单ID
     */
    private Long shipOrderId;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 销售单ID
     */
    private Long saleOrderId;

    /**
     * 订单来源
     */
    private Integer orderSource;

    /**
     * 外部售后单Id
     */
    private String serviceId;

    /**
     * 服务类型 退货(10)、换货(20)、维修(30)
     */
    private Integer servType;

    /**
     * 售后原因
     */
    private Integer afsReason;

    /**
     * 取货服务类型  1： 上门取件 2：客户发货 3： 客户送货
     */
    private Integer pickwareType;

    /**
     * 取件地址 pickwareType=1必填
     */
    private UocAfterOrderCreateReqAddressBo takeAddress;

    /**
     * 返件地址 servType=20/30必填
     */
    private UocAfterOrderCreateReqAddressBo returnAddress;

    /**
     * 问题描述
     */
    private String questionDesc;

    /**
     * 售后明细
     */
    private List<UocAfterOrderCreateReqItemBo> shipItemList;

    /**
     * 纵向扩展数据
     */
    private List<UocBaseExtParallelBo> extParallelBoList;

    /**
     * 附件
     */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
     * 取货开始时间
     */
    private Date pickupStartTime;

    /**
     * 取货结束时间
     */
    private Date pickupEndTime;

    /**
     * 客户姓名
     */
    private String clientName;

    /**
     * 手机号
     */
    private String clientPhone;
    /**
     * 当前登录用户id
     */
    private Long userId;
    /**
     * 当前登录用户名称
     */
    private String name;
    /**
     * 机构id
     */
    private Long orgId;
    /**
     * 机构名称
     */
    private String orgName;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 公司名称
     */
    private String companyName;
    /**
     * 联系人电话
     */
    private String cellphone;

}
