package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * 描述: 〈领域服务-到货验收出参〉
 * @author : yuhao
 * @date : 2022/8/26 16:39
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocArrvalAcceptanceRspBo extends BaseRspBo {
    private static final long serialVersionUID = 892482247106732066L;

    /**
     * 销售单是否验收完成
     */
    private Boolean finish;

    /**
     * 销售单是否验收完成 1是 0否
     */
    private String opFlag;

    /**
     * 验收单ID
     */
    private Long inspOrderId;
    /**
     * 发货单是否验收完成集合
     */
    private Map<Long, Boolean> shipOrderInspStateMap;
    /**
     * 预算id
     */
    private Long budgetId;
    /**
     * 协议id(用于翻译)
     **/
    private String agreementId;
    /**
     * 采购方公司id
     */
    private String purCompanyId;
    /**
     * 供应商id
     */
    private String supplierId;
    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 销售单明细
     */
    List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos;
}
