package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocFinishTaskInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单任务提交（单条）出参〉
 * @author : yuhao
 * @date : 2022/7/26 18:43
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCreateOrderProcInsUpdateStatusDomainServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 3972301161717238897L;

    /**
     * 已办任务信息
     */
    private List<UocFinishTaskInfoBo> finishTaskInfoBos;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 同步销售单集合
     */
    private List<UocEsSyncBO> syncSaleOrderList;
    /**
     * 同步变更单集合
     */
    private List<UocEsSyncBO> syncChngOrderList;
    /**
     * 同步发货单集合
     */
    private List<UocEsSyncBO> syncShipOrderList;
    /**
     * 同步验收单集合
     */
    private List<UocEsSyncBO> syncInspOrderList;
    /**
     * 同步售后单集合
     */
    private List<UocEsSyncBO> syncAfterOrderList;
    /**
     * 预算id
     */
    private Long budgetId;
    /**
     * 协议id(用于翻译)
     **/
    private String agreementId;
    /**
     * 采购方公司id
     */
    private String purCompanyId;
    /**
     * 供应商id
     */
    private String supplierId;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 销售单明细
     */
    List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos;
}


