package com.tydic.dyc.oc.service.common.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class UocUnifyTodoQryBO implements Serializable {
    private static final long serialVersionUID = 3228875563031372159L;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 发货单编码
     */
    private String shipOrderNo;
    /**
     * 售后单编码
     */
    private String afServCode;
    /**
     * 审批单编码
     */
    private String auditOrderCode;
    /**
     * 变更单编码
     */
    private String chngOrderNo;


    // ------------------------------------------------------------------------


    /**
     * 采购单位名称
     */
    private String purOrgName;
    /**
     * 销售价格
     */
    private BigDecimal totalSaleFee;
    /**
     * 配送专责姓名
     */
    private String proDeliveryName;
    /**
     * 销售单状态
     */
    private String saleOrderState;
    /**
     * 销售单创建人
     */
    private Long saleOrderCreateUserId;
    /**
     * 预计到货日期
     */
    private String estimateArrivalTime;
    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;
    /**
     * 协议模式 1：平台协议 2：单位协议
     */
    private Integer agreementCode;
    /**
     * 订单来源 1 自营单品 2 电商导入 3 协议生成
     */
    private Integer orderSource;
    /**
     * 付款方式 0:预付款 2:账期支付
     */
    private String payType;
    /**
     * 审批对象业务类型：1调价 2.订单审批
     */
    private Integer objBusiType;
    /**
     * 变更类型1:数量变更 2订单采购调价3订单取消 4状态变更 5.订单销售调价
     */
    private Integer chngBusiType;
}
