package com.tydic.dyc.oc.service.domainservice.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述: 〈支付配置信息〉
 * @author : yuhao
 * @date : 2022/7/21 15:25
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderPayConfQryServiceRspConfBo implements Serializable {

    private static final long serialVersionUID = 1531551272230777173L;

    //付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付")
    private Integer payType;

    //预付款(比例)")
    private BigDecimal prePaySup;

    //到货款(比例)")
    private BigDecimal verPaySup;

    //验收款(比例)")
    private BigDecimal pilPaySup;

    //质保金(比例)")
    private BigDecimal quaPaySup;

    //预付款")
    private BigDecimal prePayFee;

    //到货款")
    private BigDecimal verPayFee;

    //验收款")
    private BigDecimal pilPayFee;

    //质保金")
    private BigDecimal quaPayFee;

    //预付款-已付")
    private BigDecimal prePayedFee;

    //到货款-已付")
    private BigDecimal verPayedFee;

    //验收款-已付")
    private BigDecimal pilPayedFee;

    //质保金-已付")
    private BigDecimal quaPayedFee;

    //账期天数")
    private Integer paymentDays;

    //指定账期日")
    private Integer payAccountDay;

    //使用类型：1：采购方；2：平台方")
    private Integer userType;

    //账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数")
    private Integer payRule;

    //账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货")
    private Integer payAccountDayRule;

    //账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算")
    private Integer payNodeRule;

    //违约金额比例")
    private BigDecimal payBreakScale;

    //合同ID")
    private String modelContractId;

}


