package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:UocAfterOrderFinishConfirmRspBo
 * 说明:售后完成确认
 * 时间:2022-05-13 13:54:43
 * 作者:luoyou
 */

@EqualsAndHashCode(callSuper = true)
@Data
public class UocAfterOrderFinishConfirmRspBo extends BaseRspBo {
	private static final long serialVersionUID = 974671034944856064L;
	/**
	 * 发货单id
	 */
	private Long shipOrderId;
	/**
	 * 销售单id
	 */
	private Long saleOrderId;
	/**
	 * 发货单ids
	 */
	private List<Long> shipOrderIdList;
	/**
	 * 预算id
	 */
	private Long budgetId;
	/**
	 * 协议id(用于翻译)
	 **/
	private String agreementId;
	/**
	 * 采购方公司id
	 */
	private String purCompanyId;
	/**
	 * 供应商id
	 */
	private String supplierId;
	/**
	 * 销售单编码
	 */
	private String saleOrderNo;
	/**
	 * 销售单明细
	 */
	List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos;


	/**
	 * 验收单id列表
	 */
	private List<Long> inspOrderIdList;
}