package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocGetSaleOrderDetailServiceRspReceiverAddressBo
 * 说明:收货人地址信息
 * 时间:2022/3/10 12:10
 * 作者:田桂银
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShipItemReceiverAddressBo implements Serializable {

    private static final long serialVersionUID = 8195831685858890842L;
    /**
     * 主键id
     */
    private Long saleItemShipAdressId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 销售明细id（销售明细表主键）
     */
    private Long saleOrderItemId;
    /**
     * 发货数量
     */
    private BigDecimal shipCount;
    /**
     * 收获地址id（收获地址表主键）
     */
    private Long contactId;
    /**
     * 收获人地址信息
     */
    private UocGetSaleOrderDetailServiceRspReceiverAddressBo receiverAddressBo;
    /**
     * 销售单明细信息
     */
    private List<UocGetSaleOrderDetailServiceRspItemBo> saleOrderDetailServiceRspItemBoList;

}


