/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEsPreOrderSubmitFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEsPreOrderSubmitFunctionReqBo;
import com.tydic.dyc.atom.estore.bo.DycUocEsPreOrderSubmitFunctionRspBo;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEsPreOrderSubmitFunctionImpl
implements DycUocEsPreOrderSubmitFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEsPreOrderSubmitFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocEsPreOrderSubmitFunctionRspBo submitEsPreOrder(DycUocEsPreOrderSubmitFunctionReqBo submitOrderReqBO) {
        String callUrl = null;
        callUrl = DycPropertiesUtil.getProperty((String)"ESB_SUBMIT_ORDER_URL");
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + submitOrderReqBO.getSupplierId()));
        log.info("\u7535\u5546\u9884\u5b9a\u5355\u4e0b\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)submitOrderReqBO));
        log.info("\u7535\u5546\u9884\u5b9a\u5355\u4e0b\u5355\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u7535\u5546\u9884\u5b9a\u5355\u4e0b\u5355\u8bf7\u6c42hsn:{}", (Object)hsn);
        Date callTime = new Date();
        String result = DycEsbUtil.doPostReuest((String)callUrl, (String)JSON.toJSONString((Object)submitOrderReqBO), (String)hsn);
        Date retTime = new Date();
        this.intsertInterLog(submitOrderReqBO.getOrderId(), submitOrderReqBO.getObjId(), callTime, retTime, hsn, callUrl, JSON.toJSONString((Object)submitOrderReqBO), result);
        result = this.resolveRspTemp(result);
        log.info("\u7535\u5546\u9884\u5b9a\u5355\u4e0b\u5355\u51fa\u53c2: " + result);
        return this.resolveRsp(result);
    }

    private DycUocEsPreOrderSubmitFunctionRspBo resolveRsp(String returnString) {
        DycUocEsPreOrderSubmitFunctionRspBo submitOrderRsp = new DycUocEsPreOrderSubmitFunctionRspBo();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success") == null) {
            submitOrderRsp.setRespCode("8888");
            submitOrderRsp.setRespDesc("\u7535\u5546\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u4e0d\u5bf9\uff1a" + returnString);
            return submitOrderRsp;
        }
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            submitOrderRsp = (DycUocEsPreOrderSubmitFunctionRspBo)((Object)JSON.parseObject((String)jsonObject.toJSONString(), DycUocEsPreOrderSubmitFunctionRspBo.class));
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode(rspJsonObject.getString("resultCode"));
        submitOrderRsp.setRespDesc(rspJsonObject.getString("resultMessage"));
        return submitOrderRsp;
    }

    private String resolveRspTemp(String result) {
        return result.replace("\"tax\":13.00", "\"tax\":13");
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(1));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

