/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.cfc.ability.api.CfcParamConfigAbilityService;
import com.tydic.cfc.ability.bo.CfcParamConfigBO;
import com.tydic.cfc.ability.bo.CfcParamConfigItemBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigDetailAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcQryParamConfigListAbilityRspBO;
import com.tydic.commodity.common.ability.api.UccCheckMaterialAbilityService;
import com.tydic.commodity.common.ability.api.UccQryCommodityTypeListAbilityService;
import com.tydic.commodity.common.ability.bo.UccQryCommodityTypeListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccQryCommodityTypeListAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccQryCommodityTypeListAbilityRspBo;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.dyc.agr.bo.AgrItemBo;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrCodeService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrAccessoryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrMainSaveBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrImportFunction;
import com.tydic.dyc.atom.zone.agr.bo.AgrImportRedis;
import com.tydic.dyc.atom.zone.agr.bo.AgrImportRedisRspBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrImportFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrImportFuncRspBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrMainImportFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAppScopeFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrItemFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycCommonImportFailReasonFuncBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoListPageService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoListPageReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoListPageRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoDetailRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListRspBo;
import com.tydic.dyc.umc.service.supplieraccess.api.UmcSupplierInfoQryDetailService;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcEnterpriseInfoAccessBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoQryDetailReqBO;
import com.tydic.dyc.umc.service.supplieraccess.bo.UmcSupplierInfoQryDetailRspBO;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycAgrAgrImportFunctionImpl
implements DycAgrAgrImportFunction {
    private static final Logger log = LoggerFactory.getLogger(DycAgrAgrImportFunctionImpl.class);
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    AgrCreateAgrItemService agrCreateAgrItemService;
    @Autowired
    AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    AgrCreateAgrService agrCreateAgrService;
    @Autowired
    private AgrGetAgrCodeService agrGetAgrCodeService;
    @Autowired
    private UmcSupplierInfoQryDetailService umcSupplierInfoQryDetailService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private CfcParamConfigAbilityService cfcParamConfigAbilityService;
    @Autowired
    private UccCheckMaterialAbilityService uccCheckMaterialAbilityService;
    @Autowired
    private UmcQryOrgInfoDetailService umcQryOrgInfoDetailService;
    @Autowired
    private UmcQryOrgInfoListService umcQryOrgInfoListService;
    @Autowired
    private AgrImportRedis agrImportRedis;
    @Autowired
    private UccQryCommodityTypeListAbilityService uccQryCommodityTypeListAbilityService;
    @Autowired
    private UmcQryEnterpriseInfoListPageService umcQryEnterpriseInfoListPageService;

    @Override
    public DycAgrAgrImportFuncRspBO dealAgrImport(DycAgrAgrImportFuncReqBO reqBO) {
        Integer salePriceGreateRule = this.dealSalePriceGreateRule();
        ArrayList<DycCommonImportFailReasonFuncBO> failReasonBOs = new ArrayList<DycCommonImportFailReasonFuncBO>();
        if (ObjectUtil.isNotEmpty(reqBO.getAgrMain())) {
            this.importAgr(salePriceGreateRule, failReasonBOs, reqBO);
        }
        if (ObjectUtil.isNotEmpty(reqBO.getAgrItem())) {
            this.importAgrItem(salePriceGreateRule, failReasonBOs, reqBO);
        }
        DycAgrAgrImportFuncRspBO rspBO = new DycAgrAgrImportFuncRspBO();
        rspBO.setFailReasonList(failReasonBOs);
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void importAgrItem(Integer salePriceGreateRule, List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrImportFuncReqBO reqBO) {
        HashMap<Integer, String> lineErrorMsgMap = new HashMap<Integer, String>();
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        AgrGetAgrMainRspBo agrMain = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrMain.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrMain.getRespCode() + "\u3011," + agrMain.getRespDesc());
        }
        if (agrMain == null) {
            throw new ZTBusinessException("\u534f\u8bae\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        this.agrItemTranslate(salePriceGreateRule, agrMain.getTradeMode(), reqBO.getAgrItem(), lineErrorMsgMap);
        this.uccCheck(reqBO.getAgrItem(), lineErrorMsgMap, agrMain.getSupplierId());
        this.validPuplicate(reqBO.getAgrItem(), lineErrorMsgMap, reqBO.getAgrId());
        if (lineErrorMsgMap.size() > 0) {
            lineErrorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setFailReason("\u534f\u8bae\u660e\u7ec6\u884c\u3010" + k + "\u3011" + v.substring(1));
                bo.setLineNum((Integer)k);
                failReasonBOs.add(bo);
            });
        }
        if (failReasonBOs.size() == 0) {
            this.saveAgrItem(reqBO);
        }
    }

    private void agrTransLate(StringBuilder lineError, DycAgrAgrMainImportFuncBO agrMain, DycAgrAgrImportFuncReqBO reqBO) {
        if (agrMain.getAgrNo() == null) {
            lineError.append(",\u534f\u8bae\u5e8f\u53f7\u4e3a\u7a7a");
        }
        agrMain.setAgrSrc(1);
        if (StringUtils.isEmpty((Object)agrMain.getAgrName())) {
            lineError.append(",\u534f\u8bae\u540d\u79f0\u4e3a\u7a7a");
        }
        agrMain.setAgrMode(AgrCommConstant.AgreementModeEnum.AGREEMENT_MODE_UNIT.getValue());
        agrMain.setTradeMode(AgrCommConstant.TradeModeEnum.TRADE_MODE_CU.getValue());
        if (StringUtils.isEmpty((Object)agrMain.getAgrTypeStr())) {
            lineError.append(",\u534f\u8bae\u7c7b\u578b\u4e3a\u7a7a");
        } else {
            agrMain.setAgrType(AgrCommConstant.AgrTypeEnum.getCodeByName((String)agrMain.getAgrTypeStr()));
            if (agrMain.getAgrType() == null) {
                lineError.append(",\u534f\u8bae\u7c7b\u578b\u8f93\u5165\u9519\u8bef");
            }
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgentFlagStr())) {
            lineError.append(",\u662f\u5426\u4ee3\u7406\u5546\u4e3a\u7a7a");
        } else if (agrMain.getAgentFlagStr().equals("\u662f")) {
            agrMain.setAgentFlag(1);
            if (ObjectUtil.isEmpty((Object)agrMain.getOriginalManufacturer())) {
                lineError.append(",\u539f\u5382\u5546\u540d\u79f0\u4e3a\u7a7a");
            }
        } else {
            agrMain.setAgentFlag(0);
        }
        if (StringUtils.isEmpty((Object)agrMain.getEscrowVendorFlagStr())) {
            lineError.append(",\u662f\u5426\u4ee3\u7ba1\u4f9b\u5e94\u5546\u4e3a\u7a7a");
        } else if (agrMain.getEscrowVendorFlagStr().equals("\u662f")) {
            agrMain.setEscrowVendorFlag(1);
        } else {
            agrMain.setEscrowVendorFlag(0);
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgrMainExtend4())) {
            lineError.append(",\u5408\u540c/\u534f\u8bae\u7b7e\u7f72\u65b9\uff08\u7532\u65b9\uff09\u4e3a\u7a7a");
        } else {
            UmcQryOrgInfoListReqBo umcQryOrgInfoListReqBo = new UmcQryOrgInfoListReqBo();
            umcQryOrgInfoListReqBo.setTagId(Integer.valueOf(1));
            umcQryOrgInfoListReqBo.setPageNo(Integer.valueOf(1));
            umcQryOrgInfoListReqBo.setPageSize(Integer.valueOf(1000));
            umcQryOrgInfoListReqBo.setIsVirtual("1");
            umcQryOrgInfoListReqBo.setYcQryType("1");
            umcQryOrgInfoListReqBo.setOrgName(agrMain.getAgrMainExtend4());
            UmcQryOrgInfoListRspBo umcQryOrgInfoListRspBo = this.umcQryOrgInfoListService.qryOrgList(umcQryOrgInfoListReqBo);
            if (!"0000".equals(umcQryOrgInfoListRspBo.getRespCode())) {
                lineError.append(",\u5408\u540c/\u534f\u8bae\u7b7e\u7f72\u65b9\uff08\u7532\u65b9\uff09\u67e5\u8be2\u5f02\u5e38");
            } else if (!CollectionUtils.isEmpty((Collection)umcQryOrgInfoListRspBo.getRows())) {
                for (UmcEnterpriseInfoBo row : umcQryOrgInfoListRspBo.getRows()) {
                    if (!agrMain.getAgrMainExtend4().equals(row.getOrgName())) continue;
                    agrMain.setAgrMainExtend3(row.getOrgId() + "");
                }
                if (StringUtils.isEmpty((Object)agrMain.getAgrMainExtend3())) {
                    lineError.append(",\u5408\u540c/\u534f\u8bae\u7b7e\u7f72\u65b9\uff08\u7532\u65b9\uff09\u4e0d\u5b58\u5728");
                }
            } else {
                lineError.append(",\u5408\u540c/\u534f\u8bae\u7b7e\u7f72\u65b9\uff08\u7532\u65b9\uff09\u4e0d\u5b58\u5728");
            }
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgrMainExtend5Str())) {
            lineError.append(",\u662f\u5426\u5171\u4eab\u9650\u989d\u7c7b\u4e3a\u7a7a");
        } else if (agrMain.getAgrMainExtend5Str().equals("\u662f")) {
            agrMain.setAgrMainExtend5("1");
        } else {
            agrMain.setAgrMainExtend5("0");
            agrMain.setAgrMainExtend6(null);
            agrMain.setAgrMainExtend7(null);
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgrMainExtend8())) {
            lineError.append(",\u5408\u540c\u4e0a\u9650\u91d1\u989d\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgrMainExtend9Str())) {
            lineError.append(",\u662f\u5426\u81ea\u52a8\u7eed\u7ea6\u7c7b\u4e3a\u7a7a");
        } else if (agrMain.getAgrMainExtend9Str().equals("\u662f")) {
            agrMain.setAgrMainExtend9("1");
        } else {
            agrMain.setAgrMainExtend9("0");
        }
        if (StringUtils.isEmpty((Object)agrMain.getMatterName())) {
            lineError.append(",\u6807\u7684\u7269\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgreementVarietyStr())) {
            lineError.append(",\u91c7\u8d2d\u7c7b\u522b\u4e3a\u7a7a");
        } else {
            agrMain.setAgreementVariety(AgrCommConstant.AgreementVarietyEnum.getCodeByName((String)agrMain.getAgreementVarietyStr()));
            if (agrMain.getAgreementVariety() == null) {
                lineError.append(",\u91c7\u8d2d\u7c7b\u522b\u8f93\u5165\u9519\u8bef");
            }
        }
        if (StringUtils.isEmpty((Object)agrMain.getSupplierName())) {
            lineError.append(",\u4f9b\u5e94\u5546\u4e3a\u7a7a");
        } else {
            UmcSupplierInfoQryDetailReqBO umcSupplierInfoQryDetailReqBO = new UmcSupplierInfoQryDetailReqBO();
            umcSupplierInfoQryDetailReqBO.setQueryType("1");
            umcSupplierInfoQryDetailReqBO.setSupplierName(agrMain.getSupplierName());
            UmcSupplierInfoQryDetailRspBO rspBO = this.umcSupplierInfoQryDetailService.qryInfoDetail(umcSupplierInfoQryDetailReqBO);
            if (!"0000".equals(rspBO.getRespCode())) {
                throw new ZTBusinessException(rspBO.getRespDesc());
            }
            UmcEnterpriseInfoAccessBO umcEnterpriseInfoBO = rspBO.getUmcEnterpriseInfoBO();
            if (null == umcEnterpriseInfoBO) {
                lineError.append(",\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728");
            } else {
                agrMain.setSupplierId(umcEnterpriseInfoBO.getSupplierId());
                agrMain.setSupplierPhone(umcEnterpriseInfoBO.getPhoneNumber());
                agrMain.setSupplierContact(umcEnterpriseInfoBO.getConsignerName());
            }
        }
        agrMain.setWhetherStorePlan(1);
        if (StringUtils.isEmpty((Object)agrMain.getSupplierModeStr())) {
            lineError.append(",\u94fa\u8d27\u5355\u4f4d\u4e3a\u7a7a");
        } else {
            agrMain.setSupplierMode(AgrCommConstant.VendorModeEnum.getCodeByName((String)agrMain.getSupplierModeStr()));
            if (agrMain.getSupplierMode() == null) {
                lineError.append(",\u94fa\u8d27\u5355\u4f4d\u8f93\u5165\u9519\u8bef");
            } else if (agrMain.getSupplierMode().equals(AgrCommConstant.SupplierMode.SUPPLIER_DELIVERY)) {
                if (agrMain.getSupplierId() != null) {
                    agrMain.setManagementOrgId(agrMain.getSupplierId().toString());
                    agrMain.setManagementOrgName(agrMain.getSupplierName());
                }
            } else if (agrMain.getSupplierMode().equals(AgrCommConstant.SupplierMode.CREATE_AND_SUP)) {
                agrMain.setManagementOrgId(agrMain.getSupplierId() + "," + reqBO.getCompanyId());
                agrMain.setManagementOrgName(agrMain.getSupplierName() + "," + reqBO.getCompanyName());
            } else {
                agrMain.setManagementOrgId(reqBO.getCompanyId().toString());
                agrMain.setManagementOrgName(reqBO.getCompanyName());
            }
        }
        agrMain.setWhetherHaveItem(1);
        if (StringUtils.isEmpty((Object)agrMain.getEffDate())) {
            lineError.append(",\u751f\u6548\u65e5\u671f\u4e3a\u7a7a");
        } else {
            try {
                agrMain.setEffDate1(DateUtils.strToDate((String)agrMain.getEffDate(), (String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                lineError.append(",\u751f\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (StringUtils.isEmpty((Object)agrMain.getExpDate())) {
            lineError.append(",\u5931\u6548\u65e5\u671f\u4e3a\u7a7a");
        } else {
            try {
                agrMain.setExpDate1(DateUtils.strToDate((String)agrMain.getExpDate(), (String)"yyyy-MM-dd"));
            }
            catch (Exception e) {
                lineError.append(",\u5931\u6548\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (StringUtils.isEmpty((Object)agrMain.getAgrSignTime())) {
            lineError.append(",\u534f\u8bae\u7b7e\u8ba2\u65f6\u95f4\u4e3a\u7a7a");
        } else {
            try {
                agrMain.setAgrSignTime1(DateUtils.strToDate((String)agrMain.getAgrSignTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                lineError.append(",\u534f\u8bae\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (agrMain.getAgrSignTime1() != null && agrMain.getEffDate1() != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                String dateString = formatter.format(agrMain.getAgrSignTime1());
                Date date = formatter.parse(dateString);
                if (date.getTime() > agrMain.getEffDate1().getTime()) {
                    lineError.append(",\u534f\u8bae\u7b7e\u8ba2\u65f6\u95f4\u9700\u5c0f\u4e8e\u534f\u8bae\u751f\u6548\u65f6\u95f4");
                }
            }
            catch (Exception e) {
                lineError.append("\u7b7e\u8ba2\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        agrMain.setAdjustPrice(AgrCommConstant.AdjustPriceEnum.SCOPE_TYPE_BEFORE_SCOPE.getValue());
        if (StringUtils.isEmpty((Object)agrMain.getScopeTypeStr())) {
            lineError.append(",\u9002\u7528\u7c7b\u578b\u4e3a\u7a7a");
        } else {
            ArrayList<Long> scopeIds;
            ArrayList<DycAgrAppScopeFuncBO> agrAppScopeBOs = new ArrayList<DycAgrAppScopeFuncBO>();
            agrMain.setScopeType(AgrCommConstant.ScopeTypeEnum.getCodeByName((String)agrMain.getScopeTypeStr()));
            if (agrMain.getScopeType() == null) {
                lineError.append(",\u9002\u7528\u7c7b\u578b\u8f93\u5165\u9519\u8bef");
            } else if (agrMain.getScopeType().equals(3)) {
                if (StringUtils.isEmpty((Object)agrMain.getAgrAppScopeName())) {
                    lineError.append(",\u9002\u7528\u8303\u56f4\u4e3a\u7a7a");
                } else {
                    scopeIds = new ArrayList<Long>();
                    String[] appScopeName = agrMain.getAgrAppScopeName().split(",");
                    if (appScopeName != null && appScopeName.length > 0) {
                        for (int i = 0; i < appScopeName.length; ++i) {
                            UmcQryOrgInfoDetailReqBo umcQryOrgInfoDetailReqBo = new UmcQryOrgInfoDetailReqBo();
                            umcQryOrgInfoDetailReqBo.setOrgName(appScopeName[i]);
                            UmcQryOrgInfoDetailRspBo rspBO = this.umcQryOrgInfoDetailService.qryOrgInfoDetail(umcQryOrgInfoDetailReqBo);
                            if (!"0000".equals(rspBO.getRespCode())) {
                                throw new ZTBusinessException(rspBO.getRespDesc());
                            }
                            if (null == rspBO) {
                                lineError.append(",\u9002\u7528\u8303\u56f4\u4e0d\u5b58\u5728");
                                break;
                            }
                            if (rspBO.getOrgId() == null) {
                                lineError.append(",\u9002\u7528\u8303\u56f4\u4e0d\u5b58\u5728");
                                break;
                            }
                            DycAgrAppScopeFuncBO bo = new DycAgrAppScopeFuncBO();
                            bo.setScopeCode(rspBO.getOrgId());
                            bo.setScopeName(appScopeName[i]);
                            agrAppScopeBOs.add(bo);
                            scopeIds.add(rspBO.getOrgId());
                        }
                    }
                    if (!scopeIds.contains(reqBO.getOrgId())) {
                        DycAgrAppScopeFuncBO dycAgrAppScopeBO = new DycAgrAppScopeFuncBO();
                        dycAgrAppScopeBO.setScopeCode(reqBO.getOrgId());
                        dycAgrAppScopeBO.setScopeName(reqBO.getOrgName());
                        agrAppScopeBOs.add(dycAgrAppScopeBO);
                    }
                }
            } else if (AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_FIRST_UNIT.getValue().equals(agrMain.getScopeType())) {
                if (reqBO.getTopOrgId() == null || reqBO.getCompanyId() == null || reqBO.getTopExtOrgClass() == null) {
                    lineError.append(",\u7f3a\u5c11\u7528\u6237\u5355\u4f4d\u4fe1\u606f");
                } else if (!reqBO.getTopOrgId().equals(reqBO.getCompanyId()) || 0 != reqBO.getTopExtOrgClass()) {
                    lineError.append(",\u672c\u5355\u4f4d\u5e94\u7528\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u9009\u62e9\u5168\u4e00\u7ea7\u5206\u884c");
                } else {
                    scopeIds = new ArrayList();
                    UmcQryOrgInfoListReqBo umcQryOrgInfoListReqBo = new UmcQryOrgInfoListReqBo();
                    umcQryOrgInfoListReqBo.setTagId(Integer.valueOf(1));
                    umcQryOrgInfoListReqBo.setIsVirtual("1");
                    umcQryOrgInfoListReqBo.setYcQryType("2");
                    UmcQryOrgInfoListRspBo umcQryOrgInfoListRspBo = this.umcQryOrgInfoListService.qryOrgList(umcQryOrgInfoListReqBo);
                    if (!"0000".equals(umcQryOrgInfoListRspBo.getRespCode())) {
                        lineError.append(",\u5168\u4e00\u7ea7\u5206\u884c\u67e5\u8be2\u5f02\u5e38");
                    } else if (!CollectionUtils.isEmpty((Collection)umcQryOrgInfoListRspBo.getRows())) {
                        for (UmcEnterpriseInfoBo row : umcQryOrgInfoListRspBo.getRows()) {
                            if (scopeIds.contains(row.getOrgId())) continue;
                            DycAgrAppScopeFuncBO bo = new DycAgrAppScopeFuncBO();
                            bo.setScopeCode(row.getOrgId());
                            bo.setScopeName(row.getOrgName());
                            agrAppScopeBOs.add(bo);
                            scopeIds.add(row.getOrgId());
                        }
                    }
                    if (!scopeIds.contains(reqBO.getOrgId())) {
                        DycAgrAppScopeFuncBO dycAgrAppScopeBO = new DycAgrAppScopeFuncBO();
                        dycAgrAppScopeBO.setScopeCode(reqBO.getOrgId());
                        dycAgrAppScopeBO.setScopeName(reqBO.getOrgName());
                        agrAppScopeBOs.add(dycAgrAppScopeBO);
                    }
                }
            } else if (AgrCommConstant.ScopeTypeEnum.SCOPE_TYPE_SECOND_UNIT.getValue().equals(agrMain.getScopeType())) {
                if (reqBO.getTopOrgId() == null || reqBO.getCompanyId() == null || reqBO.getTopExtOrgClass() == null) {
                    lineError.append(",\u7f3a\u5c11\u7528\u6237\u5355\u4f4d\u4fe1\u606f");
                } else if (!reqBO.getTopOrgId().equals(reqBO.getCompanyId()) || 1 != reqBO.getTopExtOrgClass()) {
                    lineError.append(",\u672c\u5355\u4f4d\u5e94\u7528\u8303\u56f4\u7c7b\u578b\u4e0d\u80fd\u9009\u62e9\u5168\u4e8c\u7ea7\u5206\u884c");
                } else {
                    scopeIds = new ArrayList();
                    UmcQryEnterpriseInfoListPageReqBo qryEnterpriseInfoListPageReqBo = new UmcQryEnterpriseInfoListPageReqBo();
                    qryEnterpriseInfoListPageReqBo.setQueryType("01");
                    qryEnterpriseInfoListPageReqBo.setOrgId(reqBO.getCompanyId());
                    qryEnterpriseInfoListPageReqBo.setCompanyTypeList((List)Lists.newArrayList((Object[])new String[]{"2"}));
                    UmcQryEnterpriseInfoListPageRspBo qryEnterpriseInfoListPageRspBo = this.umcQryEnterpriseInfoListPageService.qryEnterpriseInfoListPage(qryEnterpriseInfoListPageReqBo);
                    if (!"0000".equals(qryEnterpriseInfoListPageRspBo.getRespCode())) {
                        lineError.append(",\u5168\u4e8c\u7ea7\u5206\u884c\u67e5\u8be2\u5f02\u5e38");
                    } else if (!CollectionUtils.isEmpty((Collection)qryEnterpriseInfoListPageRspBo.getRows())) {
                        for (UmcEnterpriseInfoBo row : qryEnterpriseInfoListPageRspBo.getRows()) {
                            if (scopeIds.contains(row.getOrgId())) continue;
                            DycAgrAppScopeFuncBO bo = new DycAgrAppScopeFuncBO();
                            bo.setScopeCode(row.getOrgId());
                            bo.setScopeName(row.getOrgName());
                            agrAppScopeBOs.add(bo);
                            scopeIds.add(row.getOrgId());
                        }
                    }
                    if (!scopeIds.contains(reqBO.getOrgId())) {
                        DycAgrAppScopeFuncBO dycAgrAppScopeBO = new DycAgrAppScopeFuncBO();
                        dycAgrAppScopeBO.setScopeCode(reqBO.getOrgId());
                        dycAgrAppScopeBO.setScopeName(reqBO.getOrgName());
                        agrAppScopeBOs.add(dycAgrAppScopeBO);
                    }
                }
            } else {
                DycAgrAppScopeFuncBO bo = new DycAgrAppScopeFuncBO();
                bo.setScopeCode(Long.parseLong(agrMain.getScopeType().toString()));
                bo.setScopeName(agrMain.getScopeTypeStr());
                agrAppScopeBOs.add(bo);
            }
            agrMain.setAgrAppScopeBOs(agrAppScopeBOs);
        }
    }

    private void agrItemTranslate(Integer salePriceGreateRule, Integer tradeMode, List<DycAgrItemFuncBO> agrItem, Map<Integer, String> lineErrorMsgMap) {
        if (!CollectionUtils.isEmpty(agrItem)) {
            agrItem.forEach(dycAgrItemFuncBO -> {
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getCommodityTypeName())) {
                    lineError.append(",\u5546\u54c1\u7c7b\u578b\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMaterialName())) {
                    lineError.append(",\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getBrandName())) {
                    lineError.append(",\u54c1\u724c\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMeasureName())) {
                    lineError.append(",\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                }
                if (dycAgrItemFuncBO.getSupplyCycle() == null) {
                    lineError.append(",\u4f9b\u8d27\u5468\u671f\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getTaxRateStr())) {
                    lineError.append(",\u7a0e\u7387\u4e3a\u7a7a");
                } else {
                    Integer taxRate = AgrCommConstant.TaxRateEnum.getCodeByName((String)dycAgrItemFuncBO.getTaxRateStr());
                    if (taxRate == null) {
                        lineError.append(",\u7a0e\u7387\u8f93\u5165\u9519\u8bef");
                    } else {
                        dycAgrItemFuncBO.setTaxRate(new BigDecimal(taxRate));
                    }
                }
                if (tradeMode != null) {
                    if (!tradeMode.equals(AgrCommConstant.TradeModeEnum.TRADE_MODE_BUYING_AND_SELLING.getValue())) {
                        if (dycAgrItemFuncBO.getSalePrice() == null) {
                            lineError.append(",\u9500\u552e\u5355\u4ef7\u4e3a\u7a7a");
                        }
                        if (dycAgrItemFuncBO.getBuyPrice() == null) {
                            dycAgrItemFuncBO.setBuyPrice(dycAgrItemFuncBO.getSalePrice());
                        }
                    } else {
                        if (dycAgrItemFuncBO.getBuyPrice() == null) {
                            lineError.append(",\u91c7\u8d2d\u5355\u4ef7\u4e3a\u7a7a");
                        }
                        if (DycFuncCommonConstants.SalePriceGreateRule.BASE_MARKET_UP.equals(salePriceGreateRule)) {
                            if (StringUtils.isEmpty((Object)dycAgrItemFuncBO.getMarkupRateStr())) {
                                lineError.append(",\u52a0\u4ef7\u6bd4\u7387\u4e3a\u7a7a");
                            } else {
                                Integer markupRate = AgrCommConstant.MarkUpEnum.getCodeByName((String)dycAgrItemFuncBO.getMarkupRateStr());
                                if (markupRate == null) {
                                    lineError.append(",\u52a0\u4ef7\u6bd4\u7387\u8f93\u5165\u9519\u8bef");
                                } else {
                                    dycAgrItemFuncBO.setMarkupRate(new BigDecimal(markupRate));
                                    dycAgrItemFuncBO.setSalePrice(dycAgrItemFuncBO.getBuyPrice().add(dycAgrItemFuncBO.getBuyPrice().multiply(dycAgrItemFuncBO.getMarkupRate().divide(new BigDecimal(100)))));
                                }
                            }
                        }
                    }
                }
                if (StringUtils.hasText((String)lineError.toString())) {
                    lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                }
            });
        }
    }

    private void importAgr(Integer salePriceGreateRule, List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrImportFuncReqBO reqBO) {
        reqBO.getAgrMain().forEach(dycAgrAgrMainImportFuncBO -> {
            HashMap<Integer, String> itemlineErrorMsgMap = new HashMap<Integer, String>();
            StringBuilder lineError = new StringBuilder();
            this.agrTransLate(lineError, (DycAgrAgrMainImportFuncBO)dycAgrAgrMainImportFuncBO, reqBO);
            if (ObjectUtil.isNotEmpty(dycAgrAgrMainImportFuncBO.getAgrItem())) {
                this.agrItemTranslate(salePriceGreateRule, dycAgrAgrMainImportFuncBO.getTradeMode(), dycAgrAgrMainImportFuncBO.getAgrItem(), itemlineErrorMsgMap);
                this.uccCheck(dycAgrAgrMainImportFuncBO.getAgrItem(), itemlineErrorMsgMap, dycAgrAgrMainImportFuncBO.getSupplierId());
                this.validPuplicate(dycAgrAgrMainImportFuncBO.getAgrItem(), itemlineErrorMsgMap, null);
            } else {
                lineError.append(",\u534f\u8bae\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            dycAgrAgrMainImportFuncBO.setAgrOrgName(reqBO.getOrgName());
            if (lineError.length() > 0 || itemlineErrorMsgMap.size() > 0) {
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append("\u534f\u8bae\u4e3b\u4f53\u4fe1\u606f\u884c\u3010" + dycAgrAgrMainImportFuncBO.getGluttonLineNum() + "\u3011");
                if (lineError.length() > 0) {
                    String mainError = lineError.toString().substring(1);
                    errorMsg.append(mainError);
                }
                if (itemlineErrorMsgMap.size() > 0) {
                    itemlineErrorMsgMap.forEach((k, v) -> {
                        String itemError = v.substring(1);
                        errorMsg.append("\u534f\u8bae\u660e\u7ec6\u884c\u3010" + k + "\u3011" + itemError);
                    });
                }
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setFailReason(errorMsg.toString());
                bo.setLineNum(dycAgrAgrMainImportFuncBO.getGluttonLineNum());
                failReasonBOs.add(bo);
            }
        });
        List lineNumList = failReasonBOs.stream().filter(a -> a.getLineNum() != null).map(a -> a.getLineNum()).collect(Collectors.toList());
        reqBO.getAgrMain().forEach(dycAgrAgrMainImportFuncBO -> {
            if (ObjectUtil.isEmpty((Object)lineNumList) || !lineNumList.contains(dycAgrAgrMainImportFuncBO.getGluttonLineNum())) {
                String key = "AGR_IMPORT_KEY_" + reqBO.getBatchNumber() + "_" + dycAgrAgrMainImportFuncBO.getAgrNo();
                AgrImportRedisRspBO agrImportRedisRsp = this.agrImportRedis.getAgrImportRedisRsp(key);
                dycAgrAgrMainImportFuncBO.setAgrId(agrImportRedisRsp.getNextId());
                if (agrImportRedisRsp.getExistFlag().booleanValue()) {
                    DycAgrAgrImportFuncReqBO dycAgrAgrImportFuncReqBO = new DycAgrAgrImportFuncReqBO();
                    dycAgrAgrImportFuncReqBO.setAgrId(agrImportRedisRsp.getNextId());
                    dycAgrAgrImportFuncReqBO.setAgrItem(dycAgrAgrMainImportFuncBO.getAgrItem());
                    this.saveAgrItem(dycAgrAgrImportFuncReqBO);
                } else {
                    AgrGetAgrCodeReqBO agrGetAgrCodeReqBO = (AgrGetAgrCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrGetAgrCodeReqBO.class);
                    AgrGetAgrCodeRspBO agrGetAgrCodeRspBO = this.agrGetAgrCodeService.getAgrCode(agrGetAgrCodeReqBO);
                    if (!"0000".equals(agrGetAgrCodeRspBO.getRespCode())) {
                        throw new ZTBusinessException(agrGetAgrCodeRspBO.getRespDesc());
                    }
                    dycAgrAgrMainImportFuncBO.setAgrCode(agrGetAgrCodeRspBO.getPlaAgreementCode());
                    this.saveAgr(salePriceGreateRule, (DycAgrAgrMainImportFuncBO)dycAgrAgrMainImportFuncBO, reqBO);
                }
            }
        });
    }

    private void saveAgr(Integer salePriceGreateRule, DycAgrAgrMainImportFuncBO agrMain, DycAgrAgrImportFuncReqBO reqBO) {
        AgrCreateAgrReqBo agrCreateAgrReqBo = (AgrCreateAgrReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrCreateAgrReqBo.class);
        AgrMainSaveBo agrMainSaveBO = new AgrMainSaveBo();
        BeanUtils.copyProperties((Object)agrMain, (Object)agrMainSaveBO);
        agrMainSaveBO.setCreateCompanyId(reqBO.getCompanyId());
        agrMainSaveBO.setCreateCompanyName(reqBO.getCompanyName());
        agrMainSaveBO.setCreateLoginId(reqBO.getUserId());
        agrMainSaveBO.setCreateName(reqBO.getName());
        agrMainSaveBO.setCreateUsername(reqBO.getUsername());
        agrMainSaveBO.setCreateOrgId(reqBO.getOrgId());
        agrMainSaveBO.setCreateOrgName(reqBO.getOrgName());
        agrMainSaveBO.setAgrOperatorId(reqBO.getUserId());
        agrMainSaveBO.setAgrOperatorName(reqBO.getName());
        agrMainSaveBO.setAgrOperatorUsername(reqBO.getUsername());
        agrMainSaveBO.setEffDate(DateUtils.strToDate((String)agrMain.getEffDate(), (String)"yyyy-MM-dd"));
        agrMainSaveBO.setExpDate(DateUtils.strToDate((String)agrMain.getExpDate(), (String)"yyyy-MM-dd"));
        agrMainSaveBO.setAgrSignTime(DateUtils.strToDate((String)agrMain.getAgrSignTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (ObjectUtil.isNotEmpty((Object)agrMain.getAgrAppScopeCode())) {
            ArrayList<AgrAppScopeBo> agrAppScopeBOs = new ArrayList<AgrAppScopeBo>();
            AgrAppScopeBo agrAppScopeBo = new AgrAppScopeBo();
            agrAppScopeBo.setScopeCode(agrMain.getAgrAppScopeCode());
            agrAppScopeBo.setScopeName(agrMain.getAgrAppScopeName() + "");
            agrAppScopeBOs.add(agrAppScopeBo);
            agrCreateAgrReqBo.setAgrAppScopeBOs(agrAppScopeBOs);
        } else if (CollUtil.isNotEmpty(agrMain.getAgrAppScopeBOs())) {
            agrCreateAgrReqBo.setAgrAppScopeBOs(JUtil.jsl(agrMain.getAgrAppScopeBOs(), AgrAppScopeBo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)agrMain.getPayTypePur())) {
            AgrPayConfigBo payTypePur = new AgrPayConfigBo();
            payTypePur.setPayType(agrMain.getPayTypePur());
            payTypePur.setAssign(agrMain.getAssignPur());
            payTypePur.setBusiNode(agrMain.getBusiNodePur());
            payTypePur.setCurrency(agrMain.getCurrencyPur());
            payTypePur.setMatPay(agrMain.getMatPayPur());
            payTypePur.setPilPay(agrMain.getPilPayPur());
            payTypePur.setPrePay(agrMain.getPrePayPur());
            payTypePur.setProPay(agrMain.getProPayPur());
            payTypePur.setQuaPay(agrMain.getQuaPayPur());
            payTypePur.setServiceRate(agrMain.getServiceRatePur());
            payTypePur.setSettlementDate(agrMain.getSettlementDatePur());
            payTypePur.setSettlementMonth(agrMain.getSettlementMonthPur());
            payTypePur.setTaxRate(agrMain.getTaxRatePur());
            payTypePur.setVerPay(agrMain.getVerPayPur());
            agrMainSaveBO.setPayTypePur(payTypePur);
        }
        if (ObjectUtil.isNotEmpty((Object)agrMain.getPayTypeSup())) {
            AgrPayConfigBo payTypeSup = new AgrPayConfigBo();
            payTypeSup.setPayType(agrMain.getPayTypeSup());
            payTypeSup.setAssign(agrMain.getAssignSup());
            payTypeSup.setBusiNode(agrMain.getBusiNodeSup());
            payTypeSup.setCurrency(agrMain.getCurrencySup());
            payTypeSup.setMatPay(agrMain.getMatPaySup());
            payTypeSup.setPilPay(agrMain.getPilPaySup());
            payTypeSup.setPrePay(agrMain.getPrePaySup());
            payTypeSup.setProPay(agrMain.getProPaySup());
            payTypeSup.setQuaPay(agrMain.getQuaPaySup());
            payTypeSup.setServiceRate(agrMain.getServiceRateSup());
            payTypeSup.setSettlementDate(agrMain.getSettlementDateSup());
            payTypeSup.setSettlementMonth(agrMain.getSettlementMonthSup());
            payTypeSup.setTaxRate(agrMain.getTaxRateSup());
            payTypeSup.setVerPay(agrMain.getVerPaySup());
            agrMainSaveBO.setPayTypeSup(payTypeSup);
        }
        if (ObjectUtil.isNotEmpty(agrMain.getAgrItem())) {
            agrCreateAgrReqBo.setAgrItem(JSON.parseArray((String)JSON.toJSONString(agrMain.getAgrItem()), AgrItemBo.class));
        }
        if (StrUtil.isNotEmpty((CharSequence)agrMain.getAccessoryUrl())) {
            AgrAccessoryBo agrAccessoryBo = new AgrAccessoryBo();
            agrAccessoryBo.setAccessoryUrl(agrMain.getAccessoryUrl());
            agrAccessoryBo.setAccessoryName(new File(agrAccessoryBo.getAccessoryUrl()).getName());
            agrAccessoryBo.setAttachmentType(AgrCommConstant.AccessoryObjType.AGR_MAIN);
            agrCreateAgrReqBo.setAgrAccessoryBOs(Collections.singletonList(agrAccessoryBo));
        }
        agrCreateAgrReqBo.setAgrMainSaveBO(agrMainSaveBO);
        AgrCreateAgrRspBo agrCreateAgrRspBo = this.agrCreateAgrService.createAgr(agrCreateAgrReqBo);
        if (!"0000".equals(agrCreateAgrRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u65b0\u589e\u8c03\u7528\u5931\u8d25" + agrCreateAgrRspBo.getRespDesc());
        }
    }

    private Integer dealSalePriceGreateRule() {
        CfcParamConfigBO bo;
        Integer salePriceGreateRule = 1;
        CfcQryParamConfigDetailAbilityReqBO abilityReqBO = new CfcQryParamConfigDetailAbilityReqBO();
        abilityReqBO.setParamConfigCode("agr_base_param");
        CfcQryParamConfigDetailAbilityRspBO cfcQryParamConfigDetailAbilityRspBO = this.cfcParamConfigAbilityService.qryParamConfigDetail(abilityReqBO);
        if (ObjectUtil.isNotEmpty((Object)cfcQryParamConfigDetailAbilityRspBO.getParamConfigBO()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(bo = cfcQryParamConfigDetailAbilityRspBO.getParamConfigBO()).getParamConfigItemList())) {
            for (CfcParamConfigItemBO cfcParamConfigItemBO : bo.getParamConfigItemList()) {
                if (!"agr_sale_price_rule".equals(cfcParamConfigItemBO.getItemCode())) continue;
                salePriceGreateRule = Integer.parseInt(cfcParamConfigItemBO.getItemValue());
            }
        }
        return salePriceGreateRule;
    }

    private void saveAgrItem(DycAgrAgrImportFuncReqBO reqBO) {
        AgrCreateAgrItemReqBo agrCreateAgrItemReqBo = (AgrCreateAgrItemReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrCreateAgrItemReqBo.class);
        AgrCreateAgrItemRspBo agrCreateAgrItemRspBo = this.agrCreateAgrItemService.createAgrItem(agrCreateAgrItemReqBo);
        if (!"0000".equals(agrCreateAgrItemRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u5931\u8d25" + agrCreateAgrItemRspBo.getRespDesc());
        }
    }

    private void uccCheck(List<DycAgrItemFuncBO> agrItem, Map<Integer, String> lineErrorMsgMap, Long supplierId) {
        List typeNames = agrItem.stream().filter(a -> !StringUtils.isEmpty((Object)a.getCommodityTypeName())).map(a -> a.getCommodityTypeName()).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(typeNames)) {
            UccQryCommodityTypeListAbilityReqBo uccQryCommodityTypeListAbilityReqBo = new UccQryCommodityTypeListAbilityReqBo();
            uccQryCommodityTypeListAbilityReqBo.setCommodityTypeNameList(typeNames);
            uccQryCommodityTypeListAbilityReqBo.setCommodityTypeStatus(Integer.valueOf(1));
            uccQryCommodityTypeListAbilityReqBo.setPageNo(1);
            uccQryCommodityTypeListAbilityReqBo.setPageSize(typeNames.size());
            UccQryCommodityTypeListAbilityRspBo uccQryCommodityTypeListAbilityRspBo = this.uccQryCommodityTypeListAbilityService.qryCommodityTypeList(uccQryCommodityTypeListAbilityReqBo);
            if (!"0000".equals(uccQryCommodityTypeListAbilityRspBo.getRespCode())) {
                throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u6821\u9a8c\u8c03\u7528\u5931\u8d25" + uccQryCommodityTypeListAbilityRspBo.getRespDesc());
            }
            Map<Object, Object> typeMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccQryCommodityTypeListAbilityRspBo.getRows())) {
                typeMap = uccQryCommodityTypeListAbilityRspBo.getRows().stream().collect(Collectors.toMap(a -> a.getCommodityTypeName(), a -> a, (first, second) -> first));
            }
            for (DycAgrItemFuncBO dycAgrItemFuncBO : agrItem) {
                UccQryCommodityTypeListAbilityBo bo = (UccQryCommodityTypeListAbilityBo)typeMap.get(dycAgrItemFuncBO.getCommodityTypeName());
                if (bo != null) {
                    dycAgrItemFuncBO.setCommodityTypeId(bo.getCommodityTypeId());
                    continue;
                }
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                lineError.append(",\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u505c\u7528");
                lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
            }
        }
    }

    private void validPuplicate(List<DycAgrItemFuncBO> agrItem, Map<Integer, String> lineErrorMsgMap, Long agrId) {
        ArrayList uniqueKeys = new ArrayList();
        HashMap uniqueKeyMap = new HashMap();
        agrItem.forEach(dycAgrItemFuncBO -> {
            String key = dycAgrItemFuncBO.getMaterialName();
            if (uniqueKeyMap.get(key) != null) {
                Integer gluttonLineNum = dycAgrItemFuncBO.getGluttonLineNum();
                StringBuilder lineError = new StringBuilder();
                String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                if (!StringUtils.isEmpty((Object)itemlineError)) {
                    lineError.append(itemlineError);
                }
                lineError.append(",\u5546\u54c1\u540d\u79f0\u91cd\u590d");
                lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
            } else {
                uniqueKeyMap.put(key, dycAgrItemFuncBO);
                uniqueKeys.add(key);
            }
        });
        if (uniqueKeys.size() > 0 && agrId != null) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrId(agrId);
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25" + agrGetAgrItemListRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                agrGetAgrItemListRspBO.getRows().forEach(agrItemDetailBo -> {
                    Integer gluttonLineNum = ((DycAgrItemFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getGluttonLineNum();
                    StringBuilder lineError = new StringBuilder();
                    String itemlineError = (String)lineErrorMsgMap.get(gluttonLineNum);
                    if (!StringUtils.isEmpty((Object)itemlineError)) {
                        lineError.append(itemlineError);
                    }
                    lineError.append(",\u5546\u54c1\u540d\u79f0\u91cd\u590d");
                    lineErrorMsgMap.put(gluttonLineNum, lineError.toString());
                });
            }
        }
    }

    private boolean ifCheckMaterial() {
        String agrSource = "";
        String materialRange = "";
        CfcQryParamConfigListAbilityReqBO cfcQryParamConfigListAbilityReqBO = new CfcQryParamConfigListAbilityReqBO();
        cfcQryParamConfigListAbilityReqBO.setParamConfigCode("agr_base_param");
        CfcQryParamConfigListAbilityRspBO cfcQryParamConfigListAbilityRspBO = this.cfcParamConfigAbilityService.qryParamConfigList(cfcQryParamConfigListAbilityReqBO);
        log.info("\u914d\u7f6e\u4e2d\u5fc3\u5ef6\u671f\u914d\u7f6e\u51fa\u53c2" + JSON.toJSONString((Object)cfcQryParamConfigListAbilityRspBO));
        List paramConfigItemList = cfcQryParamConfigListAbilityRspBO.getParamConfigItemList();
        if (paramConfigItemList != null && paramConfigItemList.size() > 0) {
            for (CfcParamConfigItemBO pib : paramConfigItemList) {
                if ("agr_source".equals(pib.getItemCode())) {
                    agrSource = pib.getItemValue();
                }
                if (!"agr_material_range".equals(pib.getItemCode())) continue;
                materialRange = pib.getItemValue();
            }
            if (!StringUtils.isEmpty((Object)agrSource) && agrSource.contains("1") && "1".equals(materialRange)) {
                return false;
            }
        }
        return true;
    }
}

