package com.tydic.dyc.pro.base.core.dictionary.enums;

/**
 * 协议明细是否创建商品 1是 0否
 *
 * @author ZHOUYUYAN
 */

public enum DmcAgrItemInitCommFlag implements DictionaryEnum {
    NO("DMC_AGR_ITEM_INIT_COMM_FLAG", "0", "未创建", "协议明细是否创建商品"),
    YES("DMC_AGR_ITEM_INIT_COMM_FLAG", "1", "已创建", "协议明细是否创建商品");
    /**
     * 编码
     */
    private String dictionaryCode;
    /**
     * 编码
     */
    private String code;
    /**
     * 编码值
     */
    private String value;
    /**
     * 名称
     */
    private String dictionaryName;

    DmcAgrItemInitCommFlag(String dictionaryCode, String code, String value, String dictionaryName) {
        this.dictionaryCode = dictionaryCode;
        this.code = code;
        this.value = value;
        this.dictionaryName = dictionaryName;
    }

    public String getDictionaryCode() {
        return dictionaryCode;
    }

    public String getDictionaryName() {
        return dictionaryName;
    }

    public String getCode() {
        return code;
    }

    @Override
    public String getValue() {
        return value;
    }
}
