/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.dictionary.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.tydic.dyc.base.core.dictionary.bo.DictDataBo;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.smc.dictionary.api.SmcQryConfigKeysDataListService;
import com.tydic.dyc.smc.dictionary.bo.SmcConfigKeyDictDataListBo;
import com.tydic.dyc.smc.dictionary.bo.SmcDictDataToConfigKeyBo;
import com.tydic.dyc.smc.dictionary.bo.SmcQryConfigKeysDataListReqBo;
import com.tydic.dyc.smc.dictionary.bo.SmcQryConfigKeysDataListRspBo;
import com.tydic.dyc.smc.po.SmcDictConfigPo;
import com.tydic.dyc.smc.repository.dictionary.api.SmcDictConfigRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.dictionary.api.SmcQryConfigKeysDataListService"})
public class SmcQryConfigKeysDataListServiceImpl
implements SmcQryConfigKeysDataListService {
    private static final Logger log = LoggerFactory.getLogger(SmcQryConfigKeysDataListServiceImpl.class);
    @Autowired
    private SmcDictConfigRepository smcDictConfigRepository;
    public static final String RSP_CODE_FAILURE = "9999";

    @Override
    @PostMapping(value={"qryConfigKeysDataList"})
    public SmcQryConfigKeysDataListRspBo qryConfigKeysDataList(@RequestBody SmcQryConfigKeysDataListReqBo reqBo) {
        SmcQryConfigKeysDataListRspBo rspBo = new SmcQryConfigKeysDataListRspBo();
        rspBo.setData1(new ArrayList<SmcConfigKeyDictDataListBo>());
        rspBo.setData(new HashMap<String, List<SmcDictDataToConfigKeyBo>>());
        if (reqBo.getConfigKeys() == null || CollectionUtils.isEmpty(reqBo.getConfigKeys())) {
            rspBo.setRespCode(RSP_CODE_FAILURE);
            rspBo.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBo;
        }
        List dictConfigList = this.smcDictConfigRepository.list((Wrapper)new LambdaQueryWrapper().in(SmcDictConfigPo::getConfigKey, reqBo.getConfigKeys()));
        for (SmcDictConfigPo smcDictConfigPo : dictConfigList) {
            SmcConfigKeyDictDataListBo smcConfigKeyDictDataListBo = new SmcConfigKeyDictDataListBo();
            smcConfigKeyDictDataListBo.setConfigKey(smcDictConfigPo.getConfigKey());
            List<DictDataBo> dictDataListPo = DictFrameworkUtils.getListByCenterAndPCode((String)smcDictConfigPo.getBusiCenter(), (String)smcDictConfigPo.getPCode()).stream().sorted(Comparator.comparing(DictDataBo::getSort)).collect(Collectors.toList());
            List<SmcDictDataToConfigKeyBo> configList = this.cacheBoToConfigBo(dictDataListPo);
            smcConfigKeyDictDataListBo.setCodeList(configList);
            rspBo.getData1().add(smcConfigKeyDictDataListBo);
            rspBo.getData().put(smcDictConfigPo.getConfigKey(), configList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public List<SmcDictDataToConfigKeyBo> cacheBoToConfigBo(List<DictDataBo> cacheList) {
        ArrayList<SmcDictDataToConfigKeyBo> configList = new ArrayList<SmcDictDataToConfigKeyBo>();
        if (!CollectionUtils.isEmpty(cacheList)) {
            cacheList.forEach(d -> {
                SmcDictDataToConfigKeyBo data = new SmcDictDataToConfigKeyBo();
                data.setDelflag(0);
                data.setSysCode(d.getBusiCenter());
                data.setPCode(d.getPCode());
                data.setCode(d.getCode());
                data.setTitle(d.getValue());
                data.setOrderId(d.getSort());
                data.setDescrip(d.getRemark());
                configList.add(data);
            });
        }
        return configList;
    }
}

