/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.shippingAddress.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.SmcIdUtil;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.base.utils.StrUtil;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.po.SmcUmcShippingAddressPo;
import com.tydic.dyc.smc.repository.shippingAddress.api.SmcUmcShippingAddressRepository;
import com.tydic.dyc.smc.shippingAddress.api.SmcUmcAddShippingAddressService;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcAddShippingAddressReqBO;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcAddShippingAddressRspBO;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.shippingAddress.api.SmcUmcAddShippingAddressService"})
public class SmcUmcAddShippingAddressServiceImpl
implements SmcUmcAddShippingAddressService {
    @Autowired
    private SmcUmcShippingAddressRepository smcUmcShippingAddressRepository;
    @Value(value="${umc.shippingAddress.dataAuth.value:1}")
    private String dataAuth;

    @Override
    @PostMapping(value={"addShippingAddress"})
    public SmcUmcAddShippingAddressRspBO addShippingAddress(@RequestBody SmcUmcAddShippingAddressReqBO reqBO) {
        SmcUmcAddShippingAddressRspBO rspBO = (SmcUmcAddShippingAddressRspBO)SmcRu.success(SmcUmcAddShippingAddressRspBO.class);
        this.val(reqBO);
        this.valDataRepeat(reqBO);
        List<SmcUmcShippingAddressPo> list = this.valExistsDefaultAddress(reqBO, rspBO);
        this.cancelDefault(reqBO, list);
        this.saveInfo(reqBO, rspBO);
        return rspBO;
    }

    private void cancelDefault(SmcUmcAddShippingAddressReqBO reqBO, List<SmcUmcShippingAddressPo> list) {
        if (SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES.equals(reqBO.getIsDefault())) {
            for (SmcUmcShippingAddressPo po : list) {
                po.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_NO);
                this.smcUmcShippingAddressRepository.updateById((Object)po);
            }
        }
    }

    private void saveInfo(SmcUmcAddShippingAddressReqBO reqBO, SmcUmcAddShippingAddressRspBO rspBO) {
        StrUtil.noNullStringAttr((Object)((Object)reqBO));
        SmcUmcShippingAddressPo save = (SmcUmcShippingAddressPo)SmcRu.js((Object)((Object)reqBO), SmcUmcShippingAddressPo.class);
        save.setId(Long.valueOf(SmcIdUtil.nextId()));
        save.setAreaName(save.getShippingProvinceName() + save.getShippingCityName() + save.getShippingCountyName() + (StringUtils.isBlank((CharSequence)save.getShippingTownName()) ? "" : save.getShippingTownName()) + save.getShippingAddress());
        SmcRu.setCreate((Object)((Object)reqBO), (Object)save);
        if (!this.smcUmcShippingAddressRepository.save((Object)save)) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5931\u8d25");
        }
        rspBO.setId(save.getId());
    }

    private List<SmcUmcShippingAddressPo> valExistsDefaultAddress(SmcUmcAddShippingAddressReqBO reqBO, SmcUmcAddShippingAddressRspBO rspBO) {
        QueryWrapper queryDefaultWrapper = new QueryWrapper();
        queryDefaultWrapper.eq((Object)SmcUmcAddShippingAddressServiceImpl.toDatabaseColumnName("isDefault"), (Object)SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
        if ("1".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_USER_ID", (Object)reqBO.getUserId());
        } else if ("2".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_ORG_ID", (Object)reqBO.getOrgId());
        } else if ("3".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_COMPANY_ID", (Object)reqBO.getOrgId());
        }
        queryDefaultWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        List list = this.smcUmcShippingAddressRepository.list((Wrapper)queryDefaultWrapper);
        if (ObjectUtil.isEmpty((Object)list)) {
            reqBO.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
            rspBO.setIsMainFlag(true);
        }
        return list;
    }

    private void valDataRepeat(SmcUmcAddShippingAddressReqBO reqBO) {
        QueryWrapper queryRepeatWrapper = new QueryWrapper();
        Stream.of(SmcUmcAddShippingAddressReqBO.class.getDeclaredFields()).filter(field -> field.getName().startsWith("shipping")).forEach(field -> {
            try {
                field.setAccessible(true);
                String fieldName = SmcUmcAddShippingAddressServiceImpl.toDatabaseColumnName(field.getName());
                Object fieldValue = field.get((Object)reqBO);
                if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
                    queryRepeatWrapper.eq((Object)fieldName, fieldValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        if ("1".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_USER_ID", (Object)reqBO.getUserId());
        } else if ("2".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_ORG_ID", (Object)reqBO.getOrgId());
        } else if ("3".equals(this.dataAuth)) {
            queryRepeatWrapper.eq((Object)"CREATE_COMPANY_ID", (Object)reqBO.getOrgId());
        }
        queryRepeatWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        List list = this.smcUmcShippingAddressRepository.list((Wrapper)queryRepeatWrapper);
        if (list != null && !list.isEmpty()) {
            throw new ZTBusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u6536\u8d27\u5730\u5740\u4fe1\u606f");
        }
    }

    public static String toDatabaseColumnName(String fieldName) {
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = true;
        for (int i = 0; i < fieldName.length(); ++i) {
            char currentChar = fieldName.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                if (i != 0) {
                    result.append('_');
                }
                result.append(Character.toUpperCase(currentChar));
                capitalizeNext = false;
                continue;
            }
            if (Character.isLowerCase(currentChar)) {
                if (capitalizeNext) {
                    result.append(Character.toUpperCase(currentChar));
                    continue;
                }
                result.append(currentChar);
                continue;
            }
            result.append(currentChar);
            capitalizeNext = false;
        }
        return result.toString().toUpperCase();
    }

    private void val(SmcUmcAddShippingAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u6536\u8d27\u4eba[shippingName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingProvinceId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u7701\u7f16\u7801[shippingProvinceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingProvinceName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u7701\u540d\u79f0[shippingProvinceName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCityId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u5e02\u7f16\u7801[shippingCityId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCityName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u5e02\u540d\u79f0[shippingCityName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCountyId())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u533a\u53bf\u7f16\u7801[shippingCountyId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingCountyName())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u533a\u53bf\u540d\u79f0[shippingCountyName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingAddress())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u8be6\u7ec6\u5730\u5740[shippingAddress]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShippingMobile())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u624b\u673a\u53f7\u7801[shippingMobile]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getIsDefault())) {
            throw new ZTBusinessException("\u65b0\u589e\u6536\u8d27\u5730\u5740\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u5730\u5740[isDefault]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

