/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.shippingAddress.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.smc.constants.SmcUmcConstants;
import com.tydic.dyc.smc.po.SmcUmcShippingAddressPo;
import com.tydic.dyc.smc.repository.shippingAddress.api.SmcUmcShippingAddressRepository;
import com.tydic.dyc.smc.shippingAddress.api.SmcUmcSetDefaultShippingAddressService;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcSetDefaultShippingAddressReqBO;
import com.tydic.dyc.smc.shippingAddress.bo.SmcUmcSetDefaultShippingAddressRspBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.shippingAddress.api.SmcUmcSetDefaultShippingAddressService"})
public class SmcUmcSetDefaultShippingAddressServiceImpl
implements SmcUmcSetDefaultShippingAddressService {
    @Autowired
    private SmcUmcShippingAddressRepository smcUmcShippingAddressRepository;
    @Value(value="${umc.shippingAddress.dataAuth.value:1}")
    private String dataAuth;

    @Override
    @PostMapping(value={"setDefaultShippingAddress"})
    public SmcUmcSetDefaultShippingAddressRspBO setDefaultShippingAddress(@RequestBody SmcUmcSetDefaultShippingAddressReqBO reqBO) {
        this.val(reqBO);
        this.valExistsAddress(reqBO);
        List<SmcUmcShippingAddressPo> list = this.valExistsDefaultAddress(reqBO);
        this.cancelDefault(list);
        this.setDefaultInfo(reqBO);
        return (SmcUmcSetDefaultShippingAddressRspBO)SmcRu.success(SmcUmcSetDefaultShippingAddressRspBO.class);
    }

    private void cancelDefault(List<SmcUmcShippingAddressPo> list) {
        if (ObjectUtil.isNotEmpty(list)) {
            for (SmcUmcShippingAddressPo po : list) {
                po.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_NO);
                this.smcUmcShippingAddressRepository.updateById((Object)po);
            }
        }
    }

    private void setDefaultInfo(SmcUmcSetDefaultShippingAddressReqBO reqBO) {
        SmcUmcShippingAddressPo delete = (SmcUmcShippingAddressPo)SmcRu.js((Object)((Object)reqBO), SmcUmcShippingAddressPo.class);
        delete.setIsDefault(SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
        SmcRu.setUpdate((Object)((Object)reqBO), (Object)delete);
        if (!this.smcUmcShippingAddressRepository.updateById((Object)delete)) {
            throw new ZTBusinessException("\u8bbe\u7f6e\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u5931\u8d25");
        }
    }

    private void valExistsAddress(SmcUmcSetDefaultShippingAddressReqBO reqBO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ID", (Object)reqBO.getId());
        queryWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        SmcUmcShippingAddressPo umcShippingAddressPo = (SmcUmcShippingAddressPo)this.smcUmcShippingAddressRepository.getOne((Wrapper)queryWrapper);
        if (ObjectUtil.isEmpty((Object)umcShippingAddressPo)) {
            throw new ZTBusinessException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u6536\u8d27\u5730\u5740");
        }
    }

    private List<SmcUmcShippingAddressPo> valExistsDefaultAddress(SmcUmcSetDefaultShippingAddressReqBO reqBO) {
        QueryWrapper queryDefaultWrapper = new QueryWrapper();
        queryDefaultWrapper.eq((Object)"IS_DEFAULT", (Object)SmcUmcConstants.ShippingAddressIsDefault.IS_DEFAULT_YES);
        if ("1".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_USER_ID", (Object)reqBO.getUserId());
        } else if ("2".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_ORG_ID", (Object)reqBO.getOrgId());
        } else if ("3".equals(this.dataAuth)) {
            queryDefaultWrapper.eq((Object)"CREATE_COMPANY_ID", (Object)reqBO.getOrgId());
        }
        queryDefaultWrapper.eq((Object)"DEL_FLAG", (Object)"0");
        return this.smcUmcShippingAddressRepository.list((Wrapper)queryDefaultWrapper);
    }

    private void val(SmcUmcSetDefaultShippingAddressReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getId())) {
            throw new ZTBusinessException("\u8bbe\u7f6e\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u5165\u53c2\u4e3b\u952e[id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

