/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.user.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alipay.sofa.sofamq.org.shade.apache.commons.lang.time.DateUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.SmcAesEcbUtil;
import com.tydic.dyc.base.utils.SmcPasswordUtils;
import com.tydic.dyc.base.utils.SmcRu;
import com.tydic.dyc.smc.repository.user.api.SmcUmcUserInfoRepository;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcCustInfoDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoDO;
import com.tydic.dyc.smc.repository.user.bo.SmcUmcUserInfoQryDO;
import com.tydic.dyc.smc.user.api.SmcUmcUpdatePasswordService;
import com.tydic.dyc.smc.user.bo.SmcUmcUpdatePasswordReqBO;
import com.tydic.dyc.smc.user.bo.SmcUmcUpdatePasswordRspBO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SMC_GROUP/4.0.0/com.tydic.dyc.smc.user.api.SmcUmcUpdatePasswordService"})
public class SmcUmcUpdatePasswordServiceImpl
implements SmcUmcUpdatePasswordService {
    @Autowired
    private SmcUmcUserInfoRepository umcUserInfoRepository;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${password_eff:90}")
    private Integer password_eff;
    @Autowired
    private SmcPasswordUtils passwordUtils;

    @Override
    @PostMapping(value={"updatePassword"})
    public SmcUmcUpdatePasswordRspBO updatePassword(@RequestBody SmcUmcUpdatePasswordReqBO reqBO) {
        SmcUmcUpdatePasswordServiceImpl.val(reqBO);
        SmcUmcUserInfoDO umcUserInfoDO = this.valExistsUser(reqBO);
        this.updateInfo(reqBO, umcUserInfoDO);
        return (SmcUmcUpdatePasswordRspBO)SmcRu.success(SmcUmcUpdatePasswordRspBO.class);
    }

    private void updateInfo(SmcUmcUpdatePasswordReqBO reqBO, SmcUmcUserInfoDO umcUserInfoDO) {
        String decryptNewPwd = SmcAesEcbUtil.decryptStr((String)reqBO.getNewPassword(), (String)this.ORIGINAL_KEY);
        if (StringUtils.isBlank((CharSequence)decryptNewPwd)) {
            throw new ZTBusinessException("\u65b0\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25");
        }
        SmcUmcCustInfoDO updateCustInfo = new SmcUmcCustInfoDO();
        updateCustInfo.setCustId(umcUserInfoDO.getCustId());
        updateCustInfo.setPasswd(this.passwordUtils.buildPassword(decryptNewPwd, umcUserInfoDO.getPasswordSalt()));
        updateCustInfo.setPasswordEffDate(DateUtils.addDays((Date)new Date(), (int)this.password_eff));
        updateCustInfo.setUpdateOperId(reqBO.getUserId());
        updateCustInfo.setUpdateOperName(reqBO.getName());
        updateCustInfo.setUpdateTime(new Date());
        this.umcUserInfoRepository.updateCustInfo(updateCustInfo);
    }

    private SmcUmcUserInfoDO valExistsUser(SmcUmcUpdatePasswordReqBO reqBO) {
        SmcUmcUserInfoQryDO userInfoQryDO = new SmcUmcUserInfoQryDO();
        userInfoQryDO.setUserId(reqBO.getUserId());
        SmcUmcUserInfoDO umcUserInfoDO = this.umcUserInfoRepository.qryUserInfoDetail(userInfoQryDO);
        if (ObjectUtil.isEmpty((Object)umcUserInfoDO)) {
            throw new ZTBusinessException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return umcUserInfoDO;
    }

    private static void val(SmcUmcUpdatePasswordReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO))) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getNewPassword())) {
            throw new ZTBusinessException("\u3010newPassword\u3011\u4e3a\u7a7a");
        }
    }
}

