/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.smc.constants;

public class SmcTodoConstants {

    public static enum SendFlag {
        YES(1, "\u662f"),
        NO(0, "\u5426");

        private final int code;
        private final String description;

        private SendFlag(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (SendFlag sendFlag : SendFlag.values()) {
                if (sendFlag.getCode() != code) continue;
                return sendFlag.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum DeleteFlag {
        DELETED(1, "\u5df2\u5220\u9664"),
        NOT_DELETED(0, "\u672a\u5220\u9664");

        private final int code;
        private final String description;

        private DeleteFlag(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (DeleteFlag deleteFlag : DeleteFlag.values()) {
                if (deleteFlag.getCode() != code) continue;
                return deleteFlag.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum TodoShopShow {
        YES(1, "\u662f"),
        NO(0, "\u5426");

        private final int code;
        private final String description;

        private TodoShopShow(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (TodoShopShow todoShopShow : TodoShopShow.values()) {
                if (todoShopShow.getCode() != code) continue;
                return todoShopShow.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum PushFlag {
        PUSH(1, "\u63a8\u9001"),
        NOT_PUSH(0, "\u4e0d\u63a8\u9001");

        private final int code;
        private final String description;

        private PushFlag(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (PushFlag pushFlag : PushFlag.values()) {
                if (pushFlag.getCode() != code) continue;
                return pushFlag.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum ReceiveUserTag {
        OPERATIONS(0, "\u8fd0\u8425"),
        PURCHASING(1, "\u91c7\u8d2d"),
        SUPPLIER(2, "\u4f9b\u5e94\u5546");

        private final int code;
        private final String description;

        private ReceiveUserTag(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (ReceiveUserTag receiveUserTag : ReceiveUserTag.values()) {
                if (receiveUserTag.getCode() != code) continue;
                return receiveUserTag.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum ReceiveUserType {
        DOCUMENT_CREATOR(1, "\u5355\u636e\u521b\u5efa\u4eba"),
        SPECIFIED_ROLE(2, "\u6307\u5b9a\u63a5\u6536\u4eba\u89d2\u8272"),
        SPECIFIED_ROLE_AND_ORGANIZATION(3, "\u6307\u5b9a\u63a5\u6536\u4eba\u89d2\u8272+\u673a\u6784"),
        SPECIFIED_FIELD(4, "\u6307\u5b9a\u63a5\u6536\u4eba\u5b57\u6bb5\u540d");

        private final int code;
        private final String description;

        private ReceiveUserType(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (ReceiveUserType receiveUserType : ReceiveUserType.values()) {
                if (receiveUserType.getCode() != code) continue;
                return receiveUserType.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum SendUserType {
        DOCUMENT_CREATOR(1, "\u5355\u636e\u521b\u5efa\u4eba"),
        DEFAULT_SENDER(2, "\u9ed8\u8ba4\u53d1\u9001\u4eba"),
        CURRENT_OPERATOR(3, "\u5f53\u524d\u64cd\u4f5c\u4eba");

        private final int code;
        private final String description;

        private SendUserType(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (SendUserType sendUserType : SendUserType.values()) {
                if (sendUserType.getCode() != code) continue;
                return sendUserType.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum DoneType {
        BUSINESS_TODO(1, "\u4e1a\u52a1\u5f85\u529e"),
        APPROVE_TODO(2, "\u5ba1\u6279\u5f85\u529e"),
        REVOCATION(3, "\u64a4\u9500");

        private final int code;
        private final String description;

        private DoneType(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (DoneType doneType : DoneType.values()) {
                if (doneType.getCode() != code) continue;
                return doneType.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum DoneRange {
        CURRENT_HANDLER(1, "\u5f53\u524d\u5904\u7406\u4eba"),
        ITEM_AND_CURRENT_HANDLER(2, "\u4e8b\u9879+\u5f53\u524d\u5904\u7406\u4eba");

        private final int code;
        private final String description;

        private DoneRange(int code, String description) {
            this.code = code;
            this.description = description;
        }

        public int getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(int code) {
            for (DoneRange doneRange : DoneRange.values()) {
                if (doneRange.getCode() != code) continue;
                return doneRange.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum DocumentType {
        AGR_1("AGR", 1, "\u534f\u8bae"),
        AGR_2("AGR", 2, "\u534f\u8bae\u53d8\u66f4"),
        AGR_9("AGR", 9, "\u5ba1\u6279\u5355"),
        UCC_1("UCC", 1, "\u5355\u54c1"),
        UOC_1("UOC", 1, "\u8ba2\u5355"),
        UOC_2("UOC", 2, "\u9500\u552e\u5355"),
        UOC_4("UOC", 4, "\u53d1\u8d27\u5355"),
        UOC_6("UOC", 6, "\u552e\u540e\u5355"),
        UOC_9("UOC", 9, "\u5ba1\u6279\u5355"),
        UOC_10("UOC", 10, "\u53d8\u66f4\u5355"),
        FSC_1("FSC", 1, "\u7ed3\u7b97\u5355"),
        FSC_2("FSC", 2, "\u5ba1\u6279\u5355");

        private final String centerCode;
        private final int documentTypeCode;
        private final String description;

        private DocumentType(String centerCode, int documentTypeCode, String description) {
            this.centerCode = centerCode;
            this.documentTypeCode = documentTypeCode;
            this.description = description;
        }

        public String getCenterCode() {
            return this.centerCode;
        }

        public int getDocumentTypeCode() {
            return this.documentTypeCode;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getCenterCodeByDocumentTypeCode(int documentTypeCode) {
            for (DocumentType documentType : DocumentType.values()) {
                if (documentType.getDocumentTypeCode() != documentTypeCode) continue;
                return documentType.getCenterCode();
            }
            return "\u672a\u77e5";
        }

        public static String getDescriptionByCode(String centerCode, int documentTypeCode) {
            for (DocumentType documentType : DocumentType.values()) {
                if (!documentType.getCenterCode().equals(centerCode) || documentType.getDocumentTypeCode() != documentTypeCode) continue;
                return documentType.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static enum Center {
        AGR("AGR", "\u534f\u8bae"),
        UCC("UCC", "\u5546\u54c1"),
        UOC("UOC", "\u8ba2\u5355"),
        FSC("FSC", "\u7ed3\u7b97");

        private final String code;
        private final String description;

        private Center(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public static String getDescriptionByCode(String code) {
            for (Center center : Center.values()) {
                if (!center.getCode().equals(code)) continue;
                return center.getDescription();
            }
            return "\u672a\u77e5";
        }
    }

    public static final class codeType {
        public static final String objType = "objType";
        public static final String todoType = "todoType";
        public static final String sendUserType = "sendUserType";
        public static final String receiveUserType = "receivedUserType";
        public static final String receiveUserTag = "receiveUserTag";
        public static final String doneRange = "doneRange";
        public static final String doneType = "doneType";
        public static final String center = "center";
    }
}

