/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uec.advice;

import java.util.Collections;
import java.util.HashMap;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Aspect
@Component
@Order(value=10)
public class ServiceTransactionAdvice {
    private static final String TRANSACTION_POINTCUT = "execution(* com.tydic.uec.busi..*(..))";
    private static final String NON_TRANSACTION_POINTCUT = "execution(* com.tydic.uec.ability..*(..)) || execution(* com.tydic.uec.atom..*(..))";
    private final PlatformTransactionManager transactionManager;

    @Autowired
    public ServiceTransactionAdvice(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Bean
    public TransactionInterceptor txAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute();
        requireRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requireRule.setPropagationBehavior(0);
        requireRule.setTimeout(5);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(16);
        txMap.put("add*", requireRule);
        txMap.put("save*", requireRule);
        txMap.put("create*", requireRule);
        txMap.put("update*", requireRule);
        txMap.put("delete*", requireRule);
        txMap.put("remove*", requireRule);
        txMap.put("deal*", requireRule);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
    }

    @Bean
    public TransactionInterceptor nonTxAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setReadOnly(true);
        readOnlyRule.setPropagationBehavior(4);
        HashMap<String, RuleBasedTransactionAttribute> txMap = new HashMap<String, RuleBasedTransactionAttribute>(4);
        txMap.put("*", readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor nonTxAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(NON_TRANSACTION_POINTCUT);
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.nonTxAdvice());
    }
}

